/*
 * Decompiled with CFR 0.152.
 */
package net.didion.loopy;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import net.didion.loopy.AbstractFileSystem;
import net.didion.loopy.FileEntry;
import net.didion.loopy.VolumeDescriptorSet;

public abstract class AbstractBlockFileSystem
extends AbstractFileSystem {
    private final int blockSize;
    private final int reservedBlocks;
    private VolumeDescriptorSet volumeDescriptorSet;

    protected AbstractBlockFileSystem(File file, boolean readOnly, int blockSize, int reservedBlocks) throws IOException {
        super(file, readOnly);
        if (blockSize <= 0) {
            throw new IllegalArgumentException("'blockSize' must be > 0");
        }
        if (reservedBlocks < 0) {
            throw new IllegalArgumentException("'reservedBlocks' must be >= 0");
        }
        this.blockSize = blockSize;
        this.reservedBlocks = reservedBlocks;
    }

    @Override
    public Enumeration getEntries() {
        this.ensureOpen();
        if (null == this.volumeDescriptorSet) {
            try {
                this.loadVolumeDescriptors();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.enumerate(this.volumeDescriptorSet.getRootEntry());
    }

    protected void loadVolumeDescriptors() throws IOException {
        byte[] buffer = new byte[this.blockSize];
        this.volumeDescriptorSet = this.createVolumeDescriptorSet();
        int block = this.reservedBlocks;
        while (this.readBlock(block, buffer) && !this.volumeDescriptorSet.deserialize(buffer)) {
            ++block;
        }
    }

    protected boolean readBlock(long block, byte[] buffer) throws IOException {
        int bytesRead = this.readData(block * (long)this.blockSize, buffer, 0, this.blockSize);
        if (bytesRead <= 0) {
            return false;
        }
        if (this.blockSize != bytesRead) {
            throw new IOException("Could not deserialize a complete block");
        }
        return true;
    }

    protected synchronized int readData(long startPos, byte[] buffer, int offset, int len) throws IOException {
        this.seek(startPos);
        return this.read(buffer, offset, len);
    }

    protected VolumeDescriptorSet getVolumeDescriptorSet() {
        return this.volumeDescriptorSet;
    }

    protected abstract Enumeration enumerate(FileEntry var1);

    protected abstract VolumeDescriptorSet createVolumeDescriptorSet();
}

