/*
 * Decompiled with CFR 0.152.
 */
package logOld;

import build.Core;
import downloads.common;
import java.io.File;
import java.util.ArrayList;
import logOld.Hooks;
import logOld.LogEntry;
import utils.Settings;
import utils.files;
import utils.time;

public class LogOld {
    private String title = "";
    private Boolean outputToScreen = true;
    long TimeStart = System.currentTimeMillis();
    Settings translation;
    Boolean doTranslation = false;
    ArrayList<LogEntry> list = new ArrayList();
    public Hooks hooks;
    LogEntry latest = null;

    public LogOld(String title) {
        this.title = title;
        this.hooks = new Hooks();
    }

    private void write1(int code, String message, String[] args) {
        if (message.isEmpty()) {
            return;
        }
        if (code == 1001) {
            this.hooks.process(message);
            return;
        }
        LogEntry newEntry = new LogEntry(code, message, args);
        this.list.add(newEntry);
        if (this.doTranslation.booleanValue() && code != 1000) {
            this.addTranslation(message);
        }
        if (this.outputToScreen.booleanValue()) {
            System.out.println(time.getTimeFromLong(newEntry.getTime()) + " " + newEntry.getMessage());
        }
        this.hooks.process(message);
        if (this.latest != null && newEntry != null && !this.latest.getMessageSimple().equalsIgnoreCase(newEntry.getMessageSimple())) {
            ArrayList<Hooks.Hook> selectedHooks = this.hooks.hookList.get(this.hooks.perMessage);
            for (Hooks.Hook hook : selectedHooks) {
                Core.sys.script.run(hook.script, hook.method);
            }
        }
        this.latest = newEntry;
    }

    public void print(String message, Boolean writeTranslation) {
        LogEntry newEntry = new LogEntry(message);
        this.list.add(newEntry);
        if (writeTranslation.booleanValue()) {
            this.addTranslation(message);
        }
        if (Core.sys.uiAvailable == 0) {
            System.out.println(message);
        }
        this.latest = newEntry;
    }

    public void print(String message) {
        this.print(message, false);
    }

    public long getCounter() {
        return this.list.size();
    }

    public ArrayList<LogEntry> getList() {
        return this.list;
    }

    public LogEntry getLatest() {
        return this.latest;
    }

    public String getMessagesSince(long lastCounter) {
        String output = "";
        int counter = -1;
        for (LogEntry newEntry : this.list) {
            if ((long)(++counter) < lastCounter) continue;
            if (newEntry.getResult() == 32) {
                output = output.concat(newEntry.getMessage() + "\n");
                continue;
            }
            output = output.concat(time.getTimeFromLongNoDate(newEntry.getTime()) + " " + newEntry.getMessage() + "\n");
        }
        return output;
    }

    public void setOutputToScreen(Boolean outputToScreen) {
        this.outputToScreen = outputToScreen;
    }

    public void EnableTranslator(String languageID, String description) {
        File folderTranslation = common.getFolderTranslations();
        files.mkdirs(folderTranslation);
        File fileTranslation = new File(folderTranslation, "lang-" + languageID + ".xml");
        this.translation = new Settings(fileTranslation, description);
        this.doTranslation = true;
    }

    void addTranslation(String message) {
        if (!this.translation.hasKey(message).booleanValue()) {
            this.translation.write(message, message);
        }
    }

    public void write(int code, String message) {
        String[] text2 = new String[]{};
        this.write1(code, message, text2);
    }

    public void write(int code, String message, String arg1) {
        String[] text2 = new String[]{arg1};
        this.write1(code, message, text2);
    }

    public void write(int code, String message, String arg1, String arg2) {
        String[] text2 = new String[]{arg1, arg2};
        this.write1(code, message, text2);
    }

    public void write(int code, String message, String arg1, String arg2, String arg3) {
        String[] text2 = new String[]{arg1, arg2, arg3};
        this.write1(code, message, text2);
    }

    public void write(int code, String message, String arg1, String arg2, String arg3, String arg4) {
        String[] text2 = new String[]{arg1, arg2, arg3, arg4};
        this.write1(code, message, text2);
    }

    public void write(int code, String message, String arg1, String arg2, String arg3, String arg4, String arg5) {
        String[] text2 = new String[]{arg1, arg2, arg3, arg4, arg5};
        this.write1(code, message, text2);
    }
}

