/*
 * Decompiled with CFR 0.152.
 */
package logOld;

import definitions.is;
import utils.time;

public class LogEntry {
    private int result;
    private boolean doSpeech = false;
    private boolean doFileLog = false;
    private boolean doBeep = false;
    private boolean doStartBeep = false;
    private String message;
    private String[] args;
    private Boolean hasArgs = false;
    private final long time = System.currentTimeMillis();

    public boolean setSpeech(boolean val) {
        this.doSpeech = val;
        return val;
    }

    public boolean setFileLog(boolean val) {
        this.doFileLog = val;
        return val;
    }

    public boolean setBeep(boolean val) {
        this.doBeep = val;
        return val;
    }

    public boolean setStartBeep(boolean val) {
        this.doStartBeep = val;
        return val;
    }

    public boolean getSpeech() {
        return this.doSpeech;
    }

    public boolean getBeep() {
        return this.doBeep;
    }

    public boolean getStartBeep() {
        return this.doStartBeep;
    }

    public boolean getFileLog() {
        return this.doFileLog;
    }

    public LogEntry(int code, String message, String ... args) {
        this.message = message;
        this.result = code;
        this.args = args;
        this.hasArgs = true;
    }

    public LogEntry(int code, String message) {
        this.message = message;
        this.result = code;
        this.args = null;
    }

    public LogEntry(String message, boolean isArt) {
        this.message = message;
        this.result = !isArt ? 32 : 37;
        this.args = null;
    }

    public LogEntry(String message) {
        this.message = message;
        this.result = 32;
        this.args = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convert() {
        String output = this.message.replace("%", "%!%");
        int count = 1;
        try {
            while (output.contains("%!%")) {
                output = output.replace("%!%" + count, this.args[count - 1]);
                ++count;
            }
        }
        catch (Exception e) {
            output = output.replace("%!%", "%");
            return output;
        }
        finally {
            return output;
        }
    }

    public String getMessage() {
        String output = this.message;
        if (this.result == 32) {
            output = this.convert();
            return output;
        }
        if (this.hasArgs.booleanValue()) {
            output = "[" + is.translated(this.result) + "] " + this.convert();
        }
        return output;
    }

    public String getMessageSimple() {
        String output = this.message;
        if (this.result == 32) {
            output = this.convert();
            return output;
        }
        if (this.hasArgs.booleanValue()) {
            output = this.convert();
        }
        return output;
    }

    public String getTimeReadable() {
        String output = utils.time.getTimeFromLong(this.time);
        return output;
    }

    public int getResult() {
        return this.result;
    }

    public long getTime() {
        return this.time;
    }
}

