/*
 * Decompiled with CFR 0.152.
 */
package licenses;

import build.Core;
import downloads.common;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import reg.Converter;
import utils.Settings;
import utils.files;
import win7pecore.WinPeLibrary;

public class RegistrationLib {
    final String certKeyTag = "CertificationKey";
    final String certIssuerTag = "CertificationIssuer";
    final String certDateTag = "CertificationDate";
    final String certStatusTag = "CurrentUserStatus";
    final String currentUserTag = "CurrentUser";
    String certKey;
    String certIssuer;
    String certDate;
    String currentUserStatus;
    String currentUser;
    private String baseDir;
    private String ownerName = "";
    private KeyStatus keyStatus;
    private String message;
    private Settings pluginSettings;

    public RegistrationLib(String base) {
        this.baseDir = "".equals(base) ? System.getProperty("appDir") : base;
    }

    public void setPeLibrary(WinPeLibrary peLib) {
        String res = "reboot.pro.wbc";
        File theWBC = new File(this.baseDir, "reboot.pro.wbc");
        boolean existed = theWBC.exists();
        KeyStatus highestStatus = KeyStatus.INVALID;
        String highestOwner = "";
        File[] fileList = new File(this.baseDir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith("wbc");
            }
        });
        this.keyStatus = KeyStatus.MISSING;
        if (fileList.length == 0) {
            Core.sys.getClass();
            if (!existed) {
                File temp = peLib.copyResourceToTempFile("reboot.pro.wbc");
                try {
                    FileUtils.moveFile(temp, theWBC);
                    fileList = new File(this.baseDir).listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.getName().toLowerCase().endsWith("wbc");
                        }
                    });
                }
                catch (IOException ex) {
                    Logger.getLogger(RegistrationLib.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        for (File file : fileList) {
            KeyStatus actual;
            String name = file.getName().replace(".wbc", "").replace(".resources.", "");
            byte[] content = files.readAsBytes(file);
            byte[] digest = this.getDigest(name);
            byte[] content81 = this.scramble(digest, true);
            byte[] ownerKey = this.scramble(digest, false);
            if (this.getPos(content, content81) + this.getPos(content, ownerKey) == this.doPos(content)) {
                if (name.endsWith("_Pro")) {
                    actual = KeyStatus.PROFESSIONAL;
                    name = name.replace("_Pro", "");
                } else if (name.endsWith("_Client")) {
                    actual = KeyStatus.CLIENT;
                    name = name.replace("_Client", "");
                } else {
                    actual = name.equals("pscEx") ? KeyStatus.GURU : (name.equals("Nuno Brito") ? KeyStatus.GURU : (!name.equals("reboot.pro") ? KeyStatus.DEVELOPER : KeyStatus.USER));
                }
            } else {
                actual = KeyStatus.INVALID;
            }
            if (actual.ordinal() <= this.keyStatus.ordinal()) continue;
            this.keyStatus = actual;
            this.ownerName = name;
            if (actual.ordinal() <= highestStatus.ordinal()) continue;
            highestStatus = actual;
            highestOwner = name;
            Core.temp.put("CurrentUser", highestOwner);
            Core.temp.put("CurrentUserStatus", highestStatus);
        }
    }

    private byte[] getDigest(String original) {
        return this.getDigest(original.getBytes());
    }

    private byte[] getDigest(byte[] original) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(original);
            byte[] digest = md.digest();
            return digest;
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(RegistrationLib.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    int ord(char ch) {
        return ch;
    }

    final int doPos(byte[] inp) {
        char ch = (char)inp[2];
        if (ch >= '0' && ch <= '9') {
            return this.ord(ch) - this.ord('0') + 33;
        }
        return this.ord(ch) - this.ord('a') + 43;
    }

    final byte[] scramble(byte[] D, boolean is81) {
        int j;
        int index;
        byte[] test;
        int offs;
        char[] Digits = new char[]{'4', '5', '6', '7', 'c', 'd', '8', '9', '0', '1', '2', '3', 'a', 'b', 'e', 'f', '4', '5', 'a', '7', 'c', 'd', '8', '9', '0', 'e', '2', '3', '6', 'b', '1', 'f'};
        byte[] result = new byte[D.length * 2];
        if (!is81) {
            offs = 0;
            test = D;
        } else {
            offs = 16;
            index = 0;
            test = new byte[D.length];
            for (j = 0; j < 16; ++j) {
                int i = D[j] + 123;
                test[index++] = (byte)i;
            }
        }
        index = 0;
        for (j = 15; j >= 0; --j) {
            byte val = test[j];
            char val1 = Digits[(val >> 4 & 0xF) + offs];
            String str1 = "" + val1;
            char val2 = Digits[(val & 0xF) + offs];
            String str2 = "" + val2;
            result[index++] = (byte)str1.charAt(0);
            result[index++] = (byte)str2.charAt(0);
        }
        return result;
    }

    final int getPos(byte[] theArray, byte[] subArray) {
        int pos = -1;
        for (int o = 0; o < theArray.length - subArray.length; ++o) {
            int s;
            for (s = 0; s < subArray.length && theArray[o + s] == subArray[s]; ++s) {
            }
            if (s != subArray.length) continue;
            pos = o;
            break;
        }
        return pos;
    }

    public String getOwner() {
        return (String)Core.temp.get("CurrentUser");
    }

    public String getRegistrationInfo() {
        if (this.isProfessional()) {
            return "Registered to " + Core.temp.get("CurrentUser");
        }
        if (Core.temp.get("CurrentUserStatus") == KeyStatus.INVALID) {
            return "Invalid registration";
        }
        return null;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public KeyStatus getStatus() {
        return (KeyStatus)((Object)Core.temp.get("CurrentUserStatus"));
    }

    public boolean isRegistered() {
        return ((KeyStatus)((Object)Core.temp.get("CurrentUserStatus"))).ordinal() > KeyStatus.INVALID.ordinal();
    }

    public boolean isProfessional() {
        return ((KeyStatus)((Object)Core.temp.get("CurrentUserStatus"))).ordinal() > KeyStatus.PROFESSIONAL.ordinal();
    }

    public boolean isGuru() {
        return ((KeyStatus)((Object)Core.temp.get("CurrentUserStatus"))).ordinal() > KeyStatus.GURU.ordinal();
    }

    public String getMessage() {
        return this.message;
    }

    String createCertificationKey(List<String> content) {
        String res = "";
        for (String line : content) {
            res = res + line;
        }
        byte[] md5 = this.getDigest(res);
        byte[] scramb = this.scramble(md5, false);
        String key = new String(scramb);
        return key;
    }

    public String getHashVal(File candidate) {
        byte[] content = files.readAsBytes(candidate);
        byte[] md5 = this.getDigest(content);
        byte[] scramb = this.scramble(md5, false);
        String key = new String(scramb);
        return key;
    }

    void writeCertification(String plugin) {
        List<String> content = files.readAsLines(new File(plugin));
        this.certKey = this.createCertificationKey(content);
        this.certDate = new SimpleDateFormat("yyyy-MMM-dd", new Locale("US")).format(new Date());
        this.certIssuer = this.ownerName;
        this.pluginSettings.write("CertificationKey", this.certKey);
        this.pluginSettings.write("CertificationIssuer", this.certIssuer);
        this.pluginSettings.write("CertificationDate", this.certDate);
    }

    public boolean checkLogo(File logo) {
        int offsetPointer = 10;
        int infoStart = 14;
        byte[] content = files.readAsBytes(logo);
        int infoLen = Converter.byteArrayToInt(content, 14);
        int techOffset = 14 + infoLen;
        int realOffset = Converter.byteArrayToInt(content, 10);
        byte[] info = new byte[infoLen];
        System.arraycopy(content, 14, info, 0, infoLen);
        int diff = realOffset - techOffset;
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(this.ownerName);
        keys.add(new String(info));
        byte[] md5 = this.getDigest(this.ownerName + new String(info));
        byte[] actKey = this.scramble(md5, false);
        int keyLen = actKey.length;
        if (diff == 0) {
            if (!this.isProfessional()) {
                this.message = "Logo not certified";
                return false;
            }
        } else {
            byte[] compare = new byte[keyLen];
            System.arraycopy(content, techOffset, compare, 0, keyLen);
            if (!Arrays.equals(actKey, compare)) {
                if (!this.isProfessional()) {
                    this.message = "Invalid logo certification";
                    return false;
                }
            } else {
                return true;
            }
        }
        byte[] newMap = new byte[content.length + keyLen - diff];
        System.arraycopy(content, 0, newMap, 0, techOffset);
        System.arraycopy(actKey, 0, newMap, techOffset, keyLen);
        System.arraycopy(content, techOffset + diff, newMap, techOffset + keyLen, content.length - techOffset - diff);
        Converter.intToByteArray(techOffset + keyLen, newMap, 10);
        files.writeAllBytes(logo, newMap);
        return true;
    }

    public boolean checkCertification(String plugin, CertifyAction correct) {
        return this.checkCertification(plugin, null, correct);
    }

    public boolean checkCertification(String plugin) {
        return this.checkCertification(plugin, null, CertifyAction.REPORT);
    }

    public boolean checkCertification(String plugin, File pluginCache, CertifyAction correct) {
        boolean isDev;
        File setFile;
        int result = 0;
        File setDir = new File(plugin).getParentFile();
        String name = setDir.getName();
        int pos = name.indexOf("-");
        String ID = name.substring(0, pos);
        if (pluginCache == null) {
            pluginCache = common.getFolderCache();
        }
        if (!(setFile = new File(pluginCache, "settings-" + ID + ".xml")).exists()) {
            String settingsPath = plugin.replace("main.bsh", "settings.xml");
            File oriSettings = new File(settingsPath);
            files.copyFile(oriSettings, setFile);
        }
        this.pluginSettings = new Settings(setFile, "");
        this.certKey = this.pluginSettings.read("CertificationKey", "");
        this.certIssuer = this.pluginSettings.read("CertificationIssuer", "");
        this.certDate = this.pluginSettings.read("CertificationDate", "");
        if (this.certIssuer.equals("")) {
            this.message = "Missing certification";
            result = 1;
        } else {
            List<String> content = files.readAsLines(new File(plugin));
            String keyShould = this.createCertificationKey(content);
            if (!this.certKey.equals(keyShould)) {
                this.message = "Invalid certification";
                result = 2;
            }
        }
        boolean bl = isDev = this.getStatus().ordinal() >= KeyStatus.PROFESSIONAL.ordinal();
        if (!isDev) {
            return result == 0;
        }
        if (result == 0) {
            this.message = this.certIssuer + " " + this.certDate;
            if (correct == CertifyAction.ALL) {
                this.writeCertification(plugin);
                this.message = this.message + "  -> " + this.certIssuer + " " + this.certDate + " Renewed";
            }
        } else if (correct == CertifyAction.UPDATE) {
            this.writeCertification(plugin);
            this.message = this.message + " -> " + this.certIssuer + " " + this.certDate + " Corrected";
            result = 0;
        }
        return result == 0;
    }

    File[] getPlugins(File theDir) {
        File[] fileList = theDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        return fileList;
    }

    public String[] listCertifyStatus(CertifyAction action) {
        String[] messages2 = null;
        File[] fileList = this.getPlugins(common.getFolderDownloads());
        if (fileList.length > 0) {
            messages2 = new String[fileList.length - 1];
            int index = 0;
            for (File file : fileList) {
                File cand = new File(file, "main.bsh");
                if (!cand.exists()) continue;
                this.checkCertification(cand.getAbsolutePath(), null, action);
                String entry = file.getName();
                int x = entry.lastIndexOf(45);
                if (x != -1) {
                    entry = entry.substring(x + 1);
                }
                while (entry.length() < 35) {
                    entry = entry + " ";
                }
                messages2[index++] = entry + ": " + this.getMessage();
            }
        }
        return messages2;
    }

    public void createDeveloperKey(String owner) throws FileNotFoundException, IOException {
        Calendar cal = Calendar.getInstance();
        cal.add(14, 728);
        int mill = cal.get(14);
        cal.add(14, 496);
        int mill1 = cal.get(14);
        cal.add(14, 283);
        int mill2 = cal.get(14);
        cal.add(14, 933);
        int mill3 = cal.get(14);
        byte[] digest = this.getDigest(String.format("%03d", mill) + String.format("%03d", mill1) + String.format("%03d", mill2) + String.format("%03d", mill3));
        byte[] rand1 = this.scramble(digest, true);
        cal.add(14, 728);
        mill = cal.get(14);
        cal.add(14, 496);
        mill1 = cal.get(14);
        cal.add(14, 283);
        mill2 = cal.get(14);
        cal.add(14, 933);
        mill3 = cal.get(14);
        digest = this.getDigest(String.format("%03d", mill) + String.format("%03d", mill1) + String.format("%03d", mill2) + String.format("%03d", mill3));
        byte[] rand2 = this.scramble(digest, true);
        cal.add(14, 728);
        mill = cal.get(14);
        cal.add(14, 496);
        mill1 = cal.get(14);
        cal.add(14, 283);
        mill2 = cal.get(14);
        cal.add(14, 933);
        mill3 = cal.get(14);
        digest = this.getDigest(String.format("%03d", mill) + String.format("%03d", mill1) + String.format("%03d", mill2) + String.format("%03d", mill3));
        byte[] rand3 = this.scramble(digest, true);
        cal.add(14, 728);
        mill = cal.get(14);
        cal.add(14, 496);
        mill1 = cal.get(14);
        cal.add(14, 283);
        mill2 = cal.get(14);
        cal.add(14, 933);
        mill3 = cal.get(14);
        digest = this.getDigest(String.format("%03d", mill) + String.format("%03d", mill1) + String.format("%03d", mill2) + String.format("%03d", mill3));
        byte[] rand4 = this.scramble(digest, true);
        byte[] all = new byte[4 * rand1.length];
        System.arraycopy(rand1, 0, all, 0 * rand1.length, rand1.length);
        System.arraycopy(rand2, 0, all, 1 * rand1.length, rand1.length);
        System.arraycopy(rand3, 0, all, 2 * rand1.length, rand1.length);
        System.arraycopy(rand4, 0, all, 3 * rand1.length, rand1.length);
        byte[] tmp = this.getDigest(owner);
        byte[] res = this.scramble(tmp, true);
        int i = this.doPos(all);
        byte[] code = new byte[144];
        int cp = 0;
        System.arraycopy(all, 0, code, cp, i + 1);
        System.arraycopy(res, 0, code, cp += i + 1, 32);
        System.arraycopy(all, i - 1, code, cp += 32, code.length - cp);
        File trg = new File(this.baseDir);
        trg = new File(trg, owner + ".wbc");
        String target = trg.getAbsolutePath();
        FileOutputStream fos = new FileOutputStream(target);
        fos.write(code);
        fos.close();
    }

    public static void main(String[] args) {
        File base = new File("V:\\WB2_A\\WB2\\winbuilder\\run");
        RegistrationLib ownerInfo = new RegistrationLib(base.getAbsolutePath());
        ownerInfo.setPeLibrary(new WinPeLibrary(null));
        try {
            ownerInfo.createDeveloperKey("pscExx");
        }
        catch (IOException ex) {
            Logger.getLogger(RegistrationLib.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static enum CertifyAction {
        REPORT,
        ALL,
        UPDATE,
        CREATE;

    }

    public static enum KeyStatus {
        MISSING,
        INVALID,
        USER,
        CLIENT,
        PROFESSIONAL,
        DEVELOPER,
        GURU;

    }
}

