/*
 * Decompiled with CFR 0.152.
 */
package licenses;

import bsh2java.log;
import commands.Command;
import java.util.ArrayList;
import licenses.License;

public final class CommandCREDITS
extends Command {
    ArrayList<License> list = new ArrayList();

    void addKnownLicenses() {
        this.addLicense("Apache Commons", "Reusable Java components", "Apache 2.0", "http://commons.apache.org/", "The Apache Software Foundation");
        this.addLicense("BeanShell", "Java-like scripting language", "LGPL", "http://www.beanshell.org/", "Pat Niemeyer");
        this.addLicense("JBinding", "Java 7-Zip all-platforms wrapper", "LGPL", "http://sourceforge.net/projects/sevenzipjbind/", "Boris Brodski");
        this.addLicense("JIIC", "Java ISO Image Creator", "LGPL", "http://jiic.berlios.de/", "Jens Hatlak");
        this.addLicense("SimpleFramework", "HTTP server", "LGPL", "http://www.simpleframework.org/", "Niallg");
        this.addLicense("ReWIM", "Native java handling of Microsoft WIM achives", "Proprietary", "http://reboot.pro/", "GuuJiang");
        this.addLicense("ReLink", "Native java creation of Windows shortcuts", "Proprietary", "http://reboot.pro/", "Brandon Fergerson");
        this.addLicense("Winbuilder", "Probably the best builder in the world.", "Proprietary", "http://winbuilder.net/", "Nuno Brito and Peter Schlang");
        this.addLicense("Icon: Terminal-6", "Icon used for the console button", "Proprietary", "http://www.veryicon.com/icons/internet--web/mac-os-x-developers/terminal-6.html", "Matt Ball");
        this.addLicense("Icon set by dAKirby309", "Windows 8 Metro Icons", "CC Attribution 3.0 Unported", "http://dakirby309.deviantart.com/", "dAKirby309");
        this.addLicense("Zip4j", "Open-source library to handle Zip files", "Apache 2.0", "http://www.lingala.net/zip4j/", "Srikanth Reddy Lingala");
        this.addLicense("FreeTTS", "A speech synthesizer written entirely in the Java programming language", "Proprietary", "http://freetts.sourceforge.net", "Speech Integration Group of Sun Microsystems Laboratories");
        this.addLicense("jBittorrentAPI", "Java implementation of the bittorrent protocol", "GNU 2.0", "https://http://sourceforge.net/projects/bitext", "Baptiste Dubuis");
    }

    public CommandCREDITS() {
        this.addKnownLicenses();
    }

    @Override
    public String keyword() {
        return "CREDITS";
    }

    @Override
    public String description() {
        return "Lists the credits and licenses of resources used in this software";
    }

    @Override
    public String syntaxExample() {
        return "";
    }

    @Override
    public void action() {
        for (License license : this.list) {
            log.print("\n- " + license.title + ", " + license.shortDescription + "\n" + "-- License: " + license.licenseTerms + "\n" + "-- " + license.author + ", " + license.URL + "\n" + "-----------");
        }
    }

    @Override
    public void subCommandsProcess() {
    }

    @Override
    public void subCommandsCreate() {
    }

    public void addLicense(String title, String shortDescription, String licenseTerms, String URL2, String author) {
        License temp = new License();
        temp.title = title;
        temp.shortDescription = shortDescription;
        temp.licenseTerms = licenseTerms;
        temp.URL = URL2;
        temp.author = author;
        this.list.add(temp);
    }

    public void addLicense(License license) {
        this.list.add(license);
    }
}

