/*
 * Decompiled with CFR 0.152.
 */
package licenses;

import bsh2java.log;
import build.Core;
import commands.Command;
import commands.SubCommand;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import licenses.RegistrationLib;

public class CommandCERTIFY
extends Command {
    private SubCommand cmdUpdate;
    private SubCommand cmdAll;
    private SubCommand cmdCreate;

    @Override
    public String keyword() {
        return "CERTIFY";
    }

    @Override
    public String description() {
        return "Handles plugin certifications";
    }

    @Override
    public void action() {
        this.performAction(RegistrationLib.CertifyAction.REPORT);
    }

    void performAction(RegistrationLib.CertifyAction action) {
        String[] messages2 = Core.sys.registrationLib.listCertifyStatus(action);
        String list = "";
        for (String entry : messages2) {
            list = list.concat("\n" + entry);
        }
        log.print("\nList of currently installed plugins' certification status" + list);
    }

    void performAction(RegistrationLib.CertifyAction action, String arguments) {
        arguments = arguments.substring(this.keyword().length()).trim();
        if (action == RegistrationLib.CertifyAction.CREATE) {
            try {
                Core.sys.registrationLib.createDeveloperKey(arguments);
            }
            catch (IOException ex) {
                Logger.getLogger(CommandCERTIFY.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void subCommandsProcess() {
        if (this.cmdUpdate.isChosen(this.parameters)) {
            this.performAction(RegistrationLib.CertifyAction.UPDATE);
            return;
        }
        if (this.cmdAll.isChosen(this.parameters)) {
            this.performAction(RegistrationLib.CertifyAction.ALL);
            return;
        }
        if (Core.sys.registrationLib.getStatus().ordinal() == RegistrationLib.KeyStatus.GURU.ordinal() && this.cmdCreate.isChosen(this.parameters)) {
            this.performAction(RegistrationLib.CertifyAction.CREATE, this.parameters);
            return;
        }
        log.write(-1, "Invalid option");
    }

    @Override
    public void subCommandsCreate() {
        this.cmdAll = new SubCommand();
        this.cmdAll.keyword = "ALL";
        this.cmdAll.descriptionShort = "(Re-)Certifies all installed plugins";
        this.cmdAll.descriptionLong = "";
        this.cmdAll.syntaxExample = "- Example to certify all installed plugins: \n" + this.keyword() + " " + this.cmdAll.keyword;
        this.subCommandAdd(this.cmdAll);
        this.cmdUpdate = new SubCommand();
        this.cmdUpdate.keyword = "UPDATE";
        this.cmdUpdate.descriptionShort = "Certifies installed plugins with missing or invalid certification";
        this.cmdUpdate.descriptionLong = "";
        this.cmdUpdate.syntaxExample = "- Example to update certifications: \n" + this.keyword() + " " + this.cmdUpdate.keyword;
        this.subCommandAdd(this.cmdUpdate);
        if (Core.sys.registrationLib.getStatus().ordinal() == RegistrationLib.KeyStatus.GURU.ordinal()) {
            this.cmdCreate = new SubCommand();
            this.cmdCreate.keyword = "CREATE";
            this.cmdCreate.descriptionShort = "Creates developer's *.wbc key";
            this.cmdCreate.descriptionLong = "";
            this.cmdCreate.syntaxExample = "- Example to create a key for 'memberX': \n" + this.keyword() + " " + this.cmdCreate.keyword + " memberX";
            this.subCommandAdd(this.cmdCreate);
        }
    }

    @Override
    public String syntaxExample() {
        return "- Example to view all currently installed plugins' certification status:\n" + this.keyword() + "\n\n";
    }
}

