/*
 * Decompiled with CFR 0.152.
 */
package jBittorrentAPI_v1_0;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.BitSet;
import java.util.Random;

public class Utils {
    public static String byteToHex(byte data) {
        StringBuffer buf = new StringBuffer();
        buf.append(Utils.toHexChar(data >>> 4 & 0xF));
        buf.append(Utils.toHexChar(data & 0xF));
        return buf.toString();
    }

    public static String bytesToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            buf.append(Utils.byteToHex(data[i]));
        }
        return buf.toString();
    }

    public static char toHexChar(int i) {
        if (0 <= i && i <= 9) {
            return (char)(48 + i);
        }
        return (char)(97 + (i - 10));
    }

    public static String byteArrayToURLString(byte[] in) {
        byte ch = 0;
        int i = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer out = new StringBuffer(in.length * 2);
        while (i < in.length) {
            if (in[i] >= 48 && in[i] <= 57 || in[i] >= 97 && in[i] <= 122 || in[i] >= 65 && in[i] <= 90 || in[i] == 36 || in[i] == 45 || in[i] == 95 || in[i] == 46 || in[i] == 33) {
                out.append((char)in[i]);
                ++i;
                continue;
            }
            out.append('%');
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
            ++i;
        }
        String rslt = new String(out);
        return rslt;
    }

    public static String byteArrayToByteString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer out = new StringBuffer(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        String rslt = new String(out);
        return rslt;
    }

    public static byte[] intToByteArray(int value) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
        }
        return b;
    }

    public static int byteArrayToInt(byte[] b) {
        if (b.length == 4) {
            return b[0] << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        }
        if (b.length == 2) {
            return 0 | (b[0] & 0xFF) << 8 | b[1] & 0xFF;
        }
        return 0;
    }

    public static int byteToUnsignedInt(byte b) {
        return 0 | b & 0xFF;
    }

    public static byte[] intToByteArray4(int i) {
        return new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
    }

    public static byte[] hash(ByteBuffer hashThis) {
        try {
            byte[] hash = new byte[20];
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(hashThis);
            return md.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static byte[] hash(byte[] hashThis) {
        try {
            byte[] hash = new byte[20];
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            hash = md.digest(hashThis);
            return hash;
        }
        catch (NoSuchAlgorithmException nsae) {
            System.err.println("SHA-1 algorithm is not available...");
            System.exit(2);
            return null;
        }
    }

    public static byte[] generateID() {
        byte[] id = new byte[12];
        Random r = new Random(System.currentTimeMillis());
        r.nextBytes(id);
        return Utils.concat("-BE0001-".getBytes(), id);
    }

    public static byte[] concat2(byte[] a, byte[] b) {
        ByteBuffer bb = ByteBuffer.allocate(a.length + b.length);
        bb.put(a);
        bb.put(b);
        return bb.array();
    }

    public static byte[] concat(byte[] b1, byte[] b2) {
        byte[] b3 = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, b3, 0, b1.length);
        System.arraycopy(b2, 0, b3, b1.length, b2.length);
        return b3;
    }

    public static byte[] concat(byte[] b1, byte b2) {
        byte[] b3 = new byte[b1.length + 1];
        byte[] temp = new byte[]{b2};
        System.arraycopy(b1, 0, b3, 0, b1.length);
        System.arraycopy(temp, 0, b3, b1.length, 1);
        return b3;
    }

    public static final long unsignedIntToLong(byte[] b) {
        long l = 0L;
        l |= (long)(b[0] & 0xFF);
        l <<= 8;
        l |= (long)(b[1] & 0xFF);
        l <<= 8;
        l |= (long)(b[2] & 0xFF);
        l <<= 8;
        return l |= (long)(b[3] & 0xFF);
    }

    public static boolean[] byteArray2BitArray(byte[] bytes) {
        boolean[] bits = new boolean[bytes.length * 8];
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[i / 8] & 1 << 7 - i % 8) <= 0) continue;
            bits[i] = true;
        }
        return bits;
    }

    public static byte[] subArray(byte[] b, int offset, int length) {
        byte[] sub = new byte[length];
        for (int i = offset; i < offset + length; ++i) {
            sub[i - offset] = b[i];
        }
        return sub;
    }

    public static boolean bytesCompare(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static void copy(byte[] in, byte[] out) {
        for (int i = 0; i < out.length && i < in.length; ++i) {
            out[i] = in[i];
        }
    }

    public static byte[] toByteArray(BitSet bits) {
        byte[] bytes = new byte[bits.length() / 8 + 1];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = i / 8;
            bytes[n] = (byte)(bytes[n] | 1 << 7 - i % 8);
        }
        return bytes;
    }
}

