/*
 * Decompiled with CFR 0.152.
 */
package jBittorrentAPI_v1_0;

import jBittorrentAPI_v1_0.BDecoder;
import jBittorrentAPI_v1_0.BEncoder;
import jBittorrentAPI_v1_0.IOManager;
import jBittorrentAPI_v1_0.TorrentFile;
import jBittorrentAPI_v1_0.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TorrentProcessor {
    private TorrentFile torrent;

    public TorrentProcessor(TorrentFile torrent) {
        this.torrent = torrent;
    }

    public TorrentProcessor() {
        this.torrent = new TorrentFile();
    }

    public Map parseTorrent(String filename) {
        return this.parseTorrent(new File(filename));
    }

    public Map parseTorrent(File file) {
        try {
            return BDecoder.decode(IOManager.readBytesFromFile(file));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public TorrentFile getTorrentFile(Map m) {
        if (m == null) {
            return null;
        }
        if (!m.containsKey("announce")) {
            return null;
        }
        this.torrent.announceURL = new String((byte[])m.get("announce"));
        if (m.containsKey("comment")) {
            this.torrent.comment = new String((byte[])m.get("comment"));
        }
        if (m.containsKey("created by")) {
            this.torrent.createdBy = new String((byte[])m.get("created by"));
        }
        if (m.containsKey("creation date")) {
            this.torrent.creationDate = (Long)m.get("creation date");
        }
        if (m.containsKey("encoding")) {
            this.torrent.encoding = new String((byte[])m.get("encoding"));
        }
        if (m.containsKey("info")) {
            int i;
            Map info = (Map)m.get("info");
            try {
                this.torrent.info_hash_as_binary = Utils.hash(BEncoder.encode(info));
                this.torrent.info_hash_as_hex = Utils.byteArrayToByteString(this.torrent.info_hash_as_binary);
                this.torrent.info_hash_as_url = Utils.byteArrayToURLString(this.torrent.info_hash_as_binary);
            }
            catch (IOException ioe) {
                return null;
            }
            if (info.containsKey("name")) {
                this.torrent.saveAs = new String((byte[])info.get("name"));
            }
            if (!info.containsKey("piece length")) {
                return null;
            }
            this.torrent.pieceLength = ((Long)info.get("piece length")).intValue();
            if (info.containsKey("pieces")) {
                byte[] piecesHash2 = (byte[])info.get("pieces");
                if (piecesHash2.length % 20 != 0) {
                    return null;
                }
                for (i = 0; i < piecesHash2.length / 20; ++i) {
                    byte[] temp = Utils.subArray(piecesHash2, i * 20, 20);
                    this.torrent.piece_hash_values_as_binary.add(temp);
                    this.torrent.piece_hash_values_as_hex.add(Utils.byteArrayToByteString(temp));
                    this.torrent.piece_hash_values_as_url.add(Utils.byteArrayToURLString(temp));
                }
            } else {
                return null;
            }
            if (info.containsKey("files")) {
                List multFiles = (List)info.get("files");
                this.torrent.total_length = 0L;
                for (i = 0; i < multFiles.size(); ++i) {
                    this.torrent.length.add(((Long)((Map)multFiles.get(i)).get("length")).intValue());
                    this.torrent.total_length += (long)((Long)((Map)multFiles.get(i)).get("length")).intValue();
                    List path = (List)((Map)multFiles.get(i)).get("path");
                    String filePath = "";
                    for (int j = 0; j < path.size(); ++j) {
                        filePath = filePath + new String((byte[])path.get(j));
                    }
                    this.torrent.name.add(filePath);
                }
            } else {
                this.torrent.length.add(((Long)info.get("length")).intValue());
                this.torrent.total_length = ((Long)info.get("length")).intValue();
                this.torrent.name.add(new String((byte[])info.get("name")));
            }
        } else {
            return null;
        }
        return this.torrent;
    }

    public void setTorrent(TorrentFile torr) {
        this.torrent = torr;
    }

    public void setTorrentData(String url, int pLength, String comment, String encoding, String filename) {
        this.torrent.announceURL = url;
        this.torrent.pieceLength = pLength * 1024;
        this.torrent.createdBy = "jBittorrentAPI 1.0";
        this.torrent.comment = comment;
        this.torrent.creationDate = System.currentTimeMillis();
        this.torrent.encoding = encoding;
        this.addFile(filename);
    }

    public void setTorrentData(String url, int pLength, String comment, String encoding, String name, List filenames) throws Exception {
        this.torrent.announceURL = url;
        this.torrent.pieceLength = pLength * 1024;
        this.torrent.comment = comment;
        this.torrent.createdBy = "jBittorrentAPI 1.0";
        this.torrent.creationDate = System.currentTimeMillis();
        this.torrent.encoding = encoding;
        this.torrent.saveAs = name;
        this.addFiles(filenames);
    }

    public void setAnnounceURL(String url) {
        this.torrent.announceURL = url;
    }

    public void setPieceLength(int length) {
        this.torrent.pieceLength = length * 1024;
    }

    public void setName(String name) {
        this.torrent.saveAs = name;
    }

    public void setComment(String comment) {
        this.torrent.comment = comment;
    }

    public void setCreator(String creator) {
        this.torrent.createdBy = creator;
    }

    public void setCreationDate(long date) {
        this.torrent.creationDate = date;
    }

    public void setEncoding(String encoding) {
        this.torrent.encoding = encoding;
    }

    public int addFiles(List l) throws Exception {
        return this.addFiles(l.toArray());
    }

    public int addFile(File file) {
        return this.addFiles(new File[]{file});
    }

    public int addFile(String filename) {
        return this.addFiles(new String[]{filename});
    }

    public int addFiles(Object[] filenames) {
        int nbFileAdded = 0;
        if (this.torrent.total_length == -1L) {
            this.torrent.total_length = 0L;
        }
        for (int i = 0; i < filenames.length; ++i) {
            File f = null;
            if (filenames[i] instanceof String) {
                f = new File((String)filenames[i]);
            } else if (filenames[i] instanceof File) {
                f = (File)filenames[i];
            }
            if (f == null || !f.exists()) continue;
            this.torrent.total_length += f.length();
            this.torrent.name.add(f.getPath());
            this.torrent.length.add(new Long(f.length()).intValue());
            ++nbFileAdded;
        }
        return nbFileAdded;
    }

    public void generatePieceHashes(TorrentFile torr) {
        ByteBuffer bb = ByteBuffer.allocate(torr.pieceLength);
        boolean index = false;
        long total = 0L;
        torr.piece_hash_values_as_binary.clear();
        for (int i = 0; i < torr.name.size(); ++i) {
            total += (long)((Integer)torr.length.get(i)).intValue();
            File f = new File((String)torr.name.get(i));
            if (!f.exists()) continue;
            try {
                FileInputStream fis = new FileInputStream(f);
                int read = 0;
                byte[] data = new byte[torr.pieceLength];
                while ((read = fis.read(data, 0, bb.remaining())) != -1) {
                    bb.put(data, 0, read);
                    if (bb.remaining() != 0) continue;
                    torr.piece_hash_values_as_binary.add(Utils.hash(bb.array()));
                    bb.clear();
                }
                continue;
            }
            catch (FileNotFoundException fnfe) {
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (bb.remaining() != bb.capacity()) {
            torr.piece_hash_values_as_binary.add(Utils.hash(Utils.subArray(bb.array(), 0, bb.capacity() - bb.remaining())));
        }
    }

    public void generatePieceHashes() {
        this.generatePieceHashes(this.torrent);
    }

    public byte[] generateTorrent(TorrentFile torr) {
        int i;
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("announce", torr.announceURL);
        if (torr.comment.length() > 0) {
            map.put("comment", torr.comment);
        }
        if (torr.creationDate >= 0L) {
            map.put("creation date", torr.creationDate);
        }
        if (torr.createdBy.length() > 0) {
            map.put("created by", torr.createdBy);
        }
        TreeMap<String, Object> info = new TreeMap<String, Object>();
        if (torr.name.size() == 1) {
            info.put("length", (Integer)torr.length.get(0));
            info.put("name", new File((String)torr.name.get(0)).getName());
        } else {
            if (!torr.saveAs.matches("")) {
                info.put("name", torr.saveAs);
            } else {
                info.put("name", "noDirSpec");
            }
            ArrayList files2 = new ArrayList();
            for (i = 0; i < torr.name.size(); ++i) {
                int j;
                TreeMap<String, Serializable> file = new TreeMap<String, Serializable>();
                file.put("length", (Integer)torr.length.get(i));
                String[] path = ((String)torr.name.get(i)).split("\\\\");
                File f = new File((String)torr.name.get(i));
                ArrayList<String> pathList = new ArrayList<String>(path.length);
                int n = j = path.length > 1 ? 1 : 0;
                while (j < path.length) {
                    pathList.add(path[j]);
                    ++j;
                }
                file.put("path", pathList);
                files2.add(file);
            }
            info.put("files", files2);
        }
        info.put("piece length", torr.pieceLength);
        byte[] pieces = new byte[]{};
        for (i = 0; i < torr.piece_hash_values_as_binary.size(); ++i) {
            pieces = Utils.concat(pieces, (byte[])torr.piece_hash_values_as_binary.get(i));
        }
        info.put("pieces", pieces);
        map.put("info", info);
        try {
            byte[] data = BEncoder.encode(map);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] generateTorrent() {
        return this.generateTorrent(this.torrent);
    }

    public TorrentFile getTorrent() {
        return this.torrent;
    }
}

