/*
 * Decompiled with CFR 0.152.
 */
package jBittorrentAPI_v1_0;

import jBittorrentAPI_v1_0.Utils;
import java.util.Iterator;
import java.util.TreeMap;

public class Piece {
    private TreeMap<Integer, Integer> filesAndoffset;
    private int index;
    private int length;
    private TreeMap<Integer, byte[]> pieceBlock;
    byte[] sha1;

    public Piece(int index, int length, int blockSize, byte[] sha1) {
        this(index, length, blockSize, sha1, null);
    }

    public Piece(int index, int length, int blockSize, byte[] sha1, TreeMap<Integer, Integer> m) {
        this.index = index;
        this.length = length;
        this.pieceBlock = new TreeMap();
        this.sha1 = sha1;
        this.filesAndoffset = m != null ? m : new TreeMap();
    }

    public void clearData() {
        this.pieceBlock.clear();
    }

    public void setFileAndOffset(int file, int offset) {
        this.filesAndoffset.put(file, offset);
    }

    public TreeMap getFileAndOffset() {
        return this.filesAndoffset;
    }

    public synchronized int getIndex() {
        return this.index;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized void setBlock(int offset, byte[] data) {
        this.pieceBlock.put(offset, data);
    }

    public synchronized byte[] data() {
        byte[] data = new byte[]{};
        Iterator<Integer> it = this.pieceBlock.keySet().iterator();
        while (it.hasNext()) {
            data = Utils.concat(data, this.pieceBlock.get(it.next()));
        }
        return data;
    }

    public synchronized boolean verify() {
        return Utils.byteArrayToByteString(Utils.hash(this.data())).matches(Utils.byteArrayToByteString(this.sha1));
    }

    public synchronized String toString() {
        String s = "";
        s = s + "Piece " + this.index + "[" + this.length + "Bytes], part of file";
        if (this.filesAndoffset.size() > 1) {
            s = s + "s";
        }
        Iterator<Integer> it = this.filesAndoffset.keySet().iterator();
        while (it.hasNext()) {
            int key = it.next();
            s = s + " " + key + " [offset = " + this.filesAndoffset.get(key) + "]";
            if (!it.hasNext()) continue;
            s = s + " and";
        }
        return s;
    }
}

