/*
 * Decompiled with CFR 0.152.
 */
package jBittorrentAPI_v1_0;

import jBittorrentAPI_v1_0.BDecoder;
import jBittorrentAPI_v1_0.Peer;
import jBittorrentAPI_v1_0.PeerUpdateListener;
import jBittorrentAPI_v1_0.TorrentFile;
import jBittorrentAPI_v1_0.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class PeerUpdater
extends Thread {
    private LinkedHashMap<String, Peer> peerList;
    private byte[] id;
    private TorrentFile torrent;
    private long downloaded = 0L;
    private long uploaded = 0L;
    private long left = 0L;
    private String event = "&event=started";
    private int listeningPort = 6881;
    private int interval = 150;
    private int minInterval = 0;
    private boolean first = true;
    private boolean end = false;
    private final EventListenerList listeners = new EventListenerList();

    public PeerUpdater(byte[] id, TorrentFile torrent) {
        this.peerList = new LinkedHashMap();
        this.id = id;
        this.torrent = torrent;
        this.left = torrent.total_length;
        this.setDaemon(true);
    }

    public void setListeningPort(int port) {
        this.listeningPort = port;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getMinInterval() {
        return this.minInterval;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public long getLeft() {
        return this.left;
    }

    public String getEvent() {
        return this.event;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setMinInterval(int minInt) {
        this.minInterval = minInt;
    }

    public void setDownloaded(long dl) {
        this.downloaded = dl;
    }

    public void setUploaded(long ul) {
        this.uploaded = ul;
    }

    public void setLeft(long left) {
        this.left = left;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public LinkedHashMap getList() {
        return this.peerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateParameters(int dl, int ul, String event) {
        PeerUpdater peerUpdater = this;
        synchronized (peerUpdater) {
            this.downloaded += (long)dl;
            this.uploaded += (long)ul;
            this.left -= (long)dl;
            this.event = event;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        int tryNB = 0;
        byte[] b = new byte[]{};
        while (!this.end) {
            ++tryNB;
            this.peerList = this.processResponse(this.contactTracker(this.id, this.torrent, this.downloaded, this.uploaded, this.left, this.event));
            if (this.peerList != null) {
                if (this.first) {
                    this.event = "";
                    this.first = false;
                }
                tryNB = 0;
                this.fireUpdatePeerList(this.peerList);
                try {
                    byte[] byArray = b;
                    // MONITORENTER : b
                    b.wait(this.interval * 1000);
                    // MONITOREXIT : byArray
                }
                catch (InterruptedException ie) {}
                continue;
            }
            try {
                byte[] ie = b;
                // MONITORENTER : b
                b.wait(2000L);
                // MONITOREXIT : ie
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized LinkedHashMap<String, Peer> processResponse(Map m) {
        LinkedHashMap<String, Peer> l = null;
        if (m != null) {
            if (m.containsKey("failure reason")) {
                this.fireUpdateFailed(0, "The tracker returns the following error message:\t'" + new String((byte[])m.get("failure reason")) + "'");
                return null;
            }
            this.interval = ((Long)m.get("interval")).intValue() < this.interval ? ((Long)m.get("interval")).intValue() : (this.interval *= 2);
            Object peers = m.get("peers");
            ArrayList peerList = new ArrayList();
            l = new LinkedHashMap<String, Peer>();
            if (peers instanceof List) {
                peerList.addAll((List)peers);
                if (peerList != null && peerList.size() > 0) {
                    for (int i = 0; i < peerList.size(); ++i) {
                        String peerID = new String((byte[])((Map)peerList.get(i)).get("peer_id"));
                        String ipAddress = new String((byte[])((Map)peerList.get(i)).get("ip"));
                        int port = ((Long)((Map)peerList.get(i)).get("port")).intValue();
                        Peer p = new Peer(peerID, ipAddress, port);
                        l.put(p.toString(), p);
                    }
                }
            } else if (peers instanceof byte[]) {
                byte[] p = (byte[])peers;
                for (int i = 0; i < p.length; i += 6) {
                    Peer peer = new Peer();
                    peer.setIP(Utils.byteToUnsignedInt(p[i]) + "." + Utils.byteToUnsignedInt(p[i + 1]) + "." + Utils.byteToUnsignedInt(p[i + 2]) + "." + Utils.byteToUnsignedInt(p[i + 3]));
                    peer.setPort(Utils.byteArrayToInt(Utils.subArray(p, i + 4, 2)));
                    l.put(peer.toString(), peer);
                }
            }
            return l;
        }
        return null;
    }

    public synchronized Map contactTracker(byte[] id, TorrentFile t, long dl, long ul, long left, String event) {
        try {
            URL source = new URL(t.announceURL + "?info_hash=" + t.info_hash_as_url + "&peer_id=" + Utils.byteArrayToURLString(id) + "&port=" + this.listeningPort + "&downloaded=" + dl + "&uploaded=" + ul + "&left=" + left + "&numwant=100&compact=1" + event);
            System.out.println("Contact Tracker. URL source = " + source);
            URLConnection uc = source.openConnection();
            InputStream is2 = uc.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is2);
            Map m = BDecoder.decode(bis);
            System.out.println(m);
            bis.close();
            is2.close();
            return m;
        }
        catch (MalformedURLException murle) {
            this.fireUpdateFailed(2, "Tracker URL is not valid... Check if your data is correct and try again");
        }
        catch (UnknownHostException uhe) {
            this.fireUpdateFailed(3, "Tracker not available... Retrying...");
        }
        catch (IOException ioe) {
            this.fireUpdateFailed(4, "Tracker unreachable... Retrying");
        }
        catch (Exception e) {
            this.fireUpdateFailed(5, "Internal error");
        }
        return null;
    }

    public void end() {
        this.event = "&event=stopped";
        this.end = true;
        this.contactTracker(this.id, this.torrent, this.downloaded, this.uploaded, this.left, "&event=stopped");
    }

    public void addPeerUpdateListener(PeerUpdateListener listener) {
        this.listeners.add(PeerUpdateListener.class, listener);
    }

    public void removePeerUpdateListener(PeerUpdateListener listener) {
        this.listeners.remove(PeerUpdateListener.class, listener);
    }

    public PeerUpdateListener[] getPeerUpdateListeners() {
        return (PeerUpdateListener[])this.listeners.getListeners(PeerUpdateListener.class);
    }

    protected void fireUpdatePeerList(LinkedHashMap l) {
        for (PeerUpdateListener listener : this.getPeerUpdateListeners()) {
            listener.updatePeerList(l);
        }
    }

    protected void fireUpdateFailed(int error, String message) {
        for (PeerUpdateListener listener : this.getPeerUpdateListeners()) {
            listener.updateFailed(error, message);
        }
    }
}

