/*
 * Decompiled with CFR 0.152.
 */
package jBittorrentAPI_v1_0;

import jBittorrentAPI_v1_0.Utils;
import java.util.BitSet;

public class Peer {
    private String id;
    private String ip;
    private int port;
    private boolean interested = false;
    private boolean choked = true;
    private boolean interesting = false;
    private boolean choking = true;
    private BitSet hasPiece;
    private int downloaded = 0;
    private float dlrate = 0.0f;
    private long lastDL = 0L;
    private float ulrate = 0.0f;
    private long lastUL = 0L;
    private int uploaded = 0;
    private boolean connected = false;

    public Peer() {
        this.hasPiece = new BitSet();
    }

    public Peer(String id, String ip, int port) {
        this.lastDL = System.currentTimeMillis();
        this.lastUL = System.currentTimeMillis();
        this.id = id;
        this.ip = ip;
        this.port = port;
        this.hasPiece = new BitSet();
    }

    public void resetDL() {
        this.dlrate = 0.0f;
        this.lastDL = System.currentTimeMillis();
    }

    public void resetUL() {
        this.ulrate = 0.0f;
        this.lastUL = System.currentTimeMillis();
    }

    public float getDLRate(boolean reset) {
        if (reset) {
            float tmp = this.dlrate;
            this.dlrate = 0.0f;
            return tmp;
        }
        return this.dlrate;
    }

    public float getULRate(boolean reset) {
        if (reset) {
            float tmp = this.ulrate;
            this.ulrate = 0.0f;
            return tmp;
        }
        return this.ulrate;
    }

    public int getDL() {
        return this.downloaded;
    }

    public int getUL() {
        return this.uploaded;
    }

    public void setDLRate(int dl) {
        this.dlrate += (float)dl;
        this.downloaded += dl;
    }

    public void setULRate(int ul) {
        this.ulrate += (float)ul;
        this.uploaded += ul;
    }

    public String getID() {
        return this.id;
    }

    public String getIP() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public BitSet getHasPiece() {
        return this.hasPiece;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setIP(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isInterested() {
        return this.interested;
    }

    public boolean isChoked() {
        return this.choked;
    }

    public boolean isInteresting() {
        return this.interesting;
    }

    public boolean isChoking() {
        return this.choking;
    }

    public void setInterested(boolean i) {
        this.interested = i;
    }

    public void setChoked(boolean c) {
        this.choked = c;
    }

    public void setInteresting(boolean i) {
        this.interesting = i;
    }

    public void setChoking(boolean c) {
        this.choking = c;
    }

    public void setHasPiece(byte[] bitfield) {
        boolean[] b = Utils.byteArray2BitArray(bitfield);
        for (int i = 0; i < b.length; ++i) {
            this.hasPiece.set(i, b[i]);
        }
    }

    public void setHasPiece(int piece, boolean has) {
        this.hasPiece.set(piece, has);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connectionStatus) {
        this.connected = connectionStatus;
    }

    public boolean equals(Peer p) {
        return this.id == p.getID() && this.ip == p.getIP() && this.port == p.getPort();
    }

    public String toString() {
        return this.ip + ":" + this.port;
    }
}

