/*
 * Decompiled with CFR 0.152.
 */
package jBittorrentAPI_v1_0;

import jBittorrentAPI_v1_0.Bits;
import jBittorrentAPI_v1_0.Message;
import jBittorrentAPI_v1_0.Utils;

public class Message_PP
extends Message {
    private byte[] length = new byte[4];
    private byte[] id = new byte[1];
    private byte[] payload;

    public Message_PP() {
    }

    public Message_PP(int type, int p) {
        super(type, p);
        this.setData(type);
    }

    public Message_PP(int type) {
        this(type, 0);
    }

    public Message_PP(int type, byte[] payload, int p) {
        super(type, p);
        this.setData(type, payload);
    }

    public Message_PP(int type, byte[] payload) {
        this(type, payload, 0);
    }

    public byte[] getLength() {
        return this.length;
    }

    public byte[] getID() {
        return this.id;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setLength(byte[] length) {
        this.length = length;
    }

    public void setID(int id) {
        this.id[0] = (byte)id;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
    }

    public void setData(int type) {
        this.type = type;
        switch (type) {
            case 0: {
                this.length = new byte[]{0, 0, 0, 0};
                break;
            }
            case 1: {
                this.length = new byte[]{0, 0, 0, 1};
                this.id[0] = 0;
                break;
            }
            case 2: {
                this.length = new byte[]{0, 0, 0, 1};
                this.id[0] = 1;
                break;
            }
            case 3: {
                this.length = new byte[]{0, 0, 0, 1};
                this.id[0] = 2;
                break;
            }
            case 4: {
                this.length = new byte[]{0, 0, 0, 1};
                this.id[0] = 3;
            }
        }
    }

    public void setData(int type, byte[] payload) {
        this.type = type;
        switch (type) {
            case 5: {
                this.length = new byte[]{0, 0, 0, 5};
                this.id[0] = 4;
                this.payload = payload;
                break;
            }
            case 6: {
                this.length = Utils.intToByteArray(1 + payload.length);
                this.id[0] = 5;
                this.payload = payload;
                break;
            }
            case 7: {
                this.length = new byte[]{0, 0, 0, 13};
                this.id[0] = 6;
                this.payload = payload;
                break;
            }
            case 8: {
                this.length = Utils.intToByteArray(1 + payload.length);
                this.id[0] = 7;
                this.payload = payload;
                break;
            }
            case 9: {
                this.length = new byte[]{0, 0, 0, 13};
                this.id[0] = 8;
                this.payload = payload;
                break;
            }
            case 10: {
                this.length = new byte[]{0, 0, 0, 3};
                this.id[0] = 9;
                this.payload = payload;
            }
        }
    }

    public void setData(byte[] length, byte id, byte[] payload) {
        this.length = length;
        this.id[0] = id;
        this.payload = payload;
    }

    @Override
    public byte[] generate() {
        if (this.type > 4) {
            return Utils.concat(Utils.concat(this.length, this.id), this.payload);
        }
        if (this.type > 0) {
            return Utils.concat(this.length, this.id);
        }
        return this.length;
    }

    public String toString() {
        String toString = "";
        int length = Utils.byteArrayToInt(this.length);
        toString = toString + "<length=" + length + ">";
        if (length > 0) {
            toString = toString + "<id=" + this.id[0] + ">";
            if (length > 1) {
                switch (this.id[0] + 1) {
                    case 5: {
                        toString = toString + "<index=" + Utils.byteArrayToInt(this.payload) + ">";
                        break;
                    }
                    case 6: {
                        toString = toString + "<bitfield=" + new Bits(this.payload) + ">";
                        break;
                    }
                    case 7: {
                        toString = toString + "<index=" + Utils.byteArrayToInt(Utils.subArray(this.payload, 0, 4)) + ">";
                        toString = toString + "<begin=" + Utils.byteArrayToInt(Utils.subArray(this.payload, 4, 4)) + ">";
                        toString = toString + "<length=" + Utils.byteArrayToInt(Utils.subArray(this.payload, 8, 4)) + ">";
                        break;
                    }
                    case 8: {
                        toString = toString + "<index=" + Utils.byteArrayToInt(Utils.subArray(this.payload, 0, 4)) + ">";
                        toString = toString + "<begin=" + Utils.byteArrayToInt(Utils.subArray(this.payload, 4, 4)) + ">";
                        toString = toString + "<block= " + (this.payload.length - 8) + "bytes>";
                        break;
                    }
                    case 9: {
                        toString = toString + "<index=" + Utils.byteArrayToInt(Utils.subArray(this.payload, 0, 4)) + ">";
                        toString = toString + "<begin=" + Utils.byteArrayToInt(Utils.subArray(this.payload, 4, 4)) + ">";
                        toString = toString + "<length=" + Utils.byteArrayToInt(Utils.subArray(this.payload, 8, 4)) + ">";
                        break;
                    }
                }
            }
        }
        return toString;
    }
}

