/*
 * Decompiled with CFR 0.152.
 */
package jBittorrentAPI_v1_0;

import jBittorrentAPI_v1_0.Message;
import jBittorrentAPI_v1_0.Message_PP;
import jBittorrentAPI_v1_0.OutgoingListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.event.EventListenerList;

public class MessageSender
extends Thread {
    private OutputStream os = null;
    private LinkedBlockingQueue<Message> outgoingMessage = null;
    private long lmst = 0L;
    private boolean run = true;
    private final EventListenerList listeners = new EventListenerList();

    public MessageSender(String id, OutputStream os) {
        this.os = os;
        this.outgoingMessage = new LinkedBlockingQueue();
    }

    public void addOutgoingListener(OutgoingListener listener) {
        this.listeners.add(OutgoingListener.class, listener);
    }

    public void removeOutgoingListener(OutgoingListener listener) {
        this.listeners.remove(OutgoingListener.class, listener);
    }

    public OutgoingListener[] getOutgoingListeners() {
        return (OutgoingListener[])this.listeners.getListeners(OutgoingListener.class);
    }

    protected void fireConnectionClosed() {
        for (OutgoingListener listener : this.getOutgoingListeners()) {
            listener.connectionClosed();
        }
    }

    protected void fireKeepAliveSent() {
        for (OutgoingListener listener : this.getOutgoingListeners()) {
            listener.keepAliveSent();
        }
    }

    public synchronized void addMessageToQueue(Message m) {
        this.outgoingMessage.add(m);
        this.lmst = System.currentTimeMillis();
    }

    @Override
    public void run() {
        Message out = null;
        byte[] keep = new Message_PP(0).generate();
        try {
            while (this.run) {
                if (this.outgoingMessage != null && this.os != null) {
                    out = this.outgoingMessage.poll(120000L, TimeUnit.MILLISECONDS);
                }
                if (out != null) {
                    this.os.write(out.generate());
                    this.lmst = System.currentTimeMillis();
                    out = null;
                    continue;
                }
                if (!this.run) continue;
                this.os.write(keep);
                this.fireKeepAliveSent();
            }
        }
        catch (InterruptedException ie) {
        }
        catch (IOException ioe) {
            this.fireConnectionClosed();
        }
        catch (Exception e) {
            this.fireConnectionClosed();
        }
        if (this.outgoingMessage != null) {
            this.outgoingMessage.clear();
        }
        this.outgoingMessage = null;
        try {
            this.os.close();
            this.os = null;
            this.notify();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopThread() {
        this.run = false;
    }
}

