/*
 * Decompiled with CFR 0.152.
 */
package jBittorrentAPI_v1_0;

import jBittorrentAPI_v1_0.IncomingListener;
import jBittorrentAPI_v1_0.Message;
import jBittorrentAPI_v1_0.Message_HS;
import jBittorrentAPI_v1_0.Message_PP;
import jBittorrentAPI_v1_0.Utils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.event.EventListenerList;

public class MessageReceiver
extends Thread {
    private boolean run = true;
    private InputStream is = null;
    private DataInputStream dis = null;
    private boolean hsOK = false;
    private final EventListenerList listeners = new EventListenerList();

    public MessageReceiver(String id, InputStream is2) throws IOException {
        this.is = is2;
        this.dis = new DataInputStream(is2);
    }

    private int read(byte[] data) {
        try {
            this.dis.readFully(data);
        }
        catch (IOException ioe) {
            return -1;
        }
        return data.length;
    }

    private int read2(byte[] data) throws IOException, InterruptedException {
        int totalread;
        int read = 0;
        for (totalread = 0; totalread != data.length; totalread += read) {
            read = this.is.read(data, totalread, data.length - totalread);
            if (read == -1) {
                return -1;
            }
            MessageReceiver.sleep(50L);
        }
        return totalread;
    }

    private int read1(byte[] data) throws IOException, InterruptedException, Exception {
        int available;
        int l = data.length;
        byte[] payload = new byte[]{};
        int loop = 0;
        for (int i = 0; i < l; i += available) {
            byte[] temp;
            ++loop;
            available = this.is.available();
            if (available < l - i) {
                ++loop;
                temp = new byte[available];
                if (this.is.read(temp) == -1) {
                    return -1;
                }
                payload = Utils.concat(payload, temp);
                MessageReceiver.sleep(10L);
                continue;
            }
            temp = new byte[l - i];
            if (this.is.read(temp) == -1) {
                return -1;
            }
            payload = Utils.concat(payload, temp);
            Utils.copy(payload, data);
            return payload.length;
        }
        return -1;
    }

    @Override
    public void run() {
        int read = 0;
        byte[] lengthHS = new byte[1];
        byte[] protocol = new byte[19];
        byte[] reserved = new byte[8];
        byte[] fileID = new byte[20];
        byte[] peerID = new byte[20];
        byte[] length = new byte[4];
        Message_HS hs = new Message_HS();
        Message_PP mess = new Message_PP();
        while (this.run) {
            int l = 1664;
            try {
                if (!this.hsOK) {
                    read = this.read(lengthHS);
                    if (read > 0) {
                        int i;
                        for (i = 0; i < 19; ++i) {
                            protocol[i] = (byte)this.is.read();
                        }
                        for (i = 0; i < 8; ++i) {
                            reserved[i] = (byte)this.is.read();
                        }
                        for (i = 0; i < 20; ++i) {
                            fileID[i] = (byte)this.is.read();
                        }
                        for (i = 0; i < 20; ++i) {
                            peerID[i] = (byte)this.is.read();
                        }
                        hs.setData(lengthHS, protocol, reserved, fileID, peerID);
                    } else {
                        hs = null;
                    }
                } else {
                    read = this.read(length);
                    if (read > 0) {
                        l = Utils.byteArrayToInt(length);
                        if (l == 0) {
                            mess.setData(0);
                        } else {
                            int id = this.is.read();
                            if (id == -1) {
                                System.err.println("id");
                                mess = null;
                            } else if (l == 1) {
                                mess.setData(id + 1);
                            } else {
                                byte[] payload;
                                if (this.read(payload = new byte[--l]) > 0) {
                                    mess.setData(id + 1, payload);
                                }
                                payload = null;
                            }
                        }
                    } else {
                        mess = null;
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.fireMessageReceived(null);
                return;
            }
            catch (Exception e) {
                System.err.println(l + "Error in MessageReceiver..." + e.getMessage() + " " + e.toString());
                this.fireMessageReceived(null);
                return;
            }
            if (!this.hsOK) {
                this.fireMessageReceived(hs);
                this.hsOK = true;
                continue;
            }
            this.fireMessageReceived(mess);
        }
        try {
            this.dis.close();
            this.dis = null;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void addIncomingListener(IncomingListener listener) {
        this.listeners.add(IncomingListener.class, listener);
    }

    public void removeIncomingListener(IncomingListener listener) {
        this.listeners.remove(IncomingListener.class, listener);
    }

    public IncomingListener[] getIncomingListeners() {
        return (IncomingListener[])this.listeners.getListeners(IncomingListener.class);
    }

    protected void fireMessageReceived(Message m) {
        for (IncomingListener listener : this.getIncomingListeners()) {
            listener.messageReceived(m);
        }
    }

    public void stopThread() {
        this.run = false;
    }
}

