/*
 * Decompiled with CFR 0.152.
 */
package jBittorrentAPI_v1_0;

import jBittorrentAPI_v1_0.LogManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class IOManager {
    BufferedReader br;
    BufferedWriter bw;
    private static LogManager lm;

    public IOManager(String filename) {
        lm = new LogManager("logs/io.log");
    }

    public IOManager() {
        lm = new LogManager("io.log");
    }

    public static boolean save(byte[] data, String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            fos.write(data, 0, data.length);
            fos.flush();
            fos.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static byte[] readBytesFromStream(InputStream is2) {
        String data = "";
        try {
            int c;
            while ((c = is2.read()) != -1) {
                data = data + (char)c;
            }
        }
        catch (IOException ioe) {
            lm.writeLog(ioe.getMessage());
            System.err.println("Problem when reading from stream...");
            ioe.printStackTrace();
        }
        return data.getBytes();
    }

    public static byte[] readBytesFromFile(File file) {
        long file_size_long = -1L;
        byte[] file_bytes = null;
        try {
            int file_offset;
            FileInputStream file_stream = new FileInputStream(file);
            if (!file.exists()) {
                System.err.println("Error: [TorrentFileHandler.java] The file \"" + file.getName() + "\" does not exist. Please make sure you have the correct path to the file.");
                return null;
            }
            if (!file.canRead()) {
                System.err.println("Error: [TorrentFileHandler.java] Cannot read from \"" + file.getName() + "\". Please make sure the file permissions are set correctly.");
                return null;
            }
            file_size_long = file.length();
            if (file_size_long > Integer.MAX_VALUE) {
                System.err.println("Error: [TorrentFileHandler.java] The file \"" + file.getName() + "\" is too large to be read by this class.");
                return null;
            }
            file_bytes = new byte[(int)file_size_long];
            int bytes_read = 0;
            for (file_offset = 0; file_offset < file_bytes.length && (bytes_read = ((InputStream)file_stream).read(file_bytes, file_offset, file_bytes.length - file_offset)) >= 0; file_offset += bytes_read) {
            }
            if (file_offset < file_bytes.length) {
                throw new IOException("Could not completely read file \"" + file.getName() + "\".");
            }
            ((InputStream)file_stream).close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: [TorrentFileHandler.java] The file \"" + file.getName() + "\" does not exist. Please make sure you have the correct path to the file.");
            return null;
        }
        catch (IOException e) {
            System.err.println("Error: [TorrentFileHandler.java] There was a general, unrecoverable I/O error while reading from \"" + file.getName() + "\".");
            System.err.println(e.getMessage());
        }
        return file_bytes;
    }

    public static void saveFromURL(InputStream is2, String filename) throws IOException {
        int c;
        FileOutputStream fos = new FileOutputStream(filename);
        boolean noheader = true;
        while ((c = is2.read()) != -1) {
            if (noheader) {
                fos.write(c);
                fos.flush();
                continue;
            }
            if (c != 10 || is2.read() != 13 || is2.read() != 10) continue;
            noheader = true;
        }
        fos.close();
    }

    public static String readUserInput(String question) {
        System.out.print(question);
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(isr);
        String s = null;
        try {
            s = br.readLine();
        }
        catch (IOException ioe) {
            System.err.println("An error occured while reading your data");
            return "";
        }
        return s;
    }
}

