/*
 * Decompiled with CFR 0.152.
 */
package jBittorrentAPI_v1_0;

import jBittorrentAPI_v1_0.DTListener;
import jBittorrentAPI_v1_0.IncomingListener;
import jBittorrentAPI_v1_0.LogManager;
import jBittorrentAPI_v1_0.Message;
import jBittorrentAPI_v1_0.MessageReceiver;
import jBittorrentAPI_v1_0.MessageSender;
import jBittorrentAPI_v1_0.Message_HS;
import jBittorrentAPI_v1_0.Message_PP;
import jBittorrentAPI_v1_0.OutgoingListener;
import jBittorrentAPI_v1_0.Peer;
import jBittorrentAPI_v1_0.Piece;
import jBittorrentAPI_v1_0.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.LinkedList;
import javax.swing.event.EventListenerList;

public class DownloadTask
extends Thread
implements IncomingListener,
OutgoingListener {
    private static final int IDLE = 0;
    private static final int WAIT_HS = 1;
    private static final int WAIT_BFORHAVE = 2;
    private static final int WAIT_UNCHOKE = 4;
    private static final int READY_2_DL = 5;
    private static final int DOWNLOADING = 6;
    private static final int WAIT_BLOCK = 7;
    public static final int TASK_COMPLETED = 0;
    public static final int UNKNOWN_HOST = 1;
    public static final int CONNECTION_REFUSED = 2;
    public static final int BAD_HANDSHAKE = 3;
    public static final int MALFORMED_MESSAGE = 4;
    public static final int TIMEOUT = 5;
    private int state = 0;
    private boolean run = true;
    private byte[] fileID;
    private byte[] myID;
    public Peer peer;
    private LogManager lm;
    private final boolean initiate;
    public byte[] bitfield = null;
    private boolean isDownloading = false;
    private boolean isUploading = false;
    private Piece downloadPiece = null;
    private int offset = 0;
    private final EventListenerList listeners = new EventListenerList();
    private Socket peerConnection = null;
    private OutputStream os = null;
    private InputStream is = null;
    public MessageSender ms = null;
    public MessageReceiver mr = null;
    private long downloaded = 0L;
    private long uploaded = 0L;
    private long creationTime = 0L;
    private long updateTime = 0L;
    private long lmrt = 0L;
    private LinkedList<Integer> pendingRequest = new LinkedList();

    public DownloadTask(Peer peer, byte[] fileID, byte[] myID, boolean init, byte[] bitfield, Socket s) {
        this.fileID = fileID;
        this.myID = myID;
        this.initiate = init;
        this.bitfield = bitfield;
        if (s != null) {
            try {
                this.peerConnection = s;
                String peerIP = this.peerConnection.getInetAddress().getHostAddress();
                int peerPort = this.peerConnection.getPort();
                this.is = this.peerConnection.getInputStream();
                this.os = this.peerConnection.getOutputStream();
                this.peer = new Peer();
                this.peer.setIP(peerIP);
                this.peer.setPort(peerPort);
            }
            catch (IOException ioe) {}
        } else {
            this.peer = peer;
        }
        this.lm = new LogManager("logs/downloads.log");
    }

    public DownloadTask(Peer peer, byte[] fileID, byte[] myID, boolean init, byte[] bitfield) {
        this(peer, fileID, myID, init, bitfield, null);
    }

    public DownloadTask(Peer peer, byte[] fileID, byte[] myID) {
        this(peer, fileID, myID, true, null);
    }

    public void initConnection() throws UnknownHostException, IOException {
        if (this.peerConnection == null && !this.peer.isConnected()) {
            this.peerConnection = new Socket(this.peer.getIP(), this.peer.getPort());
            this.os = this.peerConnection.getOutputStream();
            this.is = this.peerConnection.getInputStream();
            this.peer.setConnected(true);
        }
        this.ms = new MessageSender(this.peer.toString(), this.os);
        this.ms.addOutgoingListener(this);
        this.ms.start();
        this.mr = new MessageReceiver(this.peer.toString(), this.is);
        this.mr.addIncomingListener(this);
        this.mr.start();
        this.fireAddActiveTask(this.peer.toString(), this);
        if (this.initiate) {
            this.ms.addMessageToQueue(new Message_HS(this.fileID, this.myID));
            this.changeState(1);
        } else {
            this.changeState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            this.initConnection();
            while (this.run) {
                DownloadTask downloadTask = this;
                synchronized (downloadTask) {
                    this.wait();
                }
            }
            return;
        }
        catch (UnknownHostException uhe) {
            this.fireTaskCompleted(this.peer.toString(), 1);
            return;
        }
        catch (IOException ioe) {
            this.fireTaskCompleted(this.peer.toString(), 2);
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void clear() {
        if (this.downloadPiece != null) {
            this.firePieceRequested(this.downloadPiece.getIndex(), false);
            this.downloadPiece = null;
        }
    }

    public synchronized Peer getPeer() {
        return this.peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void requestPiece(Piece p) {
        DownloadTask downloadTask = this;
        synchronized (downloadTask) {
            this.downloadPiece = p;
            if (this.state == 5) {
                this.changeState(6);
            }
        }
    }

    public synchronized int checkDownloaded() {
        int d = new Long(this.downloaded).intValue();
        return d;
    }

    @Override
    public synchronized void connectionClosed() {
        this.clear();
        this.fireTaskCompleted(this.peer.toString(), 2);
    }

    @Override
    public synchronized void keepAliveSent() {
        if (System.currentTimeMillis() - this.lmrt > 180000L) {
            this.clear();
            this.fireTaskCompleted(this.peer.toString(), 5);
            return;
        }
        this.firePeerReady(this.peer.toString());
    }

    @Override
    public synchronized void messageReceived(Message m) {
        if (m == null) {
            this.fireTaskCompleted(this.peer.toString(), 4);
            return;
        }
        this.lmrt = System.currentTimeMillis();
        if (m.getType() == -1) {
            Message_HS hs = (Message_HS)m;
            if (Utils.bytesCompare(hs.getFileID(), this.fileID)) {
                if (!this.initiate) {
                    this.peer.setID(new String(hs.getPeerID()));
                    this.ms.addMessageToQueue(new Message_HS(this.fileID, this.myID));
                }
                this.ms.addMessageToQueue(new Message_PP(6, this.bitfield));
                this.creationTime = System.currentTimeMillis();
                this.changeState(2);
            } else {
                this.fireTaskCompleted(this.peer.toString(), 3);
            }
            hs = null;
        } else {
            Message_PP message = (Message_PP)m;
            switch (message.getType()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.peer.setChoking(true);
                    this.isDownloading = false;
                    break;
                }
                case 2: {
                    this.peer.setChoking(false);
                    if (this.downloadPiece == null) {
                        this.changeState(5);
                        break;
                    }
                    this.changeState(6);
                    break;
                }
                case 3: {
                    this.peer.setInterested(true);
                    break;
                }
                case 4: {
                    this.peer.setInterested(false);
                    break;
                }
                case 5: {
                    this.peer.setHasPiece(Utils.byteArrayToInt(message.getPayload()), true);
                    this.firePeerAvailability(this.peer.toString(), this.peer.getHasPiece());
                    break;
                }
                case 6: {
                    this.peer.setHasPiece(message.getPayload());
                    this.firePeerAvailability(this.peer.toString(), this.peer.getHasPiece());
                    this.changeState(4);
                    break;
                }
                case 7: {
                    if (!this.peer.isChoked()) {
                        this.firePeerRequest(this.peer.toString(), Utils.byteArrayToInt(Utils.subArray(message.getPayload(), 0, 4)), Utils.byteArrayToInt(Utils.subArray(message.getPayload(), 4, 4)), Utils.byteArrayToInt(Utils.subArray(message.getPayload(), 8, 4)));
                        break;
                    }
                    this.fireTaskCompleted(this.peer.toString(), 4);
                    break;
                }
                case 8: {
                    int begin = Utils.byteArrayToInt(Utils.subArray(message.getPayload(), 4, 4));
                    byte[] data = Utils.subArray(message.getPayload(), 8, message.getPayload().length - 8);
                    this.downloadPiece.setBlock(begin, data);
                    this.peer.setDLRate(data.length);
                    this.pendingRequest.remove(new Integer(begin));
                    if (this.pendingRequest.size() == 0) {
                        this.isDownloading = false;
                    }
                    this.changeState(6);
                    break;
                }
                case 9: {
                    break;
                }
            }
            Object var2_3 = null;
        }
        m = null;
    }

    private synchronized void changeState(int newState) {
        int oldState = this.state;
        this.state = newState;
        switch (newState) {
            case 7: {
                if (this.pendingRequest.size() >= 5 || this.offset >= this.downloadPiece.getLength()) break;
                this.changeState(6);
                break;
            }
            case 5: {
                this.firePeerReady(this.peer.toString());
                break;
            }
            case 6: {
                if (this.offset >= this.downloadPiece.getLength()) {
                    if (this.pendingRequest.size() != 0) break;
                    int p = this.downloadPiece.getIndex();
                    this.offset = 0;
                    if (this.downloadPiece.verify()) {
                        this.firePieceCompleted(p, true);
                        this.changeState(5);
                    } else {
                        this.firePieceCompleted(p, false);
                        this.changeState(5);
                    }
                    this.clear();
                    this.changeState(5);
                    break;
                }
                if (this.downloadPiece == null || this.peer.isChoking()) break;
                byte[] pieceIndex = Utils.intToByteArray(this.downloadPiece.getIndex());
                byte[] begin = Utils.intToByteArray(this.offset);
                int length = this.downloadPiece.getLength() - this.offset;
                if (length >= 16384) {
                    length = 16384;
                }
                this.ms.addMessageToQueue(new Message_PP(7, Utils.concat(pieceIndex, Utils.concat(begin, Utils.intToByteArray(length))), 2));
                if (this.updateTime == 0L) {
                    this.updateTime = System.currentTimeMillis();
                }
                this.pendingRequest.add(new Integer(this.offset));
                this.offset += 16384;
                this.isDownloading = true;
                this.changeState(7);
            }
        }
    }

    public synchronized void addDTListener(DTListener listener) {
        this.listeners.add(DTListener.class, listener);
    }

    public synchronized void removeDTListener(DTListener listener) {
        this.listeners.remove(DTListener.class, listener);
    }

    public synchronized DTListener[] getDTListeners() {
        return (DTListener[])this.listeners.getListeners(DTListener.class);
    }

    private synchronized void firePieceRequested(int piece, boolean requested) {
        for (DTListener listener : this.getDTListeners()) {
            listener.pieceRequested(piece, requested);
        }
    }

    private synchronized void firePieceCompleted(int piece, boolean complete) {
        for (DTListener listener : this.getDTListeners()) {
            listener.pieceCompleted(this.peer.toString(), piece, complete);
        }
    }

    private synchronized void fireTaskCompleted(String id, int reason) {
        this.end();
        for (DTListener listener : this.getDTListeners()) {
            listener.taskCompleted(id, reason);
        }
    }

    private synchronized void firePeerReady(String id) {
        for (DTListener listener : this.getDTListeners()) {
            listener.peerReady(id);
        }
    }

    private synchronized void firePeerRequest(String peerID, int piece, int begin, int length) {
        for (DTListener listener : this.getDTListeners()) {
            listener.peerRequest(peerID, piece, begin, length);
        }
    }

    private synchronized void firePeerAvailability(String id, BitSet hasPiece) {
        for (DTListener listener : this.getDTListeners()) {
            listener.peerAvailability(id, hasPiece);
        }
    }

    private synchronized void fireAddActiveTask(String id, DownloadTask dt) {
        for (DTListener listener : this.getDTListeners()) {
            listener.addActiveTask(id, dt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void end() {
        this.changeState(0);
        this.run = false;
        DownloadTask downloadTask = this;
        synchronized (downloadTask) {
            if (this.ms != null) {
                this.ms.stopThread();
                this.ms = null;
            }
            if (this.mr != null) {
                this.mr.stopThread();
                this.mr = null;
            }
            try {
                this.peerConnection.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.is.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.peerConnection = null;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (this.peerConnection != null) {
            try {
                try {
                    this.is.close();
                }
                finally {
                    this.is = null;
                }
                try {
                    this.os.close();
                }
                finally {
                    this.os = null;
                }
                if (!this.peerConnection.isClosed()) {
                    this.peerConnection.close();
                }
                this.peerConnection = null;
            }
            finally {
                super.finalize();
            }
        }
    }
}

