/*
 * Decompiled with CFR 0.152.
 */
package jBittorrentAPI_v1_0;

import jBittorrentAPI_v1_0.ConListenerInterface;
import jBittorrentAPI_v1_0.ConnectionListener;
import jBittorrentAPI_v1_0.Constants;
import jBittorrentAPI_v1_0.DLRateComparator;
import jBittorrentAPI_v1_0.DTListener;
import jBittorrentAPI_v1_0.DownloadTask;
import jBittorrentAPI_v1_0.Message_PP;
import jBittorrentAPI_v1_0.Peer;
import jBittorrentAPI_v1_0.PeerUpdateListener;
import jBittorrentAPI_v1_0.PeerUpdater;
import jBittorrentAPI_v1_0.Piece;
import jBittorrentAPI_v1_0.TorrentFile;
import jBittorrentAPI_v1_0.ULRateComparator;
import jBittorrentAPI_v1_0.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;

public class DownloadManager
implements DTListener,
PeerUpdateListener,
ConListenerInterface {
    private byte[] clientID;
    private TorrentFile torrent = null;
    private int maxConnectionNumber = 10;
    private int nbOfFiles = 0;
    private long length = 0L;
    private long left = 0L;
    private Piece[] pieceList;
    private BitSet isComplete;
    private BitSet isRequested;
    private int nbPieces;
    private RandomAccessFile[] output_files;
    private PeerUpdater pu = null;
    private ConnectionListener cl = null;
    private List unchokeList = new LinkedList();
    private LinkedHashMap<String, Peer> peerList = null;
    private TreeMap<String, DownloadTask> task = null;
    private LinkedHashMap<String, BitSet> peerAvailabilies = null;
    LinkedHashMap unchoken = new LinkedHashMap();
    private long lastTrackerContact = 0L;
    private long lastUnchoking = 0L;
    private short optimisticUnchoke = (short)3;

    public DownloadManager(TorrentFile torrent, byte[] clientID) {
        this.clientID = clientID;
        this.peerList = new LinkedHashMap();
        this.task = new TreeMap();
        this.peerAvailabilies = new LinkedHashMap();
        this.torrent = torrent;
        this.nbPieces = torrent.piece_hash_values_as_binary.size();
        this.pieceList = new Piece[this.nbPieces];
        this.nbOfFiles = this.torrent.length.size();
        this.isComplete = new BitSet(this.nbPieces);
        this.isRequested = new BitSet(this.nbPieces);
        this.output_files = new RandomAccessFile[this.nbOfFiles];
        this.left = this.length = this.torrent.total_length;
        this.checkTempFiles();
        int file = 0;
        int fileoffset = 0;
        for (int i = 0; i < this.nbPieces; ++i) {
            TreeMap<Integer, Integer> tm;
            block3: {
                int pieceoffset;
                block2: {
                    tm = new TreeMap<Integer, Integer>();
                    pieceoffset = 0;
                    do {
                        tm.put(file, fileoffset);
                        if (fileoffset + this.torrent.pieceLength - pieceoffset < (Integer)torrent.length.get(file) || i == this.nbPieces - 1) break block2;
                        fileoffset = 0;
                    } while ((pieceoffset += (Integer)torrent.length.get(++file) - fileoffset) != this.torrent.pieceLength);
                    break block3;
                }
                fileoffset += this.torrent.pieceLength - pieceoffset;
            }
            this.pieceList[i] = new Piece(i, i != this.nbPieces - 1 ? this.torrent.pieceLength : Long.valueOf(this.length % (long)this.torrent.pieceLength).intValue(), 16384, (byte[])torrent.piece_hash_values_as_binary.get(i), tm);
            if (!this.testComplete(i)) continue;
            this.setComplete(i, true);
            this.left -= (long)this.pieceList[i].getLength();
        }
        this.lastUnchoking = System.currentTimeMillis();
    }

    public boolean testComplete(int piece) {
        boolean complete = false;
        this.pieceList[piece].setBlock(0, this.getPieceFromFiles(piece));
        complete = this.pieceList[piece].verify();
        this.pieceList[piece].clearData();
        return complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void blockUntilCompletion() {
        byte[] b = new byte[]{};
        do {
            try {
                byte[] byArray = b;
                // MONITORENTER : b
                b.wait(10000L);
                this.unchokePeers();
                b.notifyAll();
                // MONITOREXIT : byArray
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (!this.isComplete());
    }

    public void startTrackerUpdate() {
        this.pu = new PeerUpdater(this.clientID, this.torrent);
        this.pu.addPeerUpdateListener(this);
        this.pu.setListeningPort(this.cl.getConnectedPort());
        this.pu.setLeft(this.left);
        this.pu.start();
    }

    public void stopTrackerUpdate() {
        this.pu.end();
    }

    public boolean startListening(int minPort, int maxPort) {
        this.cl = new ConnectionListener();
        if (this.cl.connect(minPort, maxPort)) {
            this.cl.addConListenerInterface(this);
            return true;
        }
        System.err.println("Could not create listening socket...");
        System.err.flush();
        return false;
    }

    public void closeTempFiles() {
        for (int i = 0; i < this.output_files.length; ++i) {
            try {
                this.output_files[i].close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized int checkTempFiles() {
        String saveas = Constants.SAVEPATH;
        if (this.nbOfFiles > 1) {
            saveas = saveas + this.torrent.saveAs + "/";
        }
        new File(saveas).mkdirs();
        for (int i = 0; i < this.nbOfFiles; ++i) {
            File temp = new File(saveas, (String)this.torrent.name.get(i));
            try {
                this.output_files[i] = new RandomAccessFile(temp, "rw");
                this.output_files[i].setLength(((Integer)this.torrent.length.get(i)).intValue());
                continue;
            }
            catch (IOException ioe) {
                System.err.println("Could not create temp files");
                ioe.printStackTrace();
            }
        }
        return 0;
    }

    public synchronized void savePiece(int piece) {
        byte[] data = this.pieceList[piece].data();
        int remainingData = data.length;
        Iterator it = this.pieceList[piece].getFileAndOffset().keySet().iterator();
        while (it.hasNext()) {
            try {
                Integer file = (Integer)it.next();
                int remaining = (Integer)this.torrent.length.get(file) - (Integer)this.pieceList[piece].getFileAndOffset().get(file);
                this.output_files[file].seek(((Integer)this.pieceList[piece].getFileAndOffset().get(file)).intValue());
                this.output_files[file].write(data, data.length - remainingData, remaining < remainingData ? remaining : remainingData);
                remainingData -= remaining;
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
            }
        }
        data = null;
        this.pieceList[piece].clearData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() {
        DownloadManager downloadManager = this;
        synchronized (downloadManager) {
            BitSet bitSet = this.isComplete;
            synchronized (bitSet) {
                byte[] data = new byte[]{};
                for (int i = 0; i < this.nbPieces; ++i) {
                    if (this.pieceList[i] == null) continue;
                    data = Utils.concat(data, this.pieceList[i].data());
                }
                String saveAs = Constants.SAVEPATH;
                int offset = 0;
                if (this.nbOfFiles > 1) {
                    saveAs = saveAs + this.torrent.saveAs + "/";
                }
                for (int i = 0; i < this.nbOfFiles; ++i) {
                    try {
                        new File(saveAs).mkdirs();
                        FileOutputStream fos = new FileOutputStream(saveAs + (String)this.torrent.name.get(i));
                        fos.write(Utils.subArray(data, offset, (Integer)this.torrent.length.get(i)));
                        fos.flush();
                        fos.close();
                        offset += ((Integer)this.torrent.length.get(i)).intValue();
                        continue;
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        System.err.println("Error when saving the file " + (String)this.torrent.name.get(i));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isComplete() {
        BitSet bitSet = this.isComplete;
        synchronized (bitSet) {
            return this.isComplete.cardinality() == this.nbPieces;
        }
    }

    public synchronized int cardinalityR() {
        return this.isRequested.cardinality();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Piece getPiece(int index) {
        Piece[] pieceArray = this.pieceList;
        synchronized (this.pieceList) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.pieceList[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isPieceComplete(int piece) {
        BitSet bitSet = this.isComplete;
        synchronized (bitSet) {
            return this.isComplete.get(piece);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isPieceRequested(int piece) {
        BitSet bitSet = this.isRequested;
        synchronized (bitSet) {
            return this.isRequested.get(piece);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setComplete(int piece, boolean is2) {
        BitSet bitSet = this.isComplete;
        synchronized (bitSet) {
            this.isComplete.set(piece, is2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRequested(int piece, boolean is2) {
        BitSet bitSet = this.isRequested;
        synchronized (bitSet) {
            this.isRequested.set(piece, is2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String requestedBits() {
        String s = "";
        BitSet bitSet = this.isRequested;
        synchronized (bitSet) {
            for (int i = 0; i < this.nbPieces; ++i) {
                s = s + (this.isRequested.get(i) ? 1 : 0);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int choosePiece2Download(String id) {
        BitSet bitSet = this.isComplete;
        synchronized (bitSet) {
            int index = 0;
            ArrayList<Integer> possible = new ArrayList<Integer>(this.nbPieces);
            for (int i = 0; i < this.nbPieces; ++i) {
                if (this.isPieceRequested(i) && this.isComplete.cardinality() <= this.nbPieces - 3 || this.isPieceComplete(i) || this.peerAvailabilies.get(id) == null || !this.peerAvailabilies.get(id).get(i)) continue;
                possible.add(i);
            }
            if (possible.size() > 0) {
                Random r = new Random(System.currentTimeMillis());
                index = (Integer)possible.get(r.nextInt(possible.size()));
                this.setRequested(index, true);
                return index;
            }
            return -1;
        }
    }

    @Override
    public synchronized void taskCompleted(String id, int reason) {
        switch (reason) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
        }
        this.peerAvailabilies.remove(id);
        this.task.remove(id);
        this.peerList.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pieceCompleted(String peerID, int i, boolean complete) {
        BitSet bitSet = this.isRequested;
        synchronized (bitSet) {
            this.isRequested.clear(i);
        }
        bitSet = this.isComplete;
        synchronized (bitSet) {
            if (complete && !this.isPieceComplete(i)) {
                this.pu.updateParameters(this.torrent.pieceLength, 0, "");
                this.isComplete.set(i, complete);
                float totaldl = 100.0f * (float)this.isComplete.cardinality() / (float)this.nbPieces;
                Iterator<String> it = this.task.keySet().iterator();
                while (it.hasNext()) {
                    try {
                        this.task.get((Object)it.next()).ms.addMessageToQueue(new Message_PP(5, Utils.intToByteArray(i), 1));
                    }
                    catch (NullPointerException npe) {}
                }
                System.out.println("Piece completed by " + peerID + " : " + i + " (Total dl = " + totaldl + "% )");
                this.savePiece(i);
                this.getPieceBlock(i, 0, 15000);
            }
            if (this.isComplete.cardinality() == this.nbPieces) {
                System.out.println("Task completed");
                this.notify();
            }
        }
    }

    @Override
    public synchronized void pieceRequested(int i, boolean requested) {
        this.isRequested.set(i, requested);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void unchokePeers() {
        TreeMap<String, DownloadTask> treeMap = this.task;
        synchronized (treeMap) {
            int nbNotInterested = 0;
            int nbDownloaders = 0;
            int nbChoked = 0;
            this.unchoken.clear();
            LinkedList<Peer> l = new LinkedList<Peer>(this.peerList.values());
            if (!this.isComplete()) {
                Collections.sort(l, new DLRateComparator());
            } else {
                Collections.sort(l, new ULRateComparator());
            }
            for (Peer p : l) {
                if (p.getDLRate(false) > 0.0f) {
                    System.out.println(p + " rate: " + p.getDLRate(true) / 10240.0f + "ko/s");
                }
                DownloadTask dt = this.task.get(p.toString());
                if (nbDownloaders < 5 && dt != null) {
                    if (!p.isInterested()) {
                        this.unchoken.put(p.toString(), p);
                        if (p.isChoked()) {
                            dt.ms.addMessageToQueue(new Message_PP(2));
                        }
                        p.setChoked(false);
                        while (this.unchokeList.remove(p)) {
                        }
                        ++nbNotInterested;
                    } else if (p.isChoked()) {
                        this.unchoken.put(p.toString(), p);
                        dt.ms.addMessageToQueue(new Message_PP(2));
                        p.setChoked(false);
                        while (this.unchokeList.remove(p)) {
                        }
                        ++nbDownloaders;
                    }
                } else {
                    if (!p.isChoked()) {
                        dt.ms.addMessageToQueue(new Message_PP(1));
                        p.setChoked(true);
                    }
                    if (!this.unchokeList.contains(p)) {
                        this.unchokeList.add(p);
                    }
                    ++nbChoked;
                }
                p = null;
                dt = null;
            }
        }
        this.lastUnchoking = System.currentTimeMillis();
        short s = this.optimisticUnchoke;
        this.optimisticUnchoke = (short)(s - 1);
        if (s == 0) {
            this.optimisticUnchoke();
            this.optimisticUnchoke = (short)3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void optimisticUnchoke() {
        if (!this.unchokeList.isEmpty()) {
            Peer p = null;
            do {
                p = (Peer)this.unchokeList.remove(0);
                TreeMap<String, DownloadTask> treeMap = this.task;
                synchronized (treeMap) {
                    DownloadTask dt = this.task.get(p.toString());
                    if (dt != null) {
                        dt.ms.addMessageToQueue(new Message_PP(2));
                        p.setChoked(false);
                        this.unchoken.put(p.toString(), p);
                        System.out.println(p + " optimistically unchoken...");
                    } else {
                        p = null;
                    }
                    Object var3_3 = null;
                }
            } while (p == null && !this.unchokeList.isEmpty());
            Object var1_1 = null;
        }
    }

    @Override
    public synchronized void peerReady(String peerID) {
        int piece2request;
        if (System.currentTimeMillis() - this.lastUnchoking > 10000L) {
            this.unchokePeers();
        }
        if ((piece2request = this.choosePiece2Download(peerID)) != -1) {
            this.task.get(peerID).requestPiece(this.pieceList[piece2request]);
        }
    }

    @Override
    public synchronized void peerRequest(String peerID, int piece, int begin, int length) {
        if (this.isPieceComplete(piece)) {
            DownloadTask dt = this.task.get(peerID);
            if (dt != null) {
                dt.ms.addMessageToQueue(new Message_PP(8, Utils.concat(Utils.intToByteArray(piece), Utils.concat(Utils.intToByteArray(begin), this.getPieceBlock(piece, begin, length)))));
                dt.peer.setULRate(length);
            }
            dt = null;
            this.pu.updateParameters(0, length, "");
        } else {
            try {
                this.task.get(peerID).end();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.task.remove(peerID);
            this.peerList.remove(peerID);
            this.unchoken.remove(peerID);
        }
    }

    public synchronized byte[] getPieceFromFiles(int piece) {
        byte[] data = new byte[this.pieceList[piece].getLength()];
        int remainingData = data.length;
        Iterator it = this.pieceList[piece].getFileAndOffset().keySet().iterator();
        while (it.hasNext()) {
            try {
                Integer file = (Integer)it.next();
                int remaining = (Integer)this.torrent.length.get(file) - (Integer)this.pieceList[piece].getFileAndOffset().get(file);
                this.output_files[file].seek(((Integer)this.pieceList[piece].getFileAndOffset().get(file)).intValue());
                this.output_files[file].read(data, data.length - remainingData, remaining < remainingData ? remaining : remainingData);
                remainingData -= remaining;
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
            }
        }
        return data;
    }

    public synchronized byte[] getPieceBlock(int piece, int begin, int length) {
        return Utils.subArray(this.getPieceFromFiles(piece), begin, length);
    }

    @Override
    public synchronized void peerAvailability(String peerID, BitSet has) {
        this.peerAvailabilies.put(peerID, has);
        BitSet interest = (BitSet)has.clone();
        interest.andNot(this.isComplete);
        DownloadTask dt = this.task.get(peerID);
        if (dt != null && interest.cardinality() > 0 && !dt.peer.isInteresting()) {
            dt.ms.addMessageToQueue(new Message_PP(3, 2));
            dt.peer.setInteresting(true);
        }
        dt = null;
    }

    public synchronized void connect(Peer p) {
        DownloadTask dt = new DownloadTask(p, this.torrent.info_hash_as_binary, this.clientID, true, this.getBitField());
        dt.addDTListener(this);
        dt.start();
    }

    public synchronized void disconnect(Peer p) {
        DownloadTask dt = this.task.remove(p.toString());
        if (dt != null) {
            dt.end();
            dt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updatePeerList(LinkedHashMap list) {
        TreeMap<String, DownloadTask> treeMap = this.task;
        synchronized (treeMap) {
            Set keyset = list.keySet();
            for (String key : keyset) {
                if (this.task.containsKey(key)) continue;
                Peer p = (Peer)list.get(key);
                this.peerList.put(p.toString(), p);
                this.connect(p);
            }
        }
        System.out.println("Peer List updated from tracker with " + list.size() + " peers");
    }

    @Override
    public void updateFailed(int error, String message) {
        System.err.println(message);
        System.err.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addActiveTask(String id, DownloadTask dt) {
        TreeMap<String, DownloadTask> treeMap = this.task;
        synchronized (treeMap) {
            this.task.put(id, dt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void connectionAccepted(Socket s) {
        TreeMap<String, DownloadTask> treeMap = this.task;
        synchronized (treeMap) {
            String id = s.getInetAddress().getHostAddress() + ":" + s.getPort();
            if (!this.task.containsKey(id)) {
                DownloadTask dt = new DownloadTask(null, this.torrent.info_hash_as_binary, this.clientID, false, this.getBitField(), s);
                dt.addDTListener(this);
                this.peerList.put(dt.getPeer().toString(), dt.getPeer());
                this.task.put(dt.getPeer().toString(), dt);
                dt.start();
            }
        }
    }

    public byte[] getBitField() {
        int l = (int)Math.ceil((double)this.nbPieces / 8.0);
        byte[] bitfield = new byte[l];
        for (int i = 0; i < this.nbPieces; ++i) {
            if (!this.isComplete.get(i)) continue;
            int n = i / 8;
            bitfield[n] = (byte)(bitfield[n] | 1 << 7 - i % 8);
        }
        return bitfield;
    }

    public float getCompleted() {
        try {
            return 100.0f * (float)this.isComplete.cardinality() / (float)this.nbPieces;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public float getDLRate() {
        try {
            float rate = 0.0f;
            LinkedList<Peer> l = new LinkedList<Peer>(this.peerList.values());
            for (Peer p : l) {
                if (!(p.getDLRate(false) > 0.0f)) continue;
                rate += p.getDLRate(true);
            }
            return rate / 10240.0f;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public float getULRate() {
        try {
            float rate = 0.0f;
            LinkedList<Peer> l = new LinkedList<Peer>(this.peerList.values());
            for (Peer p : l) {
                if (!(p.getULRate(false) > 0.0f)) continue;
                rate += p.getULRate(true);
            }
            return rate / 10240.0f;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }
}

