/*
 * Decompiled with CFR 0.152.
 */
package jBittorrentAPI_v1_0;

import jBittorrentAPI_v1_0.ConListenerInterface;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.event.EventListenerList;

public class ConnectionListener
extends Thread {
    private ServerSocket ss = null;
    private int minPort = -1;
    private int maxPort = -1;
    private int connectedPort = -1;
    private final EventListenerList listeners = new EventListenerList();
    private boolean acceptConnection = true;

    public ConnectionListener() {
    }

    public ConnectionListener(int minPort, int maxPort) {
        this.minPort = minPort;
        this.maxPort = maxPort;
    }

    public int getConnectedPort() {
        return this.connectedPort;
    }

    public int getMinPort() {
        return this.minPort;
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    public void setMinPort(int minPort) {
        this.minPort = minPort;
    }

    public void setMaxPort(int maxPort) {
        this.maxPort = maxPort;
    }

    public boolean connect(int minPort, int maxPort) {
        this.minPort = minPort;
        this.maxPort = maxPort;
        for (int i = minPort; i <= maxPort; ++i) {
            try {
                this.ss = new ServerSocket(i);
                this.connectedPort = i;
                this.setDaemon(true);
                this.start();
                return true;
            }
            catch (IOException ioe) {
                continue;
            }
        }
        return false;
    }

    public boolean connect() {
        if (this.minPort != -1 && this.maxPort != -1) {
            return this.connect(this.minPort, this.maxPort);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        byte[] b = new byte[]{};
        try {
            while (true) {
                if (this.acceptConnection) {
                    this.fireConnectionAccepted(this.ss.accept());
                    ConnectionListener.sleep(1000L);
                    continue;
                }
                byte[] byArray = b;
                // MONITORENTER : b
                System.out.println("No more connection accepted for the moment...");
                b.wait();
                // MONITOREXIT : byArray
            }
        }
        catch (IOException ioe) {
            System.err.println("Error in connection listener: " + ioe.getMessage());
            System.err.flush();
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void setAccept(boolean accept) {
        this.acceptConnection = accept;
        this.notifyAll();
    }

    public void addConListenerInterface(ConListenerInterface listener) {
        this.listeners.add(ConListenerInterface.class, listener);
    }

    public void removeConListenerInterface(ConListenerInterface listener) {
        this.listeners.remove(ConListenerInterface.class, listener);
    }

    public ConListenerInterface[] getConListenerInterfaces() {
        return (ConListenerInterface[])this.listeners.getListeners(ConListenerInterface.class);
    }

    protected void fireConnectionAccepted(Socket s) {
        for (ConListenerInterface listener : this.getConListenerInterfaces()) {
            listener.connectionAccepted(s);
        }
    }
}

