/*
 * Decompiled with CFR 0.152.
 */
package iso;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import net.didion.loopy.iso9660.EntryEnumeration;
import net.didion.loopy.iso9660.ISO9660FileEntry;
import net.didion.loopy.iso9660.ISO9660FileSystem;

public class ISOExtractor {
    private static final int BUFFER_SIZE = 25600;
    private static byte[] buffer = new byte[25600];
    private ISO9660FileSystem fs;

    public static void main(String[] args) throws IOException {
        new ISOExtractor(new File("../test/iso/test.iso")).extractFull(new File("C:\\test\\local"));
        new ISOExtractor(new File("../test/iso/test.iso")).extractFull(new File("C:\\test\\remote"));
        ISOExtractor ex = new ISOExtractor(new File("../test/iso/test.iso"));
        ex.extract("/flavour webicons/test/test.txt", new File("C:\\test\\single"), false);
        ex.extract("/flavour webicons/test/test.txt", new File("C:\\test\\single"), true);
    }

    public ISOExtractor(File isoFile) {
        try {
            this.fs = new ISO9660FileSystem(isoFile, true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void extract(String path, File saveLocation, boolean includePath) {
        if (this.fs != null) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            Enumeration entries = this.fs.getEntries();
            while (entries.hasMoreElements()) {
                ISO9660FileEntry entry = (ISO9660FileEntry)entries.nextElement();
                if (!entry.getPath().equals(path)) continue;
                if (entry.isDirectory()) {
                    EntryEnumeration ee = new EntryEnumeration(this.fs, entry);
                    while (ee.hasMoreElements()) {
                        ISO9660FileEntry test = (ISO9660FileEntry)entries.nextElement();
                        System.out.println(test.getPath());
                    }
                } else {
                    this.extractEntry(entry, saveLocation, includePath);
                }
                return;
            }
        }
    }

    public void extractFull(File saveLocation) throws IOException {
        if (this.fs != null) {
            Enumeration entries = this.fs.getEntries();
            while (entries.hasMoreElements()) {
                ISO9660FileEntry entry = (ISO9660FileEntry)entries.nextElement();
                if (entry.isDirectory()) {
                    new File(saveLocation, entry.getPath()).mkdirs();
                    continue;
                }
                this.extractEntry(entry, saveLocation, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractEntry(ISO9660FileEntry entry, File saveLocation, boolean includePath) {
        FileOutputStream out = null;
        try {
            int size;
            InputStream readStream = this.fs.getInputStream(entry);
            String filePath = includePath ? entry.getPath() : entry.getName();
            saveLocation = new File(saveLocation, filePath);
            if (saveLocation.isDirectory()) {
                saveLocation.mkdirs();
            } else {
                saveLocation.getParentFile().mkdirs();
            }
            out = new FileOutputStream(saveLocation);
            long fileSize = entry.getSize();
            for (long readData = 0L; readData < fileSize; readData += (long)size) {
                buffer = readData + 25600L > fileSize ? new byte[(int)(fileSize - readData)] : new byte[25600];
                size = readStream.read(buffer);
                if ((long)size + readData > fileSize) {
                    out.write(buffer, 0, (int)(fileSize - readData));
                    continue;
                }
                out.write(buffer, 0, size);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

