/*
 * Decompiled with CFR 0.152.
 */
package inifiles;

import inifiles.IniFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class IniFileTest {
    private static FileWriter logWriter;

    private static void doLog(String logLine) {
        if (logWriter != null) {
            try {
                logWriter.append(logLine.concat("\n"));
            }
            catch (IOException ex) {
                Logger.getLogger(IniFile.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.out.println(logLine);
    }

    private static void logResult(int number, String result) {
        IniFileTest.doLog(new Integer(number).toString() + ": " + result);
    }

    private static void logResult(int number, boolean result) {
        IniFileTest.doLog(new Integer(number).toString() + ": " + result);
    }

    private static void logResult(int number, int result) {
        IniFileTest.doLog(new Integer(number).toString() + ": " + result);
    }

    private static String appDir(IniFile ini) {
        String appDir = ini.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        appDir = new File(appDir).getParent();
        appDir = new File(appDir).getParent() + "\\src\\inifiles";
        return appDir;
    }

    public static void main(String[] args) throws IOException {
        String applicationDir = IniFileTest.appDir(new IniFile(new File("x")));
        File testIni1 = new File(applicationDir + "\\IniTest.ini.ori");
        File testIni = new File(applicationDir + "\\IniTest.ini");
        FileUtils.copyFile(testIni1, testIni, true);
        IniFile ini = new IniFile(testIni);
        File log2 = new File(applicationDir + "\\IniTest.log");
        logWriter = ini.openLog(log2);
        IniFileTest.logResult(1, ini.keyRead("main", "myKey", "default1"));
        IniFileTest.logResult(2, ini.keyRead("main", "myKey1", "default2"));
        IniFileTest.logResult(3, ini.keyRead("main_y", "myKey2", "default3"));
        IniFileTest.logResult(4, ini.countSections());
        IniFileTest.logResult(5, ini.hasTextLine());
        IniFileTest.logResult(6, ini.sectionCountKeys("main_x"));
        IniFileTest.logResult(7, ini.sectionCountTexts("main_x"));
        IniFileTest.logResult(8, ini.sectionCountChilds("main_x"));
        IniFileTest.logResult(9, ini.sectionHasTextLine("main_x"));
        IniFileTest.logResult(10, ini.sectionHasTextLine("main"));
        IniFileTest.logResult(11, ini.sectionCountChilds("nicht-da"));
        IniFileTest.logResult(12, ini.sectionLineRead("main", 1));
        IniFileTest.logResult(13, ini.sectionLineRead("main_x", -1));
        IniFileTest.logResult(13, ini.sectionLineRead("main", 17));
        IniFileTest.logResult(15, ini.sectionLineRead("gibsnich", 1));
        IniFileTest.logResult(16, ini.listSections());
        IniFileTest.logResult(17, ini.listChilds());
        IniFileTest.logResult(18, ini.sectionListTexts("Main_x"));
        IniFileTest.logResult(19, ini.sectionListKeys("Main_x"));
        IniFileTest.logResult(20, ini.sectionListChilds("Main_x"));
        IniFileTest.logResult(21, ini.listTexts());
        IniFileTest.logResult(22, ini.sectionListKeys("Main"));
        IniFileTest.logResult(23, ini.keyWrite("neu", "key", "bla"));
        IniFileTest.logResult(24, ini.keyWrite("neu", "nochnkey", "nochnbla"));
        IniFileTest.logResult(25, ini.keyWrite("main", "mykey", "changed"));
        IniFileTest.logResult(26, ini.sectionCreate("Text"));
        IniFileTest.logResult(27, ini.sectionExists("second"));
        IniFileTest.logResult(28, ini.sectionExists("never"));
        IniFileTest.logResult(29, ini.sectionRemove("second"));
        IniFileTest.logResult(30, ini.keyExists("main", "myKey"));
        IniFileTest.logResult(31, ini.keyExists("main", "myKey1"));
        IniFileTest.logResult(32, ini.keyExists("main_y", "myKey2"));
        IniFileTest.logResult(33, ini.keyRemove("main_x", "neu"));
        IniFileTest.logResult(34, ini.sectionLineInsert("Text", -1, ";first item"));
        IniFileTest.logResult(35, ini.sectionLineInsert("Text", -1, ";second item"));
        IniFileTest.logResult(36, ini.sectionLineInsert("Text", -1, ";third item"));
        IniFileTest.logResult(37, ini.sectionLineInsert("Text", -1, ";fourth item"));
        IniFileTest.logResult(38, ini.sectionLineInsert("Text", -1, ";fifth item"));
        IniFileTest.logResult(39, ini.sectionLineWrite("Text", 3, ";changed"));
        IniFileTest.logResult(40, ini.sectionLineRemove("Text", 2));
        IniFileTest.logResult(41, ini.sectionLineRead("Text", -1));
        IniFileTest.logResult(42, ini.sectionLineRead("Text", 1));
        IniFileTest.logResult(43, ini.sectionLineRead("Text", 17));
        IniFileTest.logResult(44, ini.sectionLineIndexOf("Text", ";Changed"));
        IniFileTest.logResult(45, ini.sectionLineIndexOf("Text", "changed"));
        IniFileTest.logResult(46, ini.sectionCreate("baloo"));
        IniFileTest.logResult(47, ini.sectionCountKeys("baloo"));
        IniFileTest.logResult(48, ini.sectionCountTexts("baloo"));
        IniFileTest.logResult(49, ini.keyWrite("baloo", "hello", "thatsme"));
        IniFileTest.logResult(50, ini.sectionCountKeys("baloo"));
        IniFileTest.logResult(51, ini.sectionCountTexts("baloo"));
        IniFileTest.logResult(52, ini.sectionListTexts("baloo"));
        IniFileTest.logResult(53, ini.sectionListKeys("baloo"));
        IniFileTest.logResult(99, ini.closeFile(true));
        File testText = new File(applicationDir + "\\TextTest.txt");
        if (testText.exists()) {
            testText.delete();
        }
        ini = new IniFile(testText);
        IniFileTest.logResult(101, ini.lineInsert(-1, ";first item"));
        IniFileTest.logResult(102, ini.lineInsert(-1, ";second item"));
        IniFileTest.logResult(103, ini.lineInsert(-1, ";third item"));
        IniFileTest.logResult(104, ini.lineInsert(-1, ";fourth item"));
        IniFileTest.logResult(105, ini.lineInsert(-1, ";fifth item"));
        IniFileTest.logResult(106, ini.lineWrite(3, ";changed"));
        IniFileTest.logResult(107, ini.lineRemove(2));
        IniFileTest.logResult(108, ini.lineRead(-1));
        IniFileTest.logResult(109, ini.lineRead(1));
        IniFileTest.logResult(110, ini.lineRead(17));
        IniFileTest.logResult(111, ini.lineIndexOf(";Changed"));
        IniFileTest.logResult(112, ini.lineIndexOf("changed"));
        IniFileTest.logResult(199, ini.closeFile(true));
        ini.closeLog();
    }
}

