/*
 * Decompiled with CFR 0.152.
 */
package inifiles;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import utils.files;

public class IniFile {
    private File file;
    private static FileWriter logWriter;
    private IniItem iniItem;

    public int lineIndexOf(String value) {
        int res = -1;
        if (this.iniItem != null) {
            res = this.iniItem.childUcTitles.indexOf(value.toUpperCase());
        }
        return res;
    }

    public String lineRead(int index) {
        String res = null;
        if (this.iniItem != null) {
            int count = this.iniItem.childList.size();
            if (index == -1) {
                index = count - 1;
            }
            if (index < count) {
                res = ((IniItem)this.iniItem.childList.get(index)).getText();
            }
        }
        return res;
    }

    public String lineRemove(int index) {
        int count;
        String res = null;
        if (this.iniItem != null && index <= (count = this.iniItem.childList.size())) {
            if (index == -1) {
                index = count;
            }
            res = ((IniItem)this.iniItem.childList.get(index)).getText();
            this.iniItem.childList.remove(index);
            this.iniItem.childTitles.remove(index);
            this.iniItem.childUcTitles.remove(index);
        }
        return res;
    }

    public String lineInsert(int index, String value) {
        int count;
        String res = null;
        if (this.iniItem != null && index <= (count = this.iniItem.childList.size())) {
            IniItem textLine = new IniItem(IniType.LINE);
            textLine.setTitle(value);
            if (index == -1) {
                index = count;
            }
            this.iniItem.childList.add(index, textLine);
            this.iniItem.childTitles.add(index, value);
            this.iniItem.childUcTitles.add(index, value.toUpperCase());
            res = value;
        }
        return res;
    }

    public String lineInsert(String value) {
        return this.lineInsert(-1, value);
    }

    public String lineWrite(int index, String value) {
        int count;
        String res = null;
        if (this.iniItem != null && index < (count = this.iniItem.childList.size())) {
            IniItem textLine = new IniItem(IniType.LINE);
            textLine.setTitle(value);
            if (index == -1) {
                index = count;
            }
            this.iniItem.childList.set(index, textLine);
            this.iniItem.childTitles.set(index, value);
            this.iniItem.childUcTitles.set(index, value.toUpperCase());
            res = value;
        }
        return res;
    }

    public String keyRemove(String section, String name) {
        int index;
        String res = null;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null && (index = actSection.childUcTitles.indexOf(name.toUpperCase())) != -1) {
            res = ((IniItem)actSection.childList.get(index)).getText();
            actSection.childList.remove(index);
            actSection.childTitles.remove(index);
            actSection.childUcTitles.remove(index);
        }
        return res;
    }

    public boolean keyExists(String section, String name) {
        boolean res = false;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null) {
            res = actSection.childUcTitles.contains(name.toUpperCase());
        }
        return res;
    }

    public String keyRead(String section, String key, String defValue) {
        IniItem actKey;
        String val = defValue;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null && (actKey = actSection.readKey(key)) != null) {
            val = actKey.getData();
        }
        return val;
    }

    public String keyWrite(String section, String key, String value) {
        IniItem actKey;
        String val = null;
        IniItem actSection = this.iniItem.openSection(section);
        if (actSection != null && (actKey = actSection.openKey(key)) != null) {
            actKey.setData(value);
            val = actKey.getText();
        }
        return val;
    }

    public boolean sectionExists(String name) {
        return this.iniItem.childUcTitles.contains(name.toUpperCase());
    }

    public String sectionRemove(String name) {
        String res = null;
        int index = this.iniItem.childUcTitles.indexOf(name.toUpperCase());
        if (index != -1) {
            this.iniItem.childList.remove(index);
            this.iniItem.childTitles.remove(index);
            this.iniItem.childUcTitles.remove(index);
            res = this.iniItem.sectionHeader(name);
        }
        return res;
    }

    public String sectionCreate(String name) {
        String res = null;
        IniItem actSection = this.iniItem.readSection(name);
        if (actSection == null && (actSection = this.iniItem.openSection(name)) != null) {
            res = this.iniItem.sectionHeader(actSection.title);
        }
        return res;
    }

    public boolean hasTextLine() {
        return this.iniItem.childCount(this.iniItem, IniType.TEXT) > 0;
    }

    public boolean sectionHasTextLine(String section) {
        boolean res = false;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null) {
            res = actSection.childCount(actSection, IniType.LINE) > 0;
        }
        return res;
    }

    public int countSections() {
        return this.iniItem.childCount(this.iniItem, IniType.SECTION);
    }

    public int sectionCountKeys(String section) {
        int res = -1;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null) {
            res = actSection.childCount(actSection, IniType.KEY);
        }
        return res;
    }

    public int sectionCountTexts(String section) {
        int res = -1;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null) {
            res = this.iniItem.childCount(actSection, IniType.TEXT);
        }
        return res;
    }

    public int sectionCountChilds(String section) {
        int res = -1;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null) {
            res = actSection.childCount(actSection, IniType.NONE);
        }
        return res;
    }

    public String sectionLineRead(String section, int index) {
        String res = null;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null) {
            int count = actSection.childList.size();
            if (index == -1) {
                index = count - 1;
            }
            if (index < count) {
                res = ((IniItem)actSection.childList.get(index)).getText();
            }
        }
        return res;
    }

    public int sectionLineIndexOf(String section, String value) {
        int res = -1;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null) {
            res = actSection.childUcTitles.indexOf(value.toUpperCase());
        }
        return res;
    }

    public String sectionLineInsert(String section, int index, String value) {
        int count;
        String res = null;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null && index <= (count = actSection.childList.size())) {
            IniItem textLine = new IniItem(IniType.LINE);
            textLine.setTitle(value);
            if (index == -1) {
                index = count;
            }
            actSection.childList.add(index, textLine);
            actSection.childTitles.add(index, value);
            actSection.childUcTitles.add(index, value.toUpperCase());
            res = value;
        }
        return res;
    }

    public String sectionLineInsert(String section, String value) {
        return this.sectionLineInsert(section, -1, value);
    }

    public String sectionLineRemove(String section, int index) {
        int count;
        String res = null;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null && index <= (count = actSection.childList.size())) {
            if (index == -1) {
                index = count;
            }
            res = ((IniItem)actSection.childList.get(index)).getText();
            actSection.childList.remove(index);
            actSection.childTitles.remove(index);
            actSection.childUcTitles.remove(index);
        }
        return res;
    }

    public String sectionLineWrite(String section, int index, String value) {
        int count;
        String res = null;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null && index < (count = actSection.childList.size())) {
            IniItem textLine = new IniItem(IniType.LINE);
            textLine.setTitle(value);
            if (index == -1) {
                index = count;
            }
            actSection.childList.set(index, textLine);
            actSection.childTitles.set(index, value);
            actSection.childUcTitles.set(index, value.toUpperCase());
            res = value;
        }
        return res;
    }

    public String listSections() {
        return this.iniItem.childList(IniType.SECTION);
    }

    public String listChilds() {
        return this.iniItem.childList(IniType.NONE);
    }

    public String listTexts() {
        IniItem actSection;
        String res = null;
        if (!this.iniItem.childList.isEmpty() && (actSection = (IniItem)this.iniItem.childList.get(0)) != null && actSection.iniType == IniType.TEXT) {
            res = actSection.childList(IniType.LINE);
        }
        return res;
    }

    public String sectionListTexts(String section) {
        String res = null;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null) {
            res = actSection.childList(IniType.LINE);
        }
        return res;
    }

    public String sectionListKeys(String section) {
        String res = null;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null) {
            res = actSection.childList(IniType.KEY);
        }
        return res;
    }

    public String sectionListChilds(String section) {
        String res = null;
        IniItem actSection = this.iniItem.readSection(section);
        if (actSection != null) {
            res = actSection.childList(IniType.NONE);
        }
        return res;
    }

    public FileWriter openLog(File log2) throws IOException {
        if (log2.exists()) {
            log2.delete();
        }
        log2.createNewFile();
        logWriter = new FileWriter(log2, true);
        return logWriter;
    }

    public void closeLog() throws IOException {
        if (logWriter != null) {
            logWriter.close();
        }
    }

    public IniFile(File assignedFile) {
        if (assignedFile != null) {
            this.file = assignedFile;
            this.iniItem = new IniItem(IniType.INI);
            this.iniItem.setTitle("iniItem");
            if (!assignedFile.exists()) {
                this.iniItem.setData("");
            } else {
                String temp = files.readAsString(this.file);
                this.iniItem.setData(temp);
            }
            this.iniItem.buildTree(this.iniItem);
        }
    }

    public boolean closeFile(boolean deleteEmpty) throws IOException {
        this.updateFile(deleteEmpty);
        this.iniItem = null;
        this.file = null;
        this.closeLog();
        return true;
    }

    public boolean closeFile() throws IOException {
        return this.closeFile(false);
    }

    public boolean updateFile() throws IOException {
        return this.updateFile(false);
    }

    public boolean updateFile(boolean deleteEmpty) throws IOException {
        String txt = "";
        String CRLF = "\r\n";
        for (IniItem section : this.iniItem.childList) {
            if (section.iniType == IniType.SECTION) {
                if (!txt.equals("")) {
                    txt = txt.concat("\r\n");
                }
                txt = txt.concat("[").concat(section.title).concat("]").concat("\r\n");
                for (IniItem key : section.childList) {
                    txt = txt.concat(key.getText()).concat("\r\n");
                }
                continue;
            }
            if (section.iniType == IniType.TEXT) {
                if (!txt.equals("")) {
                    txt = txt.concat("\r\n");
                }
                for (IniItem key : section.childList) {
                    txt = txt.concat(key.getText()).concat("\r\n");
                }
                continue;
            }
            if (section.iniType != IniType.LINE) continue;
            txt = txt.concat(section.getText()).concat("\r\n");
        }
        if (!txt.equals("") || !deleteEmpty) {
            files.SaveStringToFile(this.file, txt);
        } else {
            this.file.delete();
        }
        return true;
    }

    public class IniItem {
        private IniType iniType;
        private String title;
        private String ucTitle;
        private String body;
        private ArrayList<String> childTitles;
        private ArrayList<String> childUcTitles;
        private ArrayList<IniItem> childList;
        private int lStart = 0;
        private int lEnd;
        private String childRegex;

        public IniItem(IniType iniType) {
            this.iniType = iniType;
            this.childRegex = "";
            this.body = "";
            if (iniType == IniType.INI) {
                this.childRegex = "\\[.*\\]";
                this.childTitles = new ArrayList();
                this.childUcTitles = new ArrayList();
                this.childList = new ArrayList();
            } else if (iniType == IniType.SECTION) {
                this.childRegex = "[a-z,A-Z].*=.*";
                this.childTitles = new ArrayList();
                this.childUcTitles = new ArrayList();
                this.childList = new ArrayList();
            } else if (iniType == IniType.TEXT) {
                this.childRegex = null;
                this.childTitles = new ArrayList();
                this.childUcTitles = new ArrayList();
                this.childList = new ArrayList();
            } else if (iniType == IniType.LINE) {
                this.childRegex = null;
                this.childTitles = null;
                this.childUcTitles = null;
                this.childList = null;
            }
        }

        private void setData(String data) {
            this.body = data;
        }

        private void setTitle(String line) {
            this.title = this.iniType == IniType.SECTION ? this.getSectionName(line) : (this.iniType == IniType.KEY ? this.getKeyName(line) : line);
            this.ucTitle = this.title.toUpperCase();
        }

        private String sectionHeader(String name) {
            return "[".concat(name).concat("]");
        }

        private String getSectionName(String line) {
            return line.substring(1, line.length() - 1);
        }

        private String getKeyName(String line) {
            int pos = line.indexOf(61);
            if (pos == -1) {
                pos = line.length();
            }
            return line.substring(0, pos);
        }

        private String getKeyValue(String line) {
            int pos = line.indexOf(61);
            return line.substring(pos + 1);
        }

        private void appendData(String data) {
            if (!this.body.equals("")) {
                this.body = this.body.concat("\n");
            }
            this.body = this.body.concat(data);
        }

        private String getText() {
            if (this.iniType == IniType.KEY) {
                return this.title.concat("=").concat(this.body);
            }
            return this.title.concat(this.body);
        }

        private String getData() {
            return this.body;
        }

        private boolean isSection(String line, String regex) {
            return line.matches(regex);
        }

        private String nextLine() {
            String res = null;
            if (!this.body.equals("") && this.lStart < this.body.length()) {
                if (this.body.charAt(this.lStart) == '\n') {
                    ++this.lStart;
                    res = "";
                } else {
                    this.lEnd = this.body.indexOf("\n", this.lStart + 1);
                    if (this.lEnd == -1) {
                        this.lEnd = this.body.length();
                    }
                    if (this.lEnd > this.lStart) {
                        res = this.body.charAt(this.lEnd - 1) == '\r' ? this.body.substring(this.lStart, this.lEnd - 1) : this.body.substring(this.lStart, this.lEnd);
                    }
                    this.lStart = this.lEnd + 1;
                }
            }
            return res;
        }

        private void buildTree(IniItem actItem) {
            block12: {
                block11: {
                    String line;
                    if (actItem.iniType != IniType.INI) break block11;
                    IniItem actChild = new IniItem(IniType.TEXT);
                    actChild.setTitle("Root");
                    while ((line = actItem.nextLine()) != null && !this.isSection(line, actItem.childRegex)) {
                        actChild.appendData(line);
                    }
                    if (!actChild.getData().equals("")) {
                        this.buildTree(actChild);
                        actItem.childTitles.add(actChild.title);
                        actItem.childUcTitles.add(actChild.ucTitle);
                        actItem.childList.add(actChild);
                    }
                    if (line == null || !this.isSection(line, actItem.childRegex)) break block12;
                    do {
                        actChild = new IniItem(IniType.SECTION);
                        actChild.setTitle(line);
                        while ((line = actItem.nextLine()) != null && !this.isSection(line, actItem.childRegex)) {
                            actChild.appendData(line);
                        }
                        if (actChild.getData().equals("")) continue;
                        this.buildTree(actChild);
                        actItem.childTitles.add(actChild.title);
                        actItem.childUcTitles.add(actChild.ucTitle);
                        actItem.childList.add(actChild);
                        actChild.setData("");
                    } while (line != null);
                    break block12;
                }
                if (actItem.iniType == IniType.TEXT) {
                    String line;
                    while ((line = actItem.nextLine()) != null) {
                        IniItem actChild = new IniItem(IniType.LINE);
                        actChild.setTitle(line);
                        actItem.childTitles.add(line);
                        actItem.childUcTitles.add(line.toUpperCase());
                        actItem.childList.add(actChild);
                    }
                } else if (actItem.iniType == IniType.SECTION) {
                    String line;
                    while ((line = actItem.nextLine()) != null) {
                        IniItem actChild;
                        if (line.matches(actItem.childRegex)) {
                            actChild = new IniItem(IniType.KEY);
                            actChild.setTitle(line);
                            actChild.setData(actItem.getKeyValue(line));
                        } else {
                            actChild = new IniItem(IniType.LINE);
                            actChild.setTitle(line);
                        }
                        actItem.childList.add(actChild);
                        actItem.childTitles.add(actChild.title);
                        actItem.childUcTitles.add(actChild.ucTitle);
                    }
                }
            }
        }

        private IniItem readSection(String name) {
            IniItem res = null;
            int index = this.childUcTitles.indexOf(name.toUpperCase());
            if (index != -1) {
                res = this.childList.get(index);
            }
            return res;
        }

        private IniItem createSection(String name) {
            IniItem res = this.readSection(name);
            if (res == null) {
                res = new IniItem(IniType.SECTION);
                res.setTitle(this.sectionHeader(name));
                ((IniFile)IniFile.this).iniItem.childList.add(res);
                ((IniFile)IniFile.this).iniItem.childTitles.add(name);
                ((IniFile)IniFile.this).iniItem.childUcTitles.add(name.toUpperCase());
            }
            return res;
        }

        private IniItem createKey(String name) {
            IniItem res = this.readKey(name);
            if (res == null) {
                res = new IniItem(IniType.KEY);
                res.setTitle(name);
                this.childList.add(res);
                this.childTitles.add(name);
                this.childUcTitles.add(name.toUpperCase());
            }
            return res;
        }

        private IniItem openSection(String name) {
            IniItem res = this.readSection(name);
            if (res == null) {
                res = this.createSection(name);
            }
            return res;
        }

        private IniItem openKey(String name) {
            IniItem res = this.readKey(name);
            if (res == null) {
                res = this.createKey(name);
            }
            return res;
        }

        private IniItem readKey(String name) {
            IniItem res = null;
            int index = this.childUcTitles.indexOf(name.toUpperCase());
            if (index != -1) {
                res = this.childList.get(index);
            }
            return res;
        }

        private int childCount(IniItem cand, IniType tp) {
            int res = -1;
            if (cand.childList != null) {
                res = 0;
                for (IniItem child : cand.childList) {
                    if (tp != IniType.NONE) {
                        if (child.iniType != tp) continue;
                        ++res;
                        continue;
                    }
                    ++res;
                }
            }
            return res;
        }

        private String childList(IniType tp) {
            String res = "";
            for (IniItem child : this.childList) {
                IniType tpc = child.iniType;
                if (tp != IniType.NONE) {
                    if (tpc != tp) continue;
                    if (tp == IniType.SECTION) {
                        res = res.concat(this.sectionHeader(child.getText())).concat("\n");
                        continue;
                    }
                    if (tpc == IniType.KEY) {
                        res = res.concat(child.getText()).concat("\n");
                        continue;
                    }
                    res = res.concat(child.title).concat("\n");
                    continue;
                }
                if (tpc == IniType.KEY) {
                    res = res.concat(child.getText()).concat("\n");
                    continue;
                }
                res = res.concat(child.title).concat("\n");
            }
            if (res.length() > 0) {
                res = res.substring(0, res.length() - 1);
            }
            return res;
        }
    }

    public static enum IniType {
        NONE,
        INI,
        TEXT,
        SECTION,
        KEY,
        LINE;

    }
}

