/*
 * Decompiled with CFR 0.152.
 */
package exeversion;

import exeversion.BinaryFile;
import java.io.RandomAccessFile;

public class version_node {
    private int Node;
    private int Data;
    private int Type;
    private char[] Name;
    private char[] Value;
    private int[] rgbPadding1;
    private int[] rgbPadding2;
    private byte[] rgbData;
    version_node[] children;
    private long Signature;
    private long StructVersion;
    private int FileVersionMS1;
    private int FileVersionMS2;
    private int FileVersionLS1;
    private int FileVersionLS2;
    private long FileFlagsMasks;
    private long FileFlags;
    private long FileOS;
    private long FileType;
    private long FileSubtype;
    private long FileDateMS;
    private long FileDateLS;
    private String out = "";
    private String title = "";
    private BinaryFile bin;
    private RandomAccessFile file;

    public Boolean read(RandomAccessFile filename, long offset) {
        try {
            this.file = filename;
            this.bin = new BinaryFile(this.file);
            this.bin.setSigned(false);
            this.bin.setEndian((short)2);
            if (offset >= this.file.length() || offset < 0L) {
                return false;
            }
            this.file.seek(offset);
            this.Node = this.bin.readWord();
            this.Data = this.bin.readWord();
            this.Type = this.bin.readWord();
            this.rgbData = new byte[this.Data];
            for (int i = 0; i < this.rgbData.length; ++i) {
                this.rgbData[i] = (byte)this.bin.readByte();
                if (this.rgbData[i] == 0 && this.rgbData[i - 1] == 0) break;
            }
            this.file.seek(this.file.getFilePointer() + 3L);
            this.title = new String(this.rgbData, "UTF-8");
            this.Signature = this.bin.readDWord();
            this.StructVersion = this.bin.readDWord();
            this.FileVersionMS1 = this.bin.readWord();
            this.FileVersionMS2 = this.bin.readWord();
            this.FileVersionLS1 = this.bin.readWord();
            this.FileVersionLS2 = this.bin.readWord();
            this.FileFlagsMasks = this.bin.readDWord();
            this.FileFlags = this.bin.readDWord();
            this.FileOS = this.bin.readDWord();
            this.FileType = this.bin.readDWord();
            this.FileSubtype = this.bin.readDWord();
            this.FileDateMS = this.bin.readDWord();
            this.FileDateLS = this.bin.readDWord();
            this.out = this.FileVersionMS2 + "." + this.FileVersionMS1 + "." + this.FileVersionLS2 + "." + this.FileVersionLS1;
        }
        catch (Exception ex) {
            this.log("ERROR", "Read operation failed: " + ex.toString());
            this.out = "";
            return false;
        }
        return true;
    }

    public void debug() {
        System.out.println("[VERSION_NODE] " + this.title);
        System.out.println("Node: 0x" + Long.toHexString(this.Node));
        System.out.println("Data: 0x" + Long.toHexString(this.Data));
        System.out.println("Type: 0x" + Long.toHexString(this.Type));
        System.out.println("Signature: 0x" + Long.toHexString(this.Signature));
        System.out.println("StructVersion: 0x" + Long.toHexString(this.StructVersion));
        System.out.println("FileVersion: " + this.FileVersionMS2 + "." + this.FileVersionMS1);
        System.out.println("FileVersionLS = " + this.FileVersionLS1 + "." + this.FileVersionLS2);
        System.out.println("FileFlagsMasks: 0x" + Long.toHexString(this.Node));
        System.out.println("FileFlags: 0x" + Long.toHexString(this.Node));
        System.out.println("FileOS: 0x" + Long.toHexString(this.Node));
        System.out.println("FileType: 0x" + Long.toHexString(this.Node));
        System.out.println("FileSubtype: 0x" + Long.toHexString(this.Node));
        System.out.println("FileDateMS: 0x" + Long.toHexString(this.Node));
        System.out.println("FileDateLS: 0x" + Long.toHexString(this.Node));
        System.out.println();
    }

    private void log(String gender, String message) {
        System.out.println("[version][" + gender + "] " + message);
    }

    public String getVersionText() {
        return this.out;
    }
}

