/*
 * Decompiled with CFR 0.152.
 */
package exeversion;

import exeversion.BinaryFile;
import java.io.RandomAccessFile;
import utils.text;

public class image_section_header {
    private Boolean debug = false;
    private String Name;
    private long startOffset;
    private long VirtualSize;
    private long VirtualAddress;
    private long SizeOfRawData;
    private long PointerToRawData;
    private long PointerToRelocations;
    private long PointerToLinenumbers;
    private int NumberOfRelocations;
    private int NumberOfLineNumbers;
    private long Characteristics;
    private BinaryFile bin;
    private RandomAccessFile file;

    public Boolean Read(RandomAccessFile filename, long offset) {
        try {
            this.file = filename;
            this.bin = new BinaryFile(this.file);
            this.bin.setSigned(false);
            this.bin.setEndian((short)2);
            this.startOffset = offset;
            this.file.seek(offset);
            this.Name = this.bin.readFixedString(8);
            this.VirtualSize = this.bin.readDWord();
            this.VirtualAddress = this.bin.readDWord();
            this.SizeOfRawData = this.bin.readDWord();
            this.PointerToRawData = this.bin.readDWord();
            this.PointerToRelocations = this.bin.readDWord();
            this.PointerToLinenumbers = this.bin.readDWord();
            this.NumberOfRelocations = this.bin.readWord();
            this.NumberOfLineNumbers = this.bin.readWord();
            this.Characteristics = this.bin.readDWord();
        }
        catch (Exception ex) {
            this.log("ERROR", " Read operation failed: " + ex.toString());
            return false;
        }
        this.debug();
        return true;
    }

    protected void debug() {
        if (!this.debug.booleanValue()) {
            return;
        }
        this.log("DEBUG", "" + text.getHex("offset", this.startOffset) + text.doFormat("Name", this.Name) + text.getHex("VirtualSize", this.VirtualSize) + text.getHex("VirtualAddress", this.VirtualAddress) + text.getHex("SizeOfRawData", this.SizeOfRawData) + text.getHex("PointerToRawData", this.PointerToRawData) + text.getHex("PointerToRelocations", this.PointerToRelocations) + text.getHex("PointerToLinenumbers", this.PointerToLinenumbers) + text.getHex("NumberOfRelocations", this.NumberOfRelocations) + text.getHex("NumberOfLineNumbers", this.NumberOfLineNumbers) + text.getHex("Characteristics", this.Characteristics));
    }

    public String getName() {
        return this.Name;
    }

    public long getPointerToRawData() {
        return this.PointerToRawData;
    }

    public long getVirtualAddress() {
        return this.VirtualAddress;
    }

    private void log(String gender, String message) {
        System.out.println("[section_header][" + gender + "] " + message);
    }
}

