/*
 * Decompiled with CFR 0.152.
 */
package exeversion;

import exeversion.BinaryFile;
import exeversion.image_resource_directory_entry;
import java.io.RandomAccessFile;
import utils.text;

public class image_resource_directory_table {
    private Boolean debug = false;
    private long Characteristics;
    private long TimeDateStamp;
    private int MajorVersion;
    private int MinorVersion;
    private int NumberOfNamedEntries;
    private int NumberOfIdEntries;
    private image_resource_directory_entry[] entry;
    private BinaryFile bin;
    private RandomAccessFile file;

    public Boolean read(RandomAccessFile filename, String title, long offset) {
        try {
            this.file = filename;
            this.bin = new BinaryFile(this.file);
            this.bin.setSigned(false);
            this.bin.setEndian((short)2);
            if (offset >= this.file.length() || offset < 0L) {
                return false;
            }
            this.file.seek(offset);
            this.Characteristics = this.bin.readDWord();
            this.TimeDateStamp = this.bin.readDWord();
            this.MajorVersion = this.bin.readWord();
            this.MinorVersion = this.bin.readWord();
            this.NumberOfNamedEntries = this.bin.readWord();
            this.NumberOfIdEntries = this.bin.readWord();
            int n = this.NumberOfIdEntries + this.NumberOfNamedEntries;
            this.entry = new image_resource_directory_entry[n];
            if (n > 0 && n < 100) {
                for (int r = 0; r < n; ++r) {
                    this.entry[r] = new image_resource_directory_entry();
                    this.entry[r].read(filename, title, offset + 16L + (long)(r * 8));
                }
            }
        }
        catch (Exception ex) {
            this.log("ERROR", "Read operation failed: " + ex.toString());
            return false;
        }
        this.debug();
        return true;
    }

    public void debug() {
        if (!this.debug.booleanValue()) {
            return;
        }
        this.log("DEBUG", "" + text.getHex("Characteristics", this.Characteristics) + text.getHex("TimeStamp", this.TimeDateStamp) + text.getHex("Major", this.MajorVersion) + text.getHex("Minor", this.MinorVersion) + text.getHex("NumberOfNamedEntries", this.NumberOfNamedEntries) + text.getHex("NumberOfIdEntries: ", this.NumberOfIdEntries));
    }

    public int getNumberOfIdEntries() {
        return this.NumberOfIdEntries;
    }

    public int getNumberOfNamedEntries() {
        return this.NumberOfNamedEntries;
    }

    public image_resource_directory_entry getEntry(int i) {
        return this.entry[i];
    }

    private void log(String gender, String message) {
        System.out.println("[rsrc_dir_table][" + gender + "] " + message);
    }
}

