/*
 * Decompiled with CFR 0.152.
 */
package exeversion;

import exeversion.BinaryFile;
import exeversion.image_data_directory;
import java.io.RandomAccessFile;
import utils.text;

public class image_optional_header {
    private boolean debug = false;
    private int Magic;
    private short MajorLinkerVersion;
    private short MinorLinkerVersion;
    private long startOffset;
    private long SizeOfCode;
    private long SizeOfInitializedData;
    private long SizeOfUninitializedData;
    private long AddressOfEntryPoint;
    private long BaseOfCode;
    private long BaseOfData;
    private long ImageBase;
    private long SectionAlignment;
    private long FileAlignment;
    private int MajorOperatingSystemVersion;
    private int MinorOperatingSystemVersion;
    private int MajorImageVersion;
    private int MinorImageVersion;
    private int MajorSubSystemVersion;
    private int MinorSubSystemVersion;
    private long Win32VersionValue;
    private long SizeOfImage;
    private long SizeOfHeaders;
    private long Checksum;
    private int Subsystem;
    private int DllCharacteristics;
    private long SizeOfStackReserve;
    private long SizeOfStackCommit;
    private long SizeOfHeapReserve;
    private long SizeOfHeapCommit;
    private long LoaderFlags;
    private long NumberOfRvaAndSizes;
    private image_data_directory[] DataDirectory = new image_data_directory[15];
    private BinaryFile bin;
    private RandomAccessFile file;

    public Boolean read(RandomAccessFile filename, long offset) {
        try {
            this.file = filename;
            this.bin = new BinaryFile(this.file);
            this.bin.setSigned(false);
            this.bin.setEndian((short)2);
            this.startOffset = offset + 24L;
            this.file.seek(offset + 24L);
            this.Magic = this.bin.readWord();
            this.MajorLinkerVersion = this.bin.readByte();
            this.MinorLinkerVersion = this.bin.readByte();
            this.SizeOfCode = this.bin.readDWord();
            this.SizeOfInitializedData = this.bin.readDWord();
            this.SizeOfUninitializedData = this.bin.readDWord();
            this.AddressOfEntryPoint = this.bin.readDWord();
            this.BaseOfCode = this.bin.readDWord();
            this.BaseOfData = this.bin.readDWord();
            this.ImageBase = this.bin.readDWord();
            this.SectionAlignment = this.bin.readDWord();
            this.FileAlignment = this.bin.readDWord();
            this.MajorOperatingSystemVersion = this.bin.readWord();
            this.MinorOperatingSystemVersion = this.bin.readWord();
            this.MajorImageVersion = this.bin.readWord();
            this.MinorImageVersion = this.bin.readWord();
            this.MajorSubSystemVersion = this.bin.readWord();
            this.MinorSubSystemVersion = this.bin.readWord();
            this.Win32VersionValue = this.bin.readDWord();
            this.SizeOfImage = this.bin.readDWord();
            this.SizeOfHeaders = this.bin.readDWord();
            this.Checksum = this.bin.readDWord();
            this.Subsystem = this.bin.readWord();
            this.DllCharacteristics = this.bin.readWord();
            this.SizeOfStackReserve = this.bin.readDWord();
            this.SizeOfStackCommit = this.bin.readDWord();
            this.SizeOfHeapReserve = this.bin.readDWord();
            this.SizeOfHeapCommit = this.bin.readDWord();
            this.LoaderFlags = this.bin.readDWord();
            this.NumberOfRvaAndSizes = this.bin.readDWord();
            for (int i = 0; i < this.DataDirectory.length; ++i) {
                this.DataDirectory[i] = new image_data_directory();
                this.DataDirectory[i].setVirtualAddress(this.bin.readDWord());
                this.DataDirectory[i].setSize(this.bin.readDWord());
            }
        }
        catch (Exception ex) {
            this.log("ERROR", "Read operation, failed to read values from structure: " + ex.toString());
            return false;
        }
        this.debug();
        return true;
    }

    private void log(String gender, String message) {
        System.out.println("[Optional_header][" + gender + "] " + message);
    }

    protected void debug() {
        if (!this.debug) {
            return;
        }
        this.log("DEBUG", "" + text.getHex("offset", this.startOffset) + text.getHex("Magic", this.Magic) + text.getHex("MajorLinkerVersion", this.MajorLinkerVersion) + text.getHex("MinorLinkerVersion", this.MinorLinkerVersion) + text.getHex("SizeOfCode", this.SizeOfCode) + text.getHex("SizeOfInitializedData", this.SizeOfInitializedData) + text.getHex("SizeOfUninitializedData", this.SizeOfUninitializedData) + text.getHex("AddressOfEntryPoint", this.AddressOfEntryPoint) + text.getHex("BaseOfCode", this.BaseOfCode) + text.getHex("BaseOfData", this.BaseOfData) + text.getHex("ImageBase", this.ImageBase) + text.getHex("SectionAlignment", this.SectionAlignment) + text.getHex("FileAlignment", this.FileAlignment) + text.getHex("MajorOperatingSystemVersion", this.MajorOperatingSystemVersion) + text.getHex("MinorOperatingSystemVersion", this.MinorOperatingSystemVersion) + text.getHex("MajorImageVersion", this.MajorImageVersion) + text.getHex("MinorImageVersion", this.MinorImageVersion) + text.getHex("MajorSubSystemVersion", this.MajorSubSystemVersion) + text.getHex("MinorSubSystemVersion", this.MinorSubSystemVersion) + text.getHex(" Win32VersionValue", this.Win32VersionValue) + text.getHex("SizeOfImage", this.SizeOfImage) + text.getHex("SizeOfHeaders", this.SizeOfHeaders) + text.getHex("Checksum", this.Checksum) + text.getHex("Subsystem", this.Subsystem) + text.getHex("DllCharacteristics", this.DllCharacteristics) + text.getHex("SizeOfStackReserve", this.SizeOfStackReserve) + text.getHex("SizeOfStackCommit", this.SizeOfStackCommit) + text.getHex("SizeOfHeapReserve", this.SizeOfHeapReserve) + text.getHex("SizeOfHeapCommit", this.SizeOfHeapCommit) + text.getHex("LoaderFlags", this.LoaderFlags) + text.getHex("NumberOfRvaAndSizes", this.NumberOfRvaAndSizes));
    }

    public int getMagic() {
        return this.Magic;
    }
}

