/*
 * Decompiled with CFR 0.152.
 */
package exeversion;

import exeversion.BinaryFile;
import exeversion.image_dos_header;
import exeversion.image_file_header;
import exeversion.image_optional_header;
import exeversion.image_resource_directory_entry;
import exeversion.image_resource_directory_table;
import exeversion.image_section_header;
import exeversion.resource_data_entry;
import exeversion.version_node;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class image_nt_header {
    private Boolean debug = false;
    private Boolean hasVersion = false;
    private String Signature;
    private image_file_header FileHeader;
    private image_optional_header OptionalHeader;
    private image_resource_directory_table RootResourceDirectory = new image_resource_directory_table();
    private image_resource_directory_table VersionResourceDirectory = new image_resource_directory_table();
    private image_resource_directory_table VersionDataResourceDirectory = new image_resource_directory_table();
    private ArrayList<image_resource_directory_table> TypeResourceDirectory = new ArrayList();
    private ArrayList<image_section_header> SectionHeader = new ArrayList();
    private version_node version = new version_node();
    private BinaryFile bin;
    private RandomAccessFile file;
    private Long e_lfanew_offset;
    private String fileVersion;
    private String fileLanguage;
    private String fileArchitecture;

    private void readSectionHeaders() {
        long offset = 0L;
        try {
            this.file.seek(this.e_lfanew_offset + (long)this.FileHeader.getSizeOfOptionalHeader() + 24L);
            offset = this.file.getFilePointer();
        }
        catch (IOException ex) {
            this.log("ERROR", "ReadSections operation failed: " + ex.toString());
        }
        int n = this.FileHeader.getNumberOfSections();
        for (int i = 0; i < n; ++i) {
            image_section_header temp = new image_section_header();
            Boolean result = temp.Read(this.file, offset + (long)(40 * i));
            if (!result.booleanValue()) {
                this.log("ERROR", "Failed to read section #" + i);
                return;
            }
            this.SectionHeader.add(temp);
        }
    }

    private void exploreSectionContent(RandomAccessFile filename, String title) {
        for (image_section_header section : this.SectionHeader) {
            if (section.getName().contains(".rsrc")) {
                this.RootResourceDirectory.read(filename, title, section.getPointerToRawData());
                this.exploreResources(this.RootResourceDirectory, section, filename, title);
            }
            if (!this.hasVersion.booleanValue()) continue;
            break;
        }
    }

    private void exploreResources(image_resource_directory_table resource, image_section_header section, RandomAccessFile filename, String title) {
        int n = resource.getNumberOfIdEntries() + resource.getNumberOfNamedEntries();
        if (n == 0) {
            this.log("INFO", "ExploreResources, we found no entries to explore");
            return;
        }
        for (int x = 0; x < n; ++x) {
            image_resource_directory_table temp = new image_resource_directory_table();
            temp.read(filename, title, section.getPointerToRawData() + (long)resource.getEntry(x).getOffsetToDirectory());
            this.TypeResourceDirectory.add(temp);
            this.readIfVersionAvailable(resource.getEntry(x), section, filename, title);
        }
    }

    private void readIfVersionAvailable(image_resource_directory_entry entry, image_section_header section, RandomAccessFile filename, String title) {
        long r;
        if (entry.getID() != 16L) {
            return;
        }
        if (this.debug.booleanValue()) {
            this.log("EXTRA", "Found a VERSION resource");
        }
        if (!this.VersionResourceDirectory.read(filename, title, r = (long)entry.getOffsetToDirectory() + section.getPointerToRawData()).booleanValue()) {
            return;
        }
        int k = this.VersionResourceDirectory.getNumberOfIdEntries() + this.VersionResourceDirectory.getNumberOfNamedEntries();
        if (k == 0) {
            return;
        }
        long t = (long)this.VersionResourceDirectory.getEntry(0).getOffsetToDirectory() + section.getPointerToRawData();
        if (!this.VersionDataResourceDirectory.read(filename, title, t).booleanValue()) {
            return;
        }
        resource_data_entry versionData = new resource_data_entry();
        long y = (long)this.VersionDataResourceDirectory.getEntry(0).getOffsetToDirectory() + section.getPointerToRawData();
        if (!versionData.read(filename, y).booleanValue()) {
            return;
        }
        long versionDataOffset = versionData.getDataRVA() - (section.getVirtualAddress() - section.getPointerToRawData());
        if (!this.version.read(filename, versionDataOffset).booleanValue()) {
            return;
        }
        if (this.version.getVersionText().length() > 0) {
            this.hasVersion = true;
            this.fileVersion = this.version.getVersionText();
            this.fileLanguage = "0x" + Long.toHexString(this.VersionDataResourceDirectory.getEntry(0).getID());
            this.fileArchitecture = "0x" + Long.toHexString(this.OptionalHeader.getMagic()).toUpperCase();
            if (this.debug.booleanValue()) {
                this.log("INFO", this.version.getVersionText());
            }
        }
    }

    public Boolean read(RandomAccessFile filename, String title, image_dos_header DOS_header) {
        if (DOS_header.getLFAnew() <= 0L) {
            this.log("ERROR", "Read operation failed, value for LFAnew is not valid");
            return false;
        }
        this.hasVersion = false;
        this.e_lfanew_offset = DOS_header.getLFAnew();
        this.file = filename;
        try {
            this.file.seek(this.e_lfanew_offset);
            this.bin = new BinaryFile(this.file);
            this.bin.setSigned(false);
            this.bin.setEndian((short)2);
            this.Signature = this.bin.readFixedString(2);
        }
        catch (Exception e) {
            this.log("ERROR", "Read operation failed, unable of reading signature");
            return false;
        }
        if (!this.Signature.equals("PE")) {
            this.log("ERROR", "Read operation failed, signature does not match 'PE'");
            return false;
        }
        this.FileHeader = new image_file_header();
        this.FileHeader.read(filename, this.e_lfanew_offset);
        this.OptionalHeader = new image_optional_header();
        this.OptionalHeader.read(filename, this.e_lfanew_offset);
        this.readSectionHeaders();
        this.exploreSectionContent(filename, title);
        return true;
    }

    public String getFileArchitecture() {
        return this.fileArchitecture;
    }

    public String getFileLanguage() {
        return this.fileLanguage;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public Boolean hasVersion() {
        return this.hasVersion;
    }

    private void log(String gender, String message) {
        if (this.debug.booleanValue()) {
            System.out.println("[NT_header][" + gender + "] " + message);
        }
    }
}

