/*
 * Decompiled with CFR 0.152.
 */
package exeversion;

import exeversion.BinaryFile;
import java.io.RandomAccessFile;
import utils.text;

public class image_file_header {
    private Boolean debug = false;
    private int Machine;
    private int NumberOfSections;
    private long TimeDateStamp;
    private long PointerToSymbolTable;
    private long NumberOfSymbols;
    private int SizeOfOptionalHeader;
    private int Characteristics;
    private BinaryFile bin;
    private RandomAccessFile file;

    public Boolean read(RandomAccessFile filename, long e_lfanew_offset) {
        try {
            this.file = filename;
            this.bin = new BinaryFile(this.file);
            this.bin.setSigned(false);
            this.bin.setEndian((short)2);
            this.file.seek(e_lfanew_offset + 4L);
            this.Machine = this.bin.readWord();
            this.NumberOfSections = this.bin.readWord();
            this.TimeDateStamp = this.bin.readDWord();
            this.PointerToSymbolTable = this.bin.readDWord();
            this.NumberOfSymbols = this.bin.readDWord();
            this.SizeOfOptionalHeader = this.bin.readWord();
            this.Characteristics = this.bin.readWord();
        }
        catch (Exception ex) {
            this.log("ERROR", "Read operation failed, error while reading fields");
            return false;
        }
        this.debug();
        return true;
    }

    private void log(String gender, String message) {
        System.out.println("[file_header][" + gender + "] " + message);
    }

    protected void debug() {
        if (!this.debug.booleanValue()) {
            return;
        }
        this.log("DEBUG", "Results: " + text.getHex("Machine", this.Machine) + text.getHex("NumberOfSections", this.NumberOfSections) + text.getHex("TimeDateStamp", this.TimeDateStamp) + text.getHex("PointerToSymbolTable", this.PointerToSymbolTable) + text.getHex("NumberOfSymbols", this.NumberOfSymbols) + text.getHex("SizeOfOptionalHeader", this.SizeOfOptionalHeader) + text.getHex("Characteristics", this.Characteristics));
    }

    public int getNumberOfSections() {
        return this.NumberOfSections;
    }

    public int getSizeOfOptionalHeader() {
        return this.SizeOfOptionalHeader;
    }
}

