/*
 * Decompiled with CFR 0.152.
 */
package exeversion;

import exeversion.BinaryFile;
import java.io.RandomAccessFile;
import utils.text;

public class image_dos_header {
    protected boolean debug = false;
    private String e_magic;
    private int e_cblp;
    private int e_cp;
    private int e_crlc;
    private int e_cparhdr;
    private int e_minalloc;
    private int e_maxalloc;
    private int e_ss;
    private int e_sp;
    private int e_csum;
    private int e_ip;
    private int e_cs;
    private int e_lfarlc;
    private int e_ovno;
    private int[] e_res = new int[4];
    private int e_oemid;
    private int e_oeminfo;
    final int[] e_res2 = new int[10];
    private long e_lfanew = 0L;
    private BinaryFile bin;

    public Boolean read(RandomAccessFile file) {
        try {
            int i;
            this.bin = new BinaryFile(file);
            this.bin.setSigned(false);
            this.bin.setEndian((short)2);
            this.e_magic = this.bin.readFixedString(2);
            if (!this.e_magic.equalsIgnoreCase("MZ")) {
                this.log("ERROR", "Read operation failed, no magic signature was found");
                return false;
            }
            this.e_cblp = this.bin.readWord();
            this.e_cp = this.bin.readWord();
            this.e_crlc = this.bin.readWord();
            this.e_cparhdr = this.bin.readWord();
            this.e_minalloc = this.bin.readWord();
            this.e_maxalloc = this.bin.readWord();
            this.e_ss = this.bin.readWord();
            this.e_sp = this.bin.readWord();
            this.e_csum = this.bin.readWord();
            this.e_ip = this.bin.readWord();
            this.e_cs = this.bin.readWord();
            this.e_lfarlc = this.bin.readWord();
            this.e_ovno = this.bin.readWord();
            for (i = 0; i < this.e_res.length; ++i) {
                this.e_res[i] = this.bin.readWord();
            }
            this.e_oemid = this.bin.readWord();
            this.e_oeminfo = this.bin.readWord();
            for (i = 0; i < this.e_res2.length; ++i) {
                this.e_res2[i] = this.bin.readWord();
            }
            this.e_lfanew = this.bin.readDWord();
            this.debug();
        }
        catch (Exception ex) {
            this.log("error", "IO exception = " + ex);
            return false;
        }
        return true;
    }

    public long getLFAnew() {
        return this.e_lfanew;
    }

    private void log(String gender, String message) {
        if (this.debug) {
            System.out.println("[DOS_header][" + gender + "] " + message);
        }
    }

    protected void debug() {
        if (!this.debug) {
            return;
        }
        this.log("DEBUG", "Results: " + text.doFormat("e_magic", this.e_magic) + text.getHex("e_cblp", this.e_cblp) + text.getHex("e_cp", this.e_cp) + text.getHex("e_crlc", this.e_crlc) + text.getHex("e_cparhdr", this.e_cparhdr) + text.getHex("e_minalloc", this.e_minalloc) + text.getHex("e_maxalloc", this.e_maxalloc) + text.getHex("e_ss", this.e_ss) + text.getHex("e_sp", this.e_sp) + text.getHex("e_csum", this.e_csum) + text.getHex("e_ip", this.e_ip) + text.getHex("e_cs", this.e_cs) + text.getHex("e_lfarlc", this.e_lfarlc) + text.getHex("e_ovno", this.e_ovno) + text.getHex("e_oemid", this.e_oemid) + text.getHex("e_oeminfo", this.e_oeminfo) + text.getHex("e_lfanew", this.e_lfanew));
    }
}

