/*
 * Decompiled with CFR 0.152.
 */
package downloads;

import bsh2java.log;
import build.Core;
import commands.Command;
import commands.SubCommand;
import downloads.Catalog;
import downloads.Entry;
import java.io.File;
import java.util.ArrayList;
import utils.files;

public class Uninstall
extends Command {
    private SubCommand cmdREMOVE;
    private boolean preserveZIP = true;
    private File folderBase;
    private File folderCache;
    Entry threadedEntry;
    Uninstall slave;

    public Uninstall() {
        String folderRoot = System.getProperty("appDir");
        this.folderBase = new File(folderRoot, "downloads");
        this.folderCache = new File(this.folderBase, "cache");
    }

    public void setPreserve(boolean prev) {
        this.preserveZIP = prev;
    }

    @Override
    public String keyword() {
        return "UNINSTALL";
    }

    @Override
    public String description() {
        return "Uninstalls a resouce from http://reboot.pro/files";
    }

    @Override
    public String syntaxExample() {
        return "- Example to uninstall the firefox browser: \n" + this.keyword() + " firefox\n\n";
    }

    @Override
    public void action() {
        log.write(-1, "You need to specify the element to uninstall");
    }

    @Override
    public void subCommandsProcess() {
        this.isProcessing = true;
        String[] parms = this.parameters.split(" ");
        if (parms.length > 1 && parms[0].equalsIgnoreCase(this.cmdREMOVE.keyword)) {
            this.preserveZIP = false;
            this.parameters = parms[1];
        }
        int found = this.findResources(this.parameters);
        if (this.threadedEntry != null) {
            log.write(2, "Uninstalling \"%1\", please wait..", this.threadedEntry.title);
            this.launchWorker();
        } else if (found == 0) {
            log.write(26, "\"%1\" is not installed", this.parameters);
        } else {
            log.write(26, "\"%1\" could not be found unambiguously", this.parameters);
        }
    }

    void launchWorker() {
        if (this.slave == null) {
            this.slave = new Uninstall();
        }
        this.slave.isThreadProcessing = true;
        this.slave.setPreserve(this.preserveZIP);
        if (this.slave.getState() == Thread.State.TERMINATED) {
            this.slave = new Uninstall();
        }
        if (this.slave.getState() == Thread.State.NEW) {
            this.slave.threadedEntry = this.threadedEntry;
            this.slave.start();
            return;
        }
        if (this.slave.isThreadProcessing.booleanValue()) {
            log.write(-2, "Please wait for this operation to end before starting a new one.");
        }
    }

    void iterateResources() {
    }

    @Override
    public void run() {
        if (this.threadedEntry == null) {
            return;
        }
        this.isThreadProcessing = true;
        this.delete(this.threadedEntry);
        this.isThreadProcessing = false;
    }

    @Override
    public boolean isProcessing() {
        if (this.slave == null) {
            return false;
        }
        return this.slave.isThreadProcessing;
    }

    void delete(Entry entry) {
        File script = new File(entry.resourceFolder, "main.bsh");
        if (script.exists()) {
            this.core.script.run(script, "uninstall");
        }
        if (!this.preserveZIP && !entry.isLocal) {
            entry.resourceFile.delete();
        }
        files.deleteDir(entry.resourceFolder);
        log.write(20, "Uninstalled \"%1\"", entry.title);
        if (Core.temp.get("restart") != null) {
            Core.sys.getGui().setRestart();
        }
    }

    int findResources(String what) {
        this.threadedEntry = null;
        Catalog catalog = new Catalog();
        ArrayList<Entry> entryList = catalog.find(what);
        if (entryList.size() == 1) {
            this.threadedEntry = entryList.get(0);
        }
        return entryList.size();
    }

    @Override
    public void subCommandsCreate() {
        this.cmdREMOVE = new SubCommand();
        this.cmdREMOVE.keyword = "REMOVE";
        this.cmdREMOVE.descriptionShort = "Does also delete the local zip file";
        this.cmdREMOVE.descriptionLong = "";
        this.cmdREMOVE.syntaxExample = "";
        this.subCommandAdd(this.cmdREMOVE);
    }
}

