/*
 * Decompiled with CFR 0.152.
 */
package downloads;

import bsh2java.log;
import build.Core;
import downloads.Entry;
import java.io.File;
import java.util.ArrayList;
import net.lingala.zip4j.core.ZipFile;
import utils.files;
import utils.internet;

public final class Resource
extends Thread {
    private String urlContent;
    private String downloadId;
    private String downloadURL;
    private String topicId;
    private String title = "";
    private String version;
    private String memberName;
    private String memberId;
    private String lastUpdated;
    private String descriptionShort;
    private String decriptionLong;
    private String whatsNew;
    private File folderBase;
    private File fileSettings;
    private File folderCache;
    private File folderPlugin;
    public boolean isThreadProcessing = false;
    public boolean isLocal = false;

    public Resource(String downloadId, String title) {
        String folderRoot = System.getProperty("appDir");
        this.folderBase = new File(folderRoot, "downloads");
        this.folderCache = new File(this.folderBase, "cache");
        if (!this.folderBase.exists()) {
            files.mkdirs(this.folderBase);
        }
        if (!this.folderCache.exists()) {
            files.mkdirs(this.folderCache);
        }
        this.downloadId = downloadId;
        this.title = title;
    }

    public Resource(Entry entry) {
        String folderRoot = System.getProperty("appDir");
        if (entry.downloadId != null) {
            this.folderBase = new File(folderRoot, "downloads");
            this.folderCache = new File(this.folderBase, "cache");
            if (!this.folderBase.exists()) {
                files.mkdirs(this.folderBase);
            }
            if (!this.folderCache.exists()) {
                files.mkdirs(this.folderCache);
            }
        } else {
            this.folderCache = this.folderBase = new File(folderRoot);
        }
        this.downloadId = entry.downloadId;
        this.title = entry.title;
        this.isLocal = entry.isLocal;
    }

    @Override
    public void run() {
        ArrayList<File> files2;
        this.isThreadProcessing = true;
        if (this.getFolderDownload().exists() && (files2 = files.findAll(this.getFolderDownload(), 25)).size() > 0) {
            log.write(34, "\"%1\" is already installed, overwriting", this.title);
        }
        if (this.isLocal) {
            log.write(2, "Installing local \"%1\", please wait..", this.title);
        } else {
            log.write(2, "Downloading and installing \"%1\", please wait..", this.title);
            String downloadLink = "http://reboot.pro/files/file/" + this.downloadId + "-/";
            if (this.getFileCache().exists()) {
                this.urlContent = files.readAsString(this.getFileCache());
            } else {
                this.urlContent = internet.webget(downloadLink);
                files.SaveStringToFile(this.getFileCache(), this.urlContent);
            }
            this.getMemberId();
            this.getTopicId();
            this.getTitle();
            this.getVersion();
            this.getDownloadURL();
            this.doDownload();
        }
        if (!this.doDecompress().booleanValue()) {
            return;
        }
        this.runInstallScript();
        Object x = Core.temp.get("downloadResult");
        if (x == null) {
            log.write(20, "\"%1\" no application downloaded from internet!", this.title);
        } else {
            boolean result = (Boolean)Core.temp.get("downloadResult");
            if (result) {
                log.write(20, "\"%1\" was installed", this.title);
            } else {
                String url = (String)Core.temp.get("downloadURL");
                log.write(-5, "\"%1\" was not installed. %2 not found", this.title, url);
            }
        }
        if (Core.temp.get("restart") != null) {
            Core.sys.getGui().setRestart();
        }
        this.isThreadProcessing = false;
    }

    private void doDownload() {
        if (this.getFileDownload().exists()) {
            return;
        }
        internet.downloadFile(this.downloadURL, this.getFileDownload());
    }

    private void getMemberId() {
        String pointerA = ";mid=";
        String pointerB = "View other files from this member</a>";
        int posA = this.urlContent.indexOf(pointerA) + pointerA.length();
        int posB = this.urlContent.indexOf(pointerB) - 2;
        this.memberId = this.urlContent.substring(posA, posB);
    }

    private void getDownloadURL() {
        this.downloadURL = "http://reboot.pro/files/download/" + this.downloadId + "-/";
    }

    private void getTopicId() {
        String pointerB = "Get support for this file";
        int posB = this.urlContent.indexOf(pointerB);
        int posA = posB - 100;
        String temp = this.urlContent.substring(posA, posB);
        temp = temp.replace("\t", "");
        posA = temp.indexOf("topic") + 6;
        posB = temp.indexOf("-");
        this.topicId = temp.substring(posA, posB);
    }

    private void getTitle() {
        if ("".equals(this.title)) {
            String pointerA = "<!-- ::: NAVIGATION BREADCRUMBS ::: -->";
            String pointerB = "<!-- ::: CONTENT ::: -->";
            int posA = this.urlContent.indexOf(pointerA);
            int posB = this.urlContent.indexOf(pointerB);
            if (posA != -1 && posB != -1) {
                String temp = this.urlContent.substring(posA, posB);
                temp = temp.replace("\t", "");
                String[] lines = temp.split("itemprop");
                String lastLine = lines[lines.length - 1];
                pointerB = "</span></li></ol>";
                posB = lastLine.indexOf(pointerB);
                this.title = lastLine = lastLine.substring(9, posB);
            } else {
                pointerA = "<meta property=\"og:title\" content=\"";
                pointerB = "\"/>";
                posA = this.urlContent.indexOf(pointerA) + pointerA.length();
                posB = this.urlContent.indexOf(pointerB, posA + 1);
                if (posA != -1 && posB != -1) {
                    this.title = this.urlContent.substring(posA, posB);
                }
            }
        }
    }

    private void getVersion() {
        String pointerA = "download_button rounded right";
        String pointerB = "</h1>";
        int posA = this.urlContent.indexOf(pointerA) + pointerA.length();
        int posB = this.urlContent.indexOf(pointerB);
        String temp = this.urlContent.substring(posA, posB);
        temp = temp.replace("\t", "");
        temp = temp.substring(14);
        this.version = temp = temp.replace(this.title + " ", "");
    }

    public File getFileCache() {
        if (this.downloadId != null) {
            return new File(this.folderCache, "page-" + this.downloadId + ".html");
        }
        return this.fileSettings;
    }

    public File getFileSettingsCache() {
        if (this.downloadId != null) {
            return new File(this.folderCache, "settings-" + this.downloadId + ".xml");
        }
        return new File(this.fileSettings.getAbsolutePath().replace(".html", ".xml"));
    }

    public File getFileDownload() {
        return new File(this.folderBase, this.downloadId + "-" + this.title + ".zip");
    }

    public File getFolderDownload() {
        return new File(this.folderBase, this.downloadId + "-" + this.title);
    }

    public File getFileScript() {
        return new File(this.getFolderDownload(), "main.bsh");
    }

    public String getResName() {
        return this.title;
    }

    public void setFileSettings(File project) {
        File settingsDir = new File(project, this.downloadId + "-" + this.title);
        this.fileSettings = new File(settingsDir, "settings.html");
    }

    public void setFileSettings(String htmlPath) {
        this.fileSettings = new File(htmlPath);
    }

    public File getFileSettings() {
        if (this.fileSettings == null) {
            return new File(this.getFolderDownload(), "settings.html");
        }
        return this.fileSettings;
    }

    private Boolean doDecompress() {
        Boolean hasPassword = false;
        String filename = this.getFileDownload().getName();
        String passwordValue = "";
        try {
            ZipFile zipFile = new ZipFile(this.getFileDownload());
            if (!zipFile.isValidZipFile()) {
                log.write(30, "%1 is not a valid Zip file", this.getFileDownload().getAbsolutePath());
                return false;
            }
            if (zipFile.isEncrypted()) {
                if (Core.sys.settings.hasKey("password-" + filename).booleanValue()) {
                    passwordValue = Core.sys.settings.read("password-" + filename);
                }
                if (passwordValue.isEmpty() && Core.sys.settings.hasKey("password").booleanValue()) {
                    passwordValue = Core.sys.settings.read("password");
                }
                if (passwordValue.isEmpty()) {
                    log.write(-2, "A password is needed to decompressthe archive: %1", this.getFileDownload().getAbsolutePath());
                    return false;
                }
                if (passwordValue.endsWith("?")) {
                    zipFile.setPassword("reboot" + passwordValue + "file");
                } else {
                    zipFile.setPassword(passwordValue);
                }
                hasPassword = true;
            }
            zipFile.extractAll(this.getFolderDownload().getAbsolutePath());
        }
        catch (Exception e) {
            log.write(-5, "Failed to decompress package %1", this.getFileDownload().getAbsolutePath());
            return false;
        }
        if (hasPassword.booleanValue()) {
            Core.sys.settings.write("password-" + filename, passwordValue);
        }
        return true;
    }

    private void runInstallScript() {
        if (this.getFileScript().exists()) {
            Core.sys.script.run(this.getFileScript(), "install");
        }
    }
}

