/*
 * Decompiled with CFR 0.152.
 */
package downloads;

import bsh2java.log;
import build.Core;
import commands.Command;
import commands.SubCommand;
import downloads.Catalog;
import downloads.Entry;
import downloads.Resource;
import java.util.ArrayList;

public class Install
extends Command {
    private SubCommand cmdList;
    protected Catalog catalog;
    private ArrayList<Entry> toDownload = new ArrayList();
    ArrayList<Resource> slaves = new ArrayList();

    @Override
    public String keyword() {
        return "INSTALL";
    }

    @Override
    public String description() {
        return "Download and install apps from http://reboot.pro/files";
    }

    @Override
    public String syntaxExample() {
        return "- Example to install the firefox browser: \n" + this.keyword() + " firefox\n\n" + "- Example to find downloads matching \"win\" on their title: \n" + this.keyword() + " win";
    }

    @Override
    public void action() {
        log.write(-1, "You need to specify the element to install");
    }

    @Override
    public void subCommandsProcess() {
        if (this.cmdList != null && this.cmdList.isChosen(this.parameters)) {
            this.doList();
            return;
        }
        this.doInstall(this.parameters);
    }

    @Override
    public void subCommandsCreate() {
        this.cmdList = new SubCommand();
        this.cmdList.keyword = "LIST";
        this.cmdList.descriptionShort = "Lists the available downloads";
        this.cmdList.descriptionLong = "";
        this.cmdList.syntaxExample = "- Example to list all available downloads: \n" + this.keyword() + " list";
        this.subCommandAdd(this.cmdList);
    }

    private void doList() {
        ArrayList<Entry> result;
        if (this.catalog == null) {
            this.catalog = new Catalog();
        }
        if ((result = this.catalog.getList()).isEmpty()) {
            log.write(30, "No downloads available");
            return;
        }
        String list = "";
        for (Entry entry : result) {
            if (entry.isLocal) continue;
            String version = entry.version.isEmpty() ? "" : " (" + entry.version + ")";
            String temp = entry.cat.title + " --> " + entry.title + version;
            list = list.concat("\n" + temp);
        }
        log.write(30, "List of available resources\nCategory    |    Title%1\n%2 downloads available", list, "" + result.size());
    }

    void runThreadedDownload() {
        this.isProcessing = true;
        while (this.toDownload.size() > 0) {
            Entry entry = this.toDownload.get(0);
            Resource resource = entry.isLocal ? new Resource(entry) : new Resource(entry.downloadId, entry.title);
            Core.temp.put("downloadResult", true);
            resource.isThreadProcessing = true;
            resource.start();
            this.slaves.add(resource);
            this.toDownload.remove(entry);
        }
        this.isProcessing = false;
    }

    public void doInstall(Entry entry) {
        this.toDownload.add(entry);
        this.runThreadedDownload();
    }

    public void setCatalog(Catalog newCat) {
        this.catalog = newCat;
    }

    public void doInstall(String what) {
        ArrayList<Entry> entryList;
        if (this.catalog == null) {
            this.catalog = new Catalog();
        }
        if ((entryList = this.catalog.find(what)).isEmpty()) {
            log.write(404, "No results found for: %1", what);
            return;
        }
        if (entryList.size() == 1) {
            this.toDownload.add(entryList.get(0));
            this.runThreadedDownload();
            return;
        }
        String result = "";
        for (Entry entry : entryList) {
            result = result.concat("-> " + entry.title + "\n");
        }
        log.write(30, "Multiple entries match your search term, which file do you want to install? \n%1", result);
    }

    @Override
    public boolean isProcessing() {
        if (this.slaves.isEmpty()) {
            return false;
        }
        ArrayList<Resource> temp = new ArrayList<Resource>();
        for (Resource slave : this.slaves) {
            if (!slave.isThreadProcessing) continue;
            temp.add(slave);
        }
        this.slaves = temp;
        return this.slaves.size() > 0;
    }

    public class InstallThread
    extends Thread {
        private String plugin = null;

        public InstallThread(String plugin) {
            this.plugin = plugin;
        }

        @Override
        public void run() {
            Install.this.doInstall(this.plugin);
        }
    }
}

