/*
 * Decompiled with CFR 0.152.
 */
package downloads;

import bsh2java.log;
import build.Core;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.URL;
import utils.files;

public class DownloadBigFile {
    private String sourceURL;
    private String contentType;
    private String title = "download";
    private File file;
    private Boolean isDownloading = false;
    private BigInteger expectedSize;
    private long lastPercent = 0L;

    public DownloadBigFile(String sourceURL, String targetFile) {
        this.file = new File(targetFile);
        this.sourceURL = sourceURL;
    }

    public void getFile() {
        String fullSize;
        this.isDownloading = true;
        boolean fileAlreadyExists = this.file.exists();
        if (fileAlreadyExists && this.file.length() == this.expectedSize.longValue()) {
            return;
        }
        try {
            int bytesread;
            fullSize = files.humanReadableSize(this.expectedSize.longValue());
            RandomAccessFile out = new RandomAccessFile(this.file, "rw");
            URL url = new URL(this.sourceURL);
            InputStream fileInputStream = url.openStream();
            long bytesTotal = 0L;
            long theSize = this.expectedSize.longValue();
            if (fileAlreadyExists) {
                long step;
                log.write(30, "Continuing interrupted download");
                log.write(30, "Skipping already downloaded data");
                out.seek(this.file.length());
                for (step = this.expectedSize.longValue() / 100L; step < 0x100000L; step *= 10L) {
                }
                while (bytesTotal < this.file.length()) {
                    fileInputStream.skip(step);
                    double quotient = (double)(bytesTotal += step) / (double)this.expectedSize.longValue() * 100.0;
                    this.lastPercent = Math.round(quotient);
                    log.write(30, "%1 -> %2 (%3% complete)", "skip", files.humanReadableSize(bytesTotal) + " / " + fullSize, "" + this.lastPercent);
                    long diff = this.file.length() - bytesTotal;
                    if (diff == 0L) break;
                    if (diff >= step) continue;
                    step = diff;
                }
                log.write(30, "Skip complete. Downloading ...");
            }
            byte[] buf = new byte[8192];
            int bytesBuffered = 0;
            while ((bytesread = fileInputStream.read(buf)) != -1) {
                out.write(buf, 0, bytesread);
                bytesTotal += (long)bytesread;
                if ((bytesBuffered += bytesread) <= 0x100000) continue;
                bytesBuffered = 0;
                Core.temp.put(this.sourceURL, bytesTotal);
                long currentPercent = bytesTotal * 100L / this.expectedSize.longValue();
                long dif = currentPercent - this.lastPercent;
                if (dif > 0L) {
                    String readableSize = files.humanReadableSize(this.file.length());
                    log.write(30, "%1 -> %2 (%3% complete)", this.title, readableSize + " / " + fullSize, "" + currentPercent);
                }
                this.lastPercent = currentPercent;
            }
            fileInputStream.close();
            out.close();
        }
        catch (Exception e) {
            log.write(-1, e.getMessage());
        }
        fullSize = files.humanReadableSize(this.file.length());
        log.write(30, "Download complete, %1", fullSize);
        this.isDownloading = false;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public File getTargetFile() {
        return this.file;
    }

    public Boolean getIsDownloading() {
        return this.isDownloading;
    }

    public BigInteger getExpectedSize() {
        return this.expectedSize;
    }

    public void setExpectedSize(BigInteger expectedSize) {
        this.expectedSize = expectedSize;
    }

    public static void main(String[] args) {
        String targetFile = "last.exe";
        String sourceURL = "http://appldnld.apple.com.edgesuite.net/content.info.apple.com/QuickTime/061-5376.20090121.BD7E9/QuickTimeInstaller.exe";
        DownloadBigFile download = new DownloadBigFile(sourceURL, targetFile);
        download.setExpectedSize(new BigInteger("21878064"));
        download.getFile();
    }
}

