/*
 * Decompiled with CFR 0.152.
 */
package downloads;

import bsh2java.log;
import build.Core;
import commands.Command;
import downloads.DownloadItem;
import net.sf.sevenzipjbinding.ArchiveFormat;
import utils.ExtractSevenZip;

public class CommandUPGRADE
extends Command {
    final String targetSource = "WinBuilder";
    private DownloadItem downloadEntry = null;

    private void findEntry() {
        for (DownloadItem item : this.core.downloads.get.items) {
            if (!item.shortTitle.equals("WinBuilder")) continue;
            this.downloadEntry = item;
        }
    }

    public void isUpgradeNeeded() {
        this.findEntry();
        String versionInternal = Core.version;
        if (this.downloadEntry.version.compareToIgnoreCase(versionInternal) > 0) {
            log.write(34, "Version %1 of WinBuilder is available and you are using version %2 that might no longer be supported. To download the newer version, type \"UPGRADE\"", this.downloadEntry.version, versionInternal);
        } else {
            this.downloadEntry = null;
        }
    }

    @Override
    public void action() {
        if (this.downloadEntry == null) {
            log.write(30, "You already have the actual version of %1!", "WinBuilder");
        } else {
            if (this.downloadEntry.file.exists()) {
                this.downloadEntry.file.delete();
            }
            Thread test = new Thread(){

                @Override
                public void run() {
                    CommandUPGRADE up = new CommandUPGRADE();
                    up.downloadEntry = CommandUPGRADE.this.downloadEntry;
                    up.doAction();
                }
            };
            test.start();
        }
    }

    public void doAction() {
        log.write(30, "Downloading latest %1", "WinBuilder");
        this.downloadEntry.getFile(false);
        ExtractSevenZip test = new ExtractSevenZip(this.downloadEntry.file, this.core.appDir, null);
        test.setArchiveFormat(ArchiveFormat.ZIP);
        test.createTimer(1L, 5);
        try {
            test.extract();
        }
        catch (ExtractSevenZip.ExtractionException ex) {
            log.write(-1, "Problems when extracting %1", this.downloadEntry.file.getName());
        }
        this.downloadEntry.file.delete();
        this.settings.write("Upgrade", "Done");
        Core.sys.getGui().setRestart();
    }

    @Override
    public String keyword() {
        return "UPGRADE";
    }

    @Override
    public String description() {
        return "Upgrades WinBuilder to the most recent version";
    }

    @Override
    public String syntaxExample() {
        return "";
    }

    @Override
    public void subCommandsProcess() {
    }

    @Override
    public void subCommandsCreate() {
    }
}

