/*
 * Decompiled with CFR 0.152.
 */
package downloads;

import bsh2java.log;
import build.Core;
import commands.Command;
import commands.SubCommand;
import downloads.DownloadItem;
import downloads.common;
import inifiles.IniFile;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import utils.files;
import utils.internet;

public final class CommandDOWNLOAD
extends Command {
    public ArrayList<DownloadItem> items = new ArrayList();
    private SubCommand cmdSTATUS;
    private SubCommand cmdLIST;
    private IniFile theIni;

    public CommandDOWNLOAD(String url) {
        String actDate = files.getDate();
        File iniName = new File(common.getFolderCache(), "sourceCDList.ini");
        internet.downloadFile(url, iniName);
        this.theIni = new IniFile(iniName);
        String readDate = this.theIni.keyRead("Date", "actual", actDate);
        if (actDate.compareTo(readDate) > 0) {
            internet.downloadFile(url, iniName);
            this.theIni = new IniFile(iniName);
            this.theIni.keyWrite("Date", "actual", actDate);
            try {
                this.theIni.updateFile();
            }
            catch (IOException ex) {
                Logger.getLogger(CommandDOWNLOAD.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        String count = this.theIni.keyRead("Items", "count", "1");
        int cnt = Integer.parseInt(count);
        for (int i = 1; i <= cnt; ++i) {
            String md5;
            String longTitle;
            String filename;
            String shortTitle;
            String version;
            String URL2;
            DownloadItem item = new DownloadItem();
            String actDownload = "Item" + String.valueOf(i);
            item.URL = URL2 = this.theIni.keyRead(actDownload, "URL", "");
            item.version = version = this.theIni.keyRead(actDownload, "version", "");
            String size = CommandDOWNLOAD.getFileSize(URL2);
            if (size.equals("-1")) {
                size = this.theIni.keyRead(actDownload, "size", "-1");
            }
            item.setSize(size);
            item.shortTitle = shortTitle = this.theIni.keyRead(actDownload, "shortTitle", "");
            item.filename = filename = this.theIni.keyRead(actDownload, "filename", "");
            item.file = new File(common.getFolderDownloads(), item.filename);
            item.longTitle = longTitle = this.theIni.keyRead(actDownload, "longTitle", "");
            item.md5 = md5 = this.theIni.keyRead(actDownload, "md5", "");
            this.items.add(item);
        }
    }

    public IniFile getIni() {
        return this.theIni;
    }

    @Override
    public String keyword() {
        return "DOWNLOAD";
    }

    @Override
    public String description() {
        return "Allows downloading pre-defined files from the Internet";
    }

    @Override
    public String syntaxExample() {
        return "- Example to get a download listed as \"win7sp1\":\n" + this.keyword() + " win7sp1\n\n" + "- Example to just download a file from the Internet:\n" + this.keyword() + " http://example.com/test.zip\n\n";
    }

    @Override
    public void action() {
        log.write(-1, "You need to specify the element to download");
    }

    @Override
    public void subCommandsProcess() {
        if (this.cmdSTATUS.isChosen(this.parameters)) {
            this.doStatus();
            return;
        }
        if (this.cmdLIST.isChosen(this.parameters)) {
            this.doList();
            return;
        }
        for (DownloadItem item : this.items) {
            if (!item.shortTitle.equalsIgnoreCase(this.parameters)) continue;
            if (item.isDownloading.booleanValue()) {
                log.write(-2, "Download of %1 is already in progress", item.longTitle);
                return;
            }
            if (item.file.exists() && item.file.length() == item.fileSize.longValue()) {
                log.write(30, "File %1 was already downloaded and is available at %2", item.longTitle, item.file.getAbsolutePath());
                return;
            }
            log.write(30, "Downloading %1, please wait..", item.longTitle);
            item.getFile(true);
            return;
        }
        DownloadItem item = new DownloadItem();
        item.URL = this.parameters;
        String siz = CommandDOWNLOAD.getFileSize(this.parameters);
        if (!siz.equals("-1")) {
            item.shortTitle = "UserDownload";
            item.md5 = "";
            File test = new File(this.parameters);
            item.filename = test.getName();
            item.file = new File(common.getFolderDownloads(), item.filename);
            if (item.file.exists()) {
                item.file.delete();
            }
            item.longTitle = "User defined download of " + this.parameters;
            item.getFile(false);
        } else {
            log.write(30, "Download item %1 not found", this.parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileSize(String urltext) {
        HttpURLConnection conn = null;
        long siz = -1L;
        try {
            URL url = new URL(urltext);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.getInputStream();
            siz = conn.getContentLength();
        }
        catch (IOException e) {
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return String.valueOf(siz);
    }

    @Override
    public void subCommandsCreate() {
        this.cmdSTATUS = new SubCommand();
        this.cmdSTATUS.keyword = "STATUS";
        this.cmdSTATUS.descriptionShort = "Displays the progress of active downloads";
        this.cmdSTATUS.descriptionLong = "";
        this.cmdSTATUS.syntaxExample = "- Example to see the progress status of active downloads:\n" + this.keyword() + " " + this.cmdSTATUS.keyword + "\n\n";
        this.subCommandAdd(this.cmdSTATUS);
        this.cmdLIST = new SubCommand();
        this.cmdLIST.keyword = "LIST";
        this.cmdLIST.descriptionShort = "Lists files available for download";
        this.cmdLIST.descriptionLong = "";
        this.cmdLIST.syntaxExample = "- Example to view the list of available downloads:\n" + this.keyword() + " " + this.cmdLIST.keyword + "\n\n";
        this.subCommandAdd(this.cmdLIST);
    }

    private void doList() {
        log.print("List of available downloads:");
        for (DownloadItem item : this.items) {
            log.print(item.shortTitle + " => " + item.longTitle);
        }
    }

    private void doStatus() {
        for (DownloadItem item : this.items) {
            if (!item.isDownloading.booleanValue() || Core.temp.containsKey(item.URL)) continue;
            long currentValue = (Long)Core.temp.get(item.URL);
            String readableSize = files.humanReadableSize(currentValue);
            String fullSize = files.humanReadableSize(item.fileSize.longValue());
            long percent = currentValue * 100L / item.fileSize.longValue();
            log.write(30, "%1 -> %2 (%3% complete)", item.shortTitle, readableSize + " / " + fullSize, "" + percent);
        }
    }
}

