/*
 * Decompiled with CFR 0.152.
 */
package downloads;

import bsh2java.log;
import build.Core;
import downloads.Category;
import downloads.Entry;
import downloads.common;
import java.io.File;
import java.util.ArrayList;
import utils.files;
import utils.internet;
import utils.time;

public final class Catalog {
    private String urlContent;
    public Boolean showMessages = false;
    ArrayList<Entry> list;
    String userinput;
    String[] cats;
    boolean addLocal;

    public Catalog() {
        this.userinput = Core.sys.settings.read("DownloadCatalog", "10");
        this.cats = this.userinput.split(",");
        this.addLocal = true;
        this.list = new ArrayList();
        this.index();
    }

    public Catalog(String cat) {
        this.userinput = Core.sys.settings.read("DownloadCatalog", "10");
        this.cats = this.userinput.split(",");
        this.addLocal = true;
        this.cats = new String[1];
        this.cats[0] = cat;
        this.addLocal = false;
        this.list = new ArrayList();
        this.index();
    }

    public void removeListEntry(Entry entry) {
        this.list.remove(entry);
    }

    public void addListEntry(Entry entry) {
        this.list.add(entry);
    }

    public void noLocal() {
        this.addLocal = false;
        this.list = new ArrayList();
        this.index();
    }

    private void addList(ArrayList list, File dir2) {
        ArrayList<File> temp = files.findSubFolders(dir2);
        for (File file : temp) {
            String name = file.getName();
            String[] parts = name.split("\\-");
            if (parts.length <= 1) continue;
            Entry entry = new Entry();
            if (parts.length == 2) {
                entry.title = parts[1];
            } else {
                String tmp = parts[1];
                for (int i = 2; i < parts.length; ++i) {
                    tmp = tmp + "-" + parts[i];
                }
                entry.title = tmp;
            }
            entry.downloadId = parts[0];
            list.add(entry);
        }
    }

    public Catalog(File base) {
        this.userinput = Core.sys.settings.read("DownloadCatalog", "10");
        this.cats = this.userinput.split(",");
        this.addLocal = true;
        this.list = new ArrayList();
        this.addList(this.list, base);
        this.addList(this.list, base.getParentFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void index() {
        File folderRoot;
        File[] files2;
        if (this.showMessages.booleanValue()) {
            log.write(30, "Downloading updated information from the internet, please wait..");
        }
        for (String cat : this.cats) {
            String downloadLink = "http://reboot.pro/files/category/" + cat + "-/";
            String tmp = internet.webget(downloadLink);
            boolean isOnline = tmp.length() > 500;
            File catFile = this.getFileCache(cat);
            if ((!catFile.exists() || time.getFileAge(catFile) != 1) && isOnline) {
                File folder = catFile.getParentFile();
                this.urlContent = tmp;
                if (!folder.exists()) {
                    files.mkdirs(folder);
                }
                files.SaveStringToFile(this.getFileCache(cat), this.urlContent);
            } else if (catFile.exists()) {
                this.urlContent = files.readAsString(catFile);
            }
            if (this.urlContent != null) {
                Category temp = new Category(cat);
                try {
                    temp.doTitle(this.urlContent);
                    continue;
                }
                catch (Exception e) {
                    log.write(-1, "Failed to contact the downloads portal. Is the site down or perhaps no Internet is available?");
                    continue;
                }
                finally {
                    this.doEntries(temp);
                }
            }
            log.write(-1, "Failed to contact the downloads portal. Is the site down or perhaps no Internet is available?");
        }
        if (this.showMessages.booleanValue()) {
            log.write(30, "Download catalog updated");
        }
        if (this.addLocal && (files2 = (folderRoot = common.getFolderDownloads()).listFiles()).length != 0) {
            for (File file : files2) {
                String name;
                if (!file.isFile() || !(name = file.getName()).toLowerCase().endsWith(".zip")) continue;
                Entry entry = this.processLocalEntry(name);
                boolean doit = true;
                for (int i = 0; i < this.list.size(); ++i) {
                    if (!this.list.get((int)i).title.equals(entry.title)) continue;
                    Entry remote = this.list.get(i);
                    if (!remote.downloadId.equals(entry.downloadId)) {
                        remote.resourceFile = entry.resourceFile;
                        remote.resourceFolder = entry.resourceFolder;
                        remote.downloadId = entry.downloadId;
                        remote.isLocal = true;
                    }
                    doit = false;
                    break;
                }
                if (!doit) continue;
                entry.isLocal = true;
                this.list.add(entry);
            }
        }
    }

    Entry processLocalEntry(String zipName) {
        String name = zipName.substring(0, zipName.length() - 4);
        Entry entry = new Entry();
        String pluginName = name;
        String downloadId = "0";
        String[] parts = name.split("\\-");
        if (parts.length > 1) {
            if (parts.length == 2) {
                pluginName = parts[1];
            } else {
                pluginName = parts[1];
                for (int i = 2; i < parts.length; ++i) {
                    pluginName = pluginName + "-" + parts[i];
                }
            }
            downloadId = parts[0];
        }
        entry.title = pluginName;
        entry.downloadId = downloadId;
        entry.resourceFile = new File(common.getFolderDownloads(), zipName);
        entry.resourceFolder = new File(common.getFolderDownloads(), name);
        entry.version = "";
        entry.author = "";
        entry.description = "";
        return entry;
    }

    public ArrayList<Entry> find(String what) {
        ArrayList<Entry> result = new ArrayList<Entry>();
        String temp = what.toLowerCase();
        for (Entry entry : this.list) {
            if (!temp.equalsIgnoreCase(entry.title)) continue;
            result.add(entry);
            return result;
        }
        if (what.length() < 3) {
            return result;
        }
        for (Entry entry : this.list) {
            if (!entry.title.toLowerCase().startsWith(temp)) continue;
            result.add(entry);
        }
        for (Entry entry : this.list) {
            if (!entry.title.toLowerCase().contains(temp)) continue;
            boolean contains = false;
            for (Entry res : result) {
                if (!res.title.toLowerCase().contains(temp)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            result.add(entry);
        }
        return result;
    }

    private File getFileCache(String cat) {
        return new File(common.getFolderCache(), "cat-" + cat + ".html");
    }

    private void doEntries(Category cat) {
        String pointerA = "idm_category";
        String pointerB = "board_stats";
        int posA = this.urlContent.indexOf(pointerA);
        int posB = this.urlContent.indexOf(pointerB);
        String text2 = this.urlContent.substring(posA, posB);
        text2 = text2.replace("\t", "");
        String[] lines = text2.split("h3 class");
        for (int i = 1; i < lines.length; ++i) {
            Entry entry = this.processEntry(lines[i]);
            entry.cat = cat;
            this.list.add(entry);
        }
    }

    Entry processEntry(String text2) {
        Entry entry = new Entry();
        String pointerA = "View file named ";
        int posA = text2.indexOf(pointerA) + pointerA.length();
        String temp = text2.substring(posA);
        int posB = temp.indexOf("'");
        entry.title = temp = temp.substring(0, posB);
        pointerA = "http://reboot.pro/files/file/";
        posA = text2.indexOf(pointerA);
        if (posA > 0) {
            temp = text2.substring(posA += pointerA.length());
            posB = temp.indexOf("-");
            entry.downloadId = temp = temp.substring(0, posB);
        } else {
            pointerA = "http://reboot.pro/index.php?";
            posA = text2.indexOf(pointerA) + pointerA.length();
            temp = text2.substring(posA);
            String pointerB = "app=downloads&showfile=".replace("&", "&amp;");
            posB = temp.indexOf(pointerB);
            temp = temp.substring(posB + pointerB.length());
            posB = temp.indexOf("'");
            entry.downloadId = temp = temp.substring(0, posB);
        }
        pointerA = "ipsType_small";
        posA = text2.indexOf(pointerA) + pointerA.length() + 2;
        temp = text2.substring(posA);
        posB = temp.indexOf("span") - 2;
        temp = temp.substring(0, posB);
        entry.version = temp.length() < 20 ? temp : "";
        pointerA = "desc lighter";
        posA = text2.indexOf(pointerA) + pointerA.length() + 5;
        temp = text2.substring(posA);
        posB = temp.indexOf("div") - 2;
        entry.author = temp = temp.substring(0, posB);
        pointerA = "'desc'";
        posA = text2.indexOf(pointerA) + pointerA.length() + 1;
        temp = text2.substring(posA);
        posB = temp.indexOf("span") - 2;
        entry.description = temp = temp.substring(0, posB);
        entry.resourceFolder = new File(common.getFolderDownloads(), entry.downloadId + "-" + entry.title);
        entry.resourceFile = new File(common.getFolderDownloads(), entry.downloadId + "-" + entry.title + ".zip");
        return entry;
    }

    public ArrayList<Entry> getList() {
        return this.list;
    }
}

