/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.rockridge.impl;

import de.tu_darmstadt.informatik.rbg.hatlak.rockridge.impl.SystemUseEntryElement;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.ContentHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.DataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.Element;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.Fixup;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.StructureHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ByteArrayDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ByteDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ChainingStreamHandler;
import java.util.Stack;

public class SystemUseEntryHandler
extends ChainingStreamHandler {
    private Stack elements = new Stack();
    private int length = 0;
    private Fixup lengthFixup;

    public SystemUseEntryHandler(StructureHandler chainingStructureHandler, ContentHandler chainingContentHandler) {
        super(chainingStructureHandler, chainingContentHandler);
    }

    public void startElement(Element element) throws HandlerException {
        this.elements.push(element);
        if (element instanceof SystemUseEntryElement) {
            SystemUseEntryElement sue = (SystemUseEntryElement)element;
            this.length = 0;
            this.data(new ByteArrayDataReference(sue.getSignatureWord()));
            this.lengthFixup = this.fixup(new ByteDataReference(0L));
            this.data(new ByteDataReference(sue.getVersion()));
        }
        super.startElement(element);
    }

    public void data(DataReference reference) throws HandlerException {
        this.length = (int)((long)this.length + reference.getLength());
        super.data(reference);
    }

    public Fixup fixup(DataReference reference) throws HandlerException {
        this.length = (int)((long)this.length + reference.getLength());
        return super.fixup(reference);
    }

    public void endElement() throws HandlerException {
        Element element = (Element)this.elements.pop();
        if (element instanceof SystemUseEntryElement) {
            if (this.length > 255) {
                throw new RuntimeException("Invalid System Use Entry length: " + this.length);
            }
            this.lengthFixup.data(new ByteDataReference(this.length));
            this.lengthFixup.close();
        }
        super.endElement();
    }
}

