/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.rockridge.impl;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660Directory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660File;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.NamingConventions;
import java.util.Vector;

public class RockRidgeNamingConventions
extends NamingConventions {
    public static boolean HIDE_MOVED_DIRECTORIES_STORE = true;
    public static boolean FORCE_PORTABLE_FILENAME_CHARACTER_SET = true;
    public static int MAX_DIRECTORY_LENGTH = 255;
    public static int MAX_FILENAME_LENGTH = 255;

    public RockRidgeNamingConventions() {
        super("Rock Ridge");
    }

    public void apply(ISO9660Directory dir2) {
        String filename = this.normalize(dir2.getName());
        if (filename.length() > MAX_DIRECTORY_LENGTH) {
            filename = filename.substring(0, MAX_DIRECTORY_LENGTH);
        }
        this.setFilename(dir2, filename);
    }

    public void apply(ISO9660File file) {
        String filename = this.normalize(file.getFilename());
        String extension = this.normalize(file.getExtension());
        int length = filename.length() + extension.length();
        if (extension.length() == 0) {
            if (length > MAX_FILENAME_LENGTH) {
                filename = filename.substring(0, MAX_FILENAME_LENGTH);
            }
        } else if (length + 1 > MAX_FILENAME_LENGTH) {
            filename = filename.substring(0, MAX_FILENAME_LENGTH - extension.length() - 1);
        }
        this.setFilename(file, filename, extension);
    }

    public boolean checkDuplicate(Vector duplicates, String name, int version) {
        return this.checkDuplicate(duplicates, name, version, false);
    }

    public void endRenaming(ISO9660File file) {
        if (VERBOSE) {
            System.out.println(" to " + file.getName());
        }
    }

    private String normalize(String name) {
        if (FORCE_PORTABLE_FILENAME_CHARACTER_SET) {
            return name.replaceAll("[^-A-Za-z0-9._]", "_");
        }
        return name;
    }

    public void checkPathLength(String isoPath) {
    }
}

