/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.rockridge.impl;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.FilenameDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660Directory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660File;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660RootDirectory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.LayoutHelper;
import de.tu_darmstadt.informatik.rbg.hatlak.rockridge.impl.RockRidgeFilenameDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.rockridge.impl.RockRidgeNamingConventions;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.StreamHandler;
import java.util.HashMap;
import java.util.Iterator;

public class RockRidgeLayoutHelper
extends LayoutHelper {
    private ISO9660RootDirectory rripRoot;
    private HashMap directoryMapper;
    private HashMap fileMapper;

    public RockRidgeLayoutHelper(StreamHandler streamHandler, ISO9660RootDirectory isoRoot, ISO9660RootDirectory rripRoot) {
        super(streamHandler, isoRoot, new RockRidgeNamingConventions());
        this.rripRoot = rripRoot;
        this.setup(isoRoot);
    }

    private void setup(ISO9660RootDirectory isoRoot) {
        int dirCount = isoRoot.deepDirCount() + 1;
        this.directoryMapper = new HashMap(dirCount);
        int fileCount = isoRoot.deepFileCount() + 1;
        this.fileMapper = new HashMap(fileCount);
        Iterator isoFit = isoRoot.getFiles().iterator();
        Iterator rripFit = this.rripRoot.getFiles().iterator();
        while (isoFit.hasNext()) {
            ISO9660File isoFile = (ISO9660File)isoFit.next();
            ISO9660File rripFile = (ISO9660File)rripFit.next();
            this.fileMapper.put(isoFile, rripFile);
        }
        Iterator isoIt = isoRoot.unsortedIterator();
        Iterator rripIt = this.rripRoot.unsortedIterator();
        while (isoIt.hasNext()) {
            ISO9660Directory isoDir = (ISO9660Directory)isoIt.next();
            ISO9660Directory rripDir = (ISO9660Directory)rripIt.next();
            this.directoryMapper.put(isoDir.getID(), rripDir);
            isoFit = isoDir.getFiles().iterator();
            rripFit = rripDir.getFiles().iterator();
            while (isoFit.hasNext()) {
                ISO9660File isoFile = (ISO9660File)isoFit.next();
                ISO9660File rripFile = (ISO9660File)rripFit.next();
                this.fileMapper.put(isoFile.getID(), rripFile);
            }
        }
    }

    public FilenameDataReference getFilenameDataReference(ISO9660Directory dir2) throws HandlerException {
        return new RockRidgeFilenameDataReference(this.matchDirectory(dir2));
    }

    public FilenameDataReference getFilenameDataReference(ISO9660File file) throws HandlerException {
        return new RockRidgeFilenameDataReference(this.matchFile(file));
    }

    public FilenameDataReference getFilenameDataReference(String name) throws HandlerException {
        return new RockRidgeFilenameDataReference(name);
    }

    public ISO9660Directory matchDirectory(ISO9660Directory dir2) {
        if (dir2 == dir2.getRoot()) {
            return this.rripRoot;
        }
        if (dir2 == dir2.getRoot().getMovedDirectoriesStore()) {
            return this.rripRoot.getMovedDirectoriesStore();
        }
        ISO9660Directory rripDir = (ISO9660Directory)this.directoryMapper.get(dir2.getID());
        if (rripDir != null) {
            return rripDir;
        }
        throw new RuntimeException("No matching directory found for " + dir2.getISOPath());
    }

    public ISO9660File matchFile(ISO9660File file) {
        ISO9660File rripFile = (ISO9660File)this.fileMapper.get(file.getID());
        if (rripFile != null) {
            return rripFile;
        }
        throw new RuntimeException("No matching file found for " + file.getISOPath());
    }

    public byte[] pad(String string, int targetByteLength) throws HandlerException {
        return null;
    }
}

