/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.rockridge.impl;

public class POSIXFileModesFactory {
    public static int USER_READ = 256;
    public static int USER_WRITE = 128;
    public static int USER_EXEC = 64;
    public static int GROUP_READ = 32;
    public static int GROUP_WRITE = 16;
    public static int GROUP_EXEC = 8;
    public static int OTHER_READ = 4;
    public static int OTHER_WRITE = 2;
    public static int OTHER_EXEC = 1;
    public static int SETUID = 2048;
    public static int SETGID = 1024;
    public static int ENFORCE_FILE_LOCKING = 1024;
    public static int SAVE_SWAPPED_AFTER_USE = 512;
    public static int SOCKET = 49152;
    public static int SYMLINK = 40960;
    public static int REGULAR = 32768;
    public static int BLOCK_SPECIAL = 24576;
    public static int CHAR_SPECIAL = 8192;
    public static int DIRECTORY = 16384;
    public static int PIPE_FIFO = 4096;
    private int fileMode;

    public POSIXFileModesFactory() {
        this.init();
    }

    public void init() {
        this.fileMode = 0;
    }

    public void initType() {
        this.fileMode &= 0xFFF;
    }

    public void setDefault(boolean isDirectory) {
        this.init();
        this.setPermission(USER_READ);
        this.setPermission(USER_WRITE);
        this.setPermission(GROUP_READ);
        this.setPermission(OTHER_READ);
        if (isDirectory) {
            this.setPermission(DIRECTORY);
            this.setPermission(USER_EXEC);
            this.setPermission(GROUP_EXEC);
            this.setPermission(OTHER_EXEC);
        } else {
            this.setPermission(REGULAR);
        }
    }

    public void setFile() {
        this.initType();
        this.setPermission(REGULAR);
    }

    public void setSymlink() {
        this.initType();
        this.setPermission(SYMLINK);
    }

    public void setDirectory() {
        this.initType();
        this.setPermission(DIRECTORY);
    }

    public void setUID() {
        this.setPermission(SETUID);
    }

    public void setGID() {
        this.setPermission(SETGID);
    }

    public void setPermission(int permission) {
        this.fileMode |= permission;
    }

    public void clearPermission(int permission) {
        this.fileMode &= ~permission;
    }

    public int getFileMode() {
        return this.fileMode;
    }
}

