/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.joliet.impl;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660Directory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660File;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.NamingConventions;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import java.util.Vector;

public class JolietNamingConventions
extends NamingConventions {
    public static boolean FORCE_DOT_DELIMITER = true;
    public static int MAX_NAME_LENGTH = 64;

    public JolietNamingConventions() {
        super("Joliet");
    }

    public void apply(ISO9660Directory dir2) throws HandlerException {
        String filename = this.normalize(dir2.getName());
        if (filename.length() > MAX_NAME_LENGTH) {
            filename = filename.substring(0, MAX_NAME_LENGTH);
        }
        if (filename.length() == 0) {
            throw new HandlerException(String.valueOf(this.getID()) + ": Empty directory name encountered.");
        }
        this.setFilename(dir2, filename);
    }

    public void apply(ISO9660File file) throws HandlerException {
        String filename = this.normalize(file.getFilename());
        String extension = this.normalize(file.getExtension());
        file.enforceDotDelimiter(FORCE_DOT_DELIMITER);
        if (filename.length() == 0 && extension.length() == 0) {
            throw new HandlerException(String.valueOf(this.getID()) + ": Empty file name encountered.");
        }
        if (file.enforces8plus3()) {
            if (filename.length() > 8) {
                filename = filename.substring(0, 8);
            }
            if (extension.length() > 3) {
                String mapping = JolietNamingConventions.getExtensionMapping(extension);
                extension = mapping != null && mapping.length() <= 3 ? this.normalize(mapping) : extension.substring(0, 3);
            }
        }
        int versionAndSeparatorsLength = String.valueOf(file.getVersion()).length() + 2;
        if (filename.length() + extension.length() + versionAndSeparatorsLength > MAX_NAME_LENGTH) {
            if (filename.length() >= extension.length()) {
                filename = filename.substring(0, MAX_NAME_LENGTH - (extension.length() + versionAndSeparatorsLength));
            } else {
                extension = extension.substring(0, MAX_NAME_LENGTH - (filename.length() + versionAndSeparatorsLength));
            }
        }
        this.setFilename(file, filename, extension);
    }

    private String normalize(String name) {
        return name.replaceAll("[*/:;?\\\\]", "_");
    }

    public void addDuplicate(Vector duplicates, String name, int version) {
        String[] data = new String[]{name.toUpperCase(), String.valueOf(version)};
        duplicates.add(data);
    }

    public boolean checkFilenameEquality(String name1, String name2) {
        return name1.equalsIgnoreCase(name2);
    }

    public void checkPathLength(String isoPath) {
        if (isoPath.length() > 120) {
            System.out.println(String.valueOf(this.getID()) + ": Path length exceeds limit: " + isoPath);
        }
    }
}

