/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.iso9660.volumedescriptors;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.LayoutHelper;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.PartitionConfig;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.volumedescriptors.ISO9660VolumeDescriptor;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.BothWordDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.Fixup;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.StreamHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ByteArrayDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ByteDataReference;
import java.util.HashMap;

public class VolumePartitionDescriptor
extends ISO9660VolumeDescriptor {
    private String systemId = "";
    private String volumePartitionId = "";

    public VolumePartitionDescriptor(StreamHandler streamHandler, LayoutHelper helper) {
        super(streamHandler, 3, helper);
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setVolumePartitionId(String volumePartitionId) {
        this.volumePartitionId = volumePartitionId;
    }

    public void setMetadata(PartitionConfig config) {
        this.setSystemId(config.getSystemId());
        this.setVolumePartitionId(config.getVolumePartitionId());
    }

    public HashMap doVPD() throws HandlerException {
        HashMap<String, Fixup> memory = new HashMap<String, Fixup>();
        this.streamHandler.data(this.getType());
        this.streamHandler.data(this.getStandardId());
        this.streamHandler.data(this.getVDVersion());
        this.streamHandler.data(new ByteDataReference(0L));
        this.streamHandler.data(this.getSystemId());
        this.streamHandler.data(this.getVolumePartitionId());
        Fixup location = this.streamHandler.fixup(new BothWordDataReference(0L));
        memory.put("volumePartitionLocationFixup", location);
        Fixup size = this.streamHandler.fixup(new BothWordDataReference(0L));
        memory.put("volumePartitionSizeFixup", size);
        return memory;
    }

    private ByteArrayDataReference getSystemId() throws HandlerException {
        byte[] bytes = this.helper.pad(this.systemId, 32);
        return new ByteArrayDataReference(bytes);
    }

    private ByteArrayDataReference getVolumePartitionId() throws HandlerException {
        byte[] bytes = this.helper.pad(this.volumePartitionId, 32);
        return new ByteArrayDataReference(bytes);
    }
}

