/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.iso9660.volumedescriptors;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660File;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.LayoutHelper;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.StandardConfig;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660Constants;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660DateDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660DirectoryRecord;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.volumedescriptors.ISO9660VolumeDescriptor;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.BothShortDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.BothWordDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.EmptyByteArrayDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.LSBFWordDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.DataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.Fixup;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.StreamHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ByteArrayDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ByteDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.WordDataReference;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;

public abstract class StandardVolumeDescriptor
extends ISO9660VolumeDescriptor {
    String systemId = "";
    String volumeId = "";
    String volSetId = "";
    int volSetSize = 1;
    int volSeqNo = 1;
    Object publisher = null;
    Object dataPreparer = null;
    Object app = null;
    ISO9660File copyrightFile = null;
    ISO9660File abstractFile = null;
    ISO9660File bibFile = null;
    Date createDate = null;
    Date modDate = null;
    Date expireDate = null;
    Date effectiveDate = null;

    public StandardVolumeDescriptor(StreamHandler streamHandler, int type, LayoutHelper helper) {
        super(streamHandler, type, helper);
    }

    public void setMetadata(StandardConfig config) {
        this.setSystemId(config.getSystemID());
        this.setVolumeId(config.getVolumeID());
        this.setPublisher(config.getPublisher());
        this.setDataPreparer(config.getDataPreparer());
        this.setApp(config.getApp());
        this.setCreateDate(config.getCreateDate());
        this.setModDate(config.getModDate());
        this.setExpireDate(config.getExpireDate());
        this.setEffectiveDate(config.getEffectiveDate());
        this.setAbstractFile(config.getAbstractFile());
        this.setBibFile(config.getBibFile());
        this.setCopyrightFile(config.getCopyrightFile());
        this.setVolSeqNo(config.getVolumeSequenceNumber());
        this.setVolSetId(config.getVolumeSetID());
        this.setVolSetSize(config.getVolumeSetSize());
    }

    public void setAbstractFile(ISO9660File abstractFile) {
        this.abstractFile = abstractFile;
    }

    public void setApp(Object app) {
        this.app = app;
    }

    public void setBibFile(ISO9660File bibFile) {
        this.bibFile = bibFile;
    }

    public void setCopyrightFile(ISO9660File copyrightFile) {
        this.copyrightFile = copyrightFile;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setDataPreparer(Object dataPreparer) {
        this.dataPreparer = dataPreparer;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public void setExpireDate(Date expireDate) {
        this.expireDate = expireDate;
    }

    public void setModDate(Date modDate) {
        this.modDate = modDate;
    }

    public void setPublisher(Object publisher) {
        this.publisher = publisher;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setVolSeqNo(int volSeqNo) {
        this.volSeqNo = volSeqNo;
    }

    public void setVolSetId(String volSetId) {
        this.volSetId = volSetId;
    }

    public void setVolSetSize(int volSetSize) {
        this.volSetSize = volSetSize;
    }

    public void setVolumeId(String volumeId) {
        this.volumeId = volumeId;
    }

    HashMap doStandardVD() throws HandlerException {
        HashMap<String, Fixup> memory = new HashMap<String, Fixup>();
        this.streamHandler.data(this.getType());
        this.streamHandler.data(this.getStandardId());
        this.streamHandler.data(this.getVDVersion());
        Fixup vf = this.streamHandler.fixup(new ByteDataReference(0L));
        memory.put("volumeFlagsFixup", vf);
        this.streamHandler.data(this.getSystemId());
        this.streamHandler.data(this.getVolumeId());
        this.streamHandler.data(new EmptyByteArrayDataReference(8));
        Fixup vss = this.streamHandler.fixup(new BothWordDataReference(0L));
        memory.put("volumeSpaceSizeFixup", vss);
        Fixup es = this.streamHandler.fixup(new EmptyByteArrayDataReference(32));
        memory.put("escapeSequencesFixup", es);
        this.streamHandler.data(this.getVolumeSetSize());
        this.streamHandler.data(this.getVolumeSeqNo());
        this.streamHandler.data(this.getLogicalBlockSize());
        Fixup pts = this.streamHandler.fixup(new BothWordDataReference(0L));
        memory.put("ptSizeFixup", pts);
        Fixup tlpt = this.streamHandler.fixup(new LSBFWordDataReference(0L));
        memory.put("typeLPTLocationFixup", tlpt);
        this.streamHandler.data(new LSBFWordDataReference(0L));
        Fixup tmpt = this.streamHandler.fixup(new WordDataReference(0L));
        memory.put("typeMPTLocationFixup", tmpt);
        this.streamHandler.data(new WordDataReference(0L));
        this.doRootDR(memory);
        this.streamHandler.data(this.getVolumeSetId());
        this.streamHandler.data(this.getIdOrFile(this.publisher));
        this.streamHandler.data(this.getIdOrFile(this.dataPreparer));
        this.streamHandler.data(this.getIdOrFile(this.app));
        this.streamHandler.data(this.getFile(this.copyrightFile));
        this.streamHandler.data(this.getFile(this.abstractFile));
        this.streamHandler.data(this.getFile(this.bibFile));
        this.streamHandler.data(new ISO9660DateDataReference(this.createDate));
        this.streamHandler.data(new ISO9660DateDataReference(this.modDate));
        this.streamHandler.data(new ISO9660DateDataReference(this.expireDate));
        this.streamHandler.data(new ISO9660DateDataReference(this.effectiveDate));
        this.streamHandler.data(this.getFileStructureVersion());
        this.streamHandler.data(new ByteDataReference(0L));
        return memory;
    }

    private void doRootDR(HashMap memory) throws HandlerException {
        ISO9660DirectoryRecord rddr = new ISO9660DirectoryRecord(this.streamHandler, ISO9660Constants.FI_ROOT, this.helper.getRoot(), this.helper);
        HashMap drMemory = rddr.doDR();
        Fixup drLengthFixup = (Fixup)drMemory.get("drLengthFixup");
        int drLength = (Integer)drMemory.get("drLength");
        drLengthFixup.data(new ByteDataReference(drLength));
        drLengthFixup.close();
        Fixup rootDirLocation = (Fixup)drMemory.get("drLocationFixup");
        memory.put("rootDirLocationFixup", rootDirLocation);
        Fixup rootDirLength = (Fixup)drMemory.get("drDataLengthFixup");
        memory.put("rootDirLengthFixup", rootDirLength);
    }

    private ByteArrayDataReference getSystemId() throws HandlerException {
        byte[] bytes = this.helper.pad(this.systemId, 32);
        return new ByteArrayDataReference(bytes);
    }

    private ByteArrayDataReference getVolumeId() throws HandlerException {
        byte[] bytes = this.helper.pad(this.volumeId, 32);
        return new ByteArrayDataReference(bytes);
    }

    private BothShortDataReference getVolumeSetSize() {
        return new BothShortDataReference(this.volSetSize);
    }

    private BothShortDataReference getVolumeSeqNo() {
        return new BothShortDataReference(this.volSeqNo);
    }

    private BothShortDataReference getLogicalBlockSize() {
        return new BothShortDataReference(2048L);
    }

    private ByteDataReference getFileStructureVersion() {
        return new ByteDataReference(1L);
    }

    private DataReference getVolumeSetId() throws HandlerException {
        byte[] bytes = this.helper.pad(this.volSetId, 128);
        return new ByteArrayDataReference(bytes);
    }

    DataReference getIdOrFile(Object object) throws HandlerException {
        byte[] bytes;
        if (object == null) {
            bytes = this.helper.pad("", 128);
        } else if (object instanceof String) {
            String id = (String)object;
            bytes = this.helper.pad(id, 128);
        } else if (object instanceof ISO9660File) {
            ByteBuffer buf = ByteBuffer.allocate(128);
            buf.put((byte)95);
            ISO9660File file = (ISO9660File)object;
            file.enforce8plus3(true);
            String id = this.helper.getFilenameDataReference(file).getName();
            buf.put(this.helper.pad(id, 127));
            bytes = buf.array();
        } else {
            throw new HandlerException("String or ISO9660File expected in getIdOrFile, got " + object.getClass());
        }
        return new ByteArrayDataReference(bytes);
    }

    DataReference getFile(ISO9660File file) throws HandlerException {
        byte[] bytes;
        if (file == null) {
            String id = "";
            bytes = this.helper.pad(id, 37);
        } else {
            file.enforce8plus3(true);
            String id = this.helper.getFilenameDataReference(file).getName();
            bytes = this.helper.pad(id, 37);
        }
        return new ByteArrayDataReference(bytes);
    }
}

