/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.iso9660.volumedescriptors;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.BootConfig;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.LayoutHelper;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.volumedescriptors.ISO9660VolumeDescriptor;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.StreamHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ByteArrayDataReference;

public class BootRecord
extends ISO9660VolumeDescriptor {
    private String bootSystemId = "";
    private String bootId = "";

    public BootRecord(StreamHandler streamHandler, LayoutHelper helper) {
        super(streamHandler, 0, helper);
    }

    public void setBootId(String bootId) {
        this.bootId = bootId;
    }

    public void setBootSystemId(String bootSystemId) {
        this.bootSystemId = bootSystemId;
    }

    public void setMetadata(BootConfig config) {
        this.setBootSystemId(config.getBootSystemId());
        this.setBootId(config.getBootId());
    }

    public void doBR() throws HandlerException {
        this.streamHandler.data(this.getType());
        this.streamHandler.data(this.getStandardId());
        this.streamHandler.data(this.getVDVersion());
        this.streamHandler.data(this.getBootSystemId());
        this.streamHandler.data(this.getBootId());
    }

    private ByteArrayDataReference getBootSystemId() throws HandlerException {
        byte[] bytes = this.helper.pad(this.bootSystemId, 32);
        return new ByteArrayDataReference(bytes);
    }

    private ByteArrayDataReference getBootId() throws HandlerException {
        byte[] bytes = this.helper.pad(this.bootId, 32);
        return new ByteArrayDataReference(bytes);
    }
}

