/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660Element;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.LogicalSectorElement;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.EmptyByteArrayDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.ContentHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.DataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.Element;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.Fixup;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.StructureHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ChainingStreamHandler;
import java.util.Stack;

public class LogicalSectorPaddingHandler
extends ChainingStreamHandler {
    private long bytesWritten = 0L;
    private Stack elements = new Stack();
    private boolean padEnd;

    public LogicalSectorPaddingHandler(StructureHandler chainingStructureHandler, ContentHandler chainingContentHandler) {
        super(chainingStructureHandler, chainingContentHandler);
    }

    public void setPadEnd(boolean padEnd) {
        this.padEnd = padEnd;
    }

    public void startElement(Element element) throws HandlerException {
        if (element instanceof LogicalSectorElement || this.isSAElement(element)) {
            this.bytesWritten = 0L;
        }
        this.elements.push(element);
        super.startElement(element);
    }

    private boolean isSAElement(Object element) {
        String id;
        return element instanceof ISO9660Element && (id = (String)((ISO9660Element)element).getId()).equals("SA");
    }

    public void data(DataReference reference) throws HandlerException {
        this.bytesWritten += reference.getLength();
        super.data(reference);
    }

    public Fixup fixup(DataReference reference) throws HandlerException {
        this.bytesWritten += reference.getLength();
        return super.fixup(reference);
    }

    public void endElement() throws HandlerException {
        Object element = this.elements.pop();
        if (element instanceof LogicalSectorElement) {
            int pad = (int)(2048L - this.bytesWritten % 2048L);
            super.data(new EmptyByteArrayDataReference(pad));
        } else if (this.isSAElement(element)) {
            int pad = (int)(32768L - this.bytesWritten % 16L * 2048L);
            super.data(new EmptyByteArrayDataReference(pad));
        }
        super.endElement();
    }

    public void endDocument() throws HandlerException {
        if (this.padEnd) {
            int pad = (int)(307200L - this.bytesWritten % 16L * 2048L);
            super.data(new EmptyByteArrayDataReference(pad));
        }
    }
}

