/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.FilenameDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660Directory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660File;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660RootDirectory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.LayoutHelper;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.NamingConventions;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.StandardConfig;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660Factory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660ShortDateDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.LogicalSectorElement;
import de.tu_darmstadt.informatik.rbg.hatlak.rockridge.impl.POSIXFileMode;
import de.tu_darmstadt.informatik.rbg.hatlak.rockridge.impl.RRIPFactory;
import de.tu_darmstadt.informatik.rbg.hatlak.rockridge.impl.RockRidgeLayoutHelper;
import de.tu_darmstadt.informatik.rbg.hatlak.rockridge.impl.RockRidgeNamingConventions;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.BothWordDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.Fixup;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.StreamHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class ISO9660RockRidgeFactory
extends ISO9660Factory {
    private RRIPFactory rripFactory;
    private LinkedList unfinishedNMEntries;
    private RockRidgeLayoutHelper helper;
    private ISO9660RootDirectory rripRoot;
    private HashMap originalParentMapper;
    private HashMap parentLocationFixups;
    private HashMap parentLocations;
    private HashMap childLocationFixups;
    private HashMap childLocations;

    public ISO9660RockRidgeFactory(StreamHandler streamHandler, StandardConfig config, LayoutHelper helper, ISO9660RootDirectory root, ISO9660RootDirectory isoRoot, HashMap volumeFixups) {
        super(streamHandler, config, helper, isoRoot, volumeFixups);
        this.rripFactory = new RRIPFactory(streamHandler);
        this.unfinishedNMEntries = new LinkedList();
        this.rripRoot = (ISO9660RootDirectory)root.clone();
        this.helper = new RockRidgeLayoutHelper(streamHandler, isoRoot, this.rripRoot);
        this.originalParentMapper = new HashMap();
    }

    public void applyNamingConventions() throws HandlerException {
        super.applyNamingConventions();
        NamingConventions namingConventions = this.helper.getNamingConventions();
        namingConventions.processDirectory(this.rripRoot);
        Iterator sit = this.rripRoot.unsortedIterator();
        while (sit.hasNext()) {
            ISO9660Directory dir2 = (ISO9660Directory)sit.next();
            namingConventions.processDirectory(dir2);
        }
    }

    public void relocateDirectories() {
        if (this.rripRoot.deepLevelCount() >= 8) {
            this.parentLocationFixups = new HashMap();
            this.parentLocations = new HashMap();
            this.childLocationFixups = new HashMap();
            this.childLocations = new HashMap();
            this.rripRoot.setMovedDirectoryStore();
            if (RockRidgeNamingConventions.HIDE_MOVED_DIRECTORIES_STORE && !this.rripRoot.getMovedDirectoriesStore().getName().startsWith(".")) {
                this.rripRoot.getMovedDirectoriesStore().setName("." + ISO9660RootDirectory.MOVED_DIRECTORIES_STORE_NAME);
            }
        }
        super.relocateDirectories();
    }

    ISO9660Directory relocate(ISO9660Directory dir2) {
        ISO9660Directory originalParent = super.relocate(dir2);
        this.helper.matchDirectory(dir2).relocate();
        if (dir2.getRoot() == this.root) {
            this.originalParentMapper.put(originalParent, dir2);
        }
        return originalParent;
    }

    public void doDRA() throws HandlerException {
        super.doDRA();
        if (this.originalParentMapper.size() > 0) {
            this.doRelocationFixups();
        }
        this.doCA();
    }

    void doDir(ISO9660Directory dir2, HashMap parentMapper) throws HandlerException {
        Integer location = new Integer(this.helper.getCurrentLocation());
        if (this.originalParentMapper.containsKey(dir2)) {
            this.parentLocations.put(this.originalParentMapper.get(dir2), location);
        } else if (dir2.isMoved()) {
            this.childLocations.put(dir2, location);
        }
        super.doDir(dir2, parentMapper);
    }

    HashMap doFakeDR(ISO9660Directory dir2) throws HandlerException {
        long position = this.streamHandler.mark();
        HashMap memory = super.doFakeDR(dir2);
        if (RRIPFactory.MKISOFS_COMPATIBILITY) {
            int flags = 25;
            this.rripFactory.doRREntry(flags);
        }
        POSIXFileMode fileMode = new POSIXFileMode();
        fileMode.setDefault(true);
        int fileModes = fileMode.getFileMode();
        int fileLinks = 2 + dir2.getDirectories().size();
        this.rripFactory.doPXEntry(fileModes, fileLinks, 0, 0, 1L);
        this.childLocationFixups.put(dir2, this.rripFactory.doCLEntry());
        int length = this.helper.getDifferenceTo(position);
        length = this.doNM(this.helper.getFilenameDataReference(dir2), length);
        return this.finalizeDR(memory, length);
    }

    HashMap doDR(ISO9660File file) throws HandlerException {
        long position = this.streamHandler.mark();
        HashMap memory = super.doDR(file);
        if (RRIPFactory.MKISOFS_COMPATIBILITY) {
            int flags = 137;
            this.rripFactory.doRREntry(flags);
        }
        POSIXFileMode fileMode = new POSIXFileMode();
        fileMode.setDefault(false);
        int fileModes = fileMode.getFileMode();
        this.rripFactory.doPXEntry(fileModes, 1, 0, 0, 1L);
        ISO9660ShortDateDataReference date = new ISO9660ShortDateDataReference(file.lastModified());
        this.rripFactory.doTFEntry(2, date);
        int length = this.helper.getDifferenceTo(position);
        length = this.doNM(this.helper.getFilenameDataReference(file), length);
        return this.finalizeDR(memory, length);
    }

    HashMap doDR(ISO9660Directory dir2) throws HandlerException {
        long position = this.streamHandler.mark();
        HashMap memory = super.doDR(dir2);
        if (RRIPFactory.MKISOFS_COMPATIBILITY) {
            int flags = 137;
            if (dir2.isMoved()) {
                flags |= 0x40;
            }
            this.rripFactory.doRREntry(flags);
        }
        if (dir2.isMoved()) {
            this.rripFactory.doREEntry();
        }
        POSIXFileMode fileMode = new POSIXFileMode();
        fileMode.setDefault(true);
        int fileModes = fileMode.getFileMode();
        int fileLinks = 2 + dir2.getDirectories().size();
        this.rripFactory.doPXEntry(fileModes, fileLinks, 0, 0, 1L);
        ISO9660ShortDateDataReference date = new ISO9660ShortDateDataReference(dir2.lastModified());
        this.rripFactory.doTFEntry(2, date);
        int length = this.helper.getDifferenceTo(position);
        length = this.doNM(this.helper.getFilenameDataReference(dir2), length);
        return this.finalizeDR(memory, length);
    }

    HashMap doDotDR(ISO9660Directory dir2) throws HandlerException {
        long position = this.streamHandler.mark();
        HashMap memory = super.doDotDR(dir2);
        if (dir2 == this.root) {
            this.rripFactory.doSPEntry(0);
        }
        if (RRIPFactory.MKISOFS_COMPATIBILITY) {
            int flags = 129;
            this.rripFactory.doRREntry(flags);
        }
        POSIXFileMode fileMode = new POSIXFileMode();
        fileMode.setDefault(true);
        int fileModes = fileMode.getFileMode();
        int fileLinks = 2 + dir2.getDirectories().size();
        this.rripFactory.doPXEntry(fileModes, fileLinks, 0, 0, 1L);
        ISO9660ShortDateDataReference date = new ISO9660ShortDateDataReference(dir2.lastModified());
        this.rripFactory.doTFEntry(2, date);
        if (dir2 == this.root) {
            HashMap ceMemory = this.rripFactory.doCEEntry();
            this.volumeFixups.put("rripERLocationFixup", ceMemory.get("ceLocationFixup"));
            this.volumeFixups.put("rripERLengthFixup", ceMemory.get("ceLengthFixup"));
            Fixup rripEROffsetFixup = (Fixup)ceMemory.get("ceOffsetFixup");
            rripEROffsetFixup.data(new BothWordDataReference(0L));
            rripEROffsetFixup.close();
        }
        return this.finalizeDR(memory, this.helper.getDifferenceTo(position));
    }

    HashMap doDotDotDR(ISO9660Directory dir2) throws HandlerException {
        long position = this.streamHandler.mark();
        HashMap memory = super.doDotDotDR(dir2);
        ISO9660Directory parentDir = dir2.getParentDirectory();
        if (RRIPFactory.MKISOFS_COMPATIBILITY) {
            int flags = 129;
            if (dir2.isMoved()) {
                flags |= 0x20;
            }
            this.rripFactory.doRREntry(flags);
        }
        if (dir2.isMoved()) {
            this.parentLocationFixups.put(dir2, this.rripFactory.doPLEntry());
        }
        POSIXFileMode fileMode = new POSIXFileMode();
        fileMode.setDefault(true);
        int fileModes = fileMode.getFileMode();
        int fileLinks = 2 + parentDir.getDirectories().size();
        this.rripFactory.doPXEntry(fileModes, fileLinks, 0, 0, 1L);
        ISO9660ShortDateDataReference date = new ISO9660ShortDateDataReference(parentDir.lastModified());
        this.rripFactory.doTFEntry(2, date);
        return this.finalizeDR(memory, this.helper.getDifferenceTo(position));
    }

    private int doNM(FilenameDataReference filename, int drLength) throws HandlerException {
        int lengthToAdd = 5;
        int rest = 254 - drLength;
        if ((long)rest >= filename.getLength() + 5L) {
            this.rripFactory.doNMEntry(0, filename);
            lengthToAdd = (int)((long)lengthToAdd + filename.getLength());
        } else {
            int prefixLength = rest - 33;
            String name = filename.getName();
            FilenameDataReference filenameRest = this.helper.getFilenameDataReference(name.substring(0, prefixLength));
            this.rripFactory.doNMEntry(1, filenameRest);
            HashMap ceMemory = this.rripFactory.doCEEntry();
            UnfinishedNMEntry unfinishedNMEntry = new UnfinishedNMEntry();
            unfinishedNMEntry.location = (Fixup)ceMemory.get("ceLocationFixup");
            unfinishedNMEntry.offset = (Fixup)ceMemory.get("ceOffsetFixup");
            unfinishedNMEntry.length = (Fixup)ceMemory.get("ceLengthFixup");
            unfinishedNMEntry.filenameRest = name.substring(prefixLength);
            this.unfinishedNMEntries.add(unfinishedNMEntry);
            lengthToAdd += prefixLength + 28;
        }
        return drLength + lengthToAdd;
    }

    private HashMap finalizeDR(HashMap memory, int length) throws HandlerException {
        if (length <= 250) {
            length = this.doST(length);
        }
        memory.put("drLength", new Integer(length));
        return memory;
    }

    private int doST(int length) throws HandlerException {
        if (!RRIPFactory.MKISOFS_COMPATIBILITY) {
            this.rripFactory.doSTEntry();
            length += 4;
        }
        return length;
    }

    private void doRelocationFixups() throws HandlerException {
        this.doRelocationFixups(this.parentLocationFixups, this.parentLocations);
        this.doRelocationFixups(this.childLocationFixups, this.childLocations);
    }

    private void doRelocationFixups(HashMap fixups, HashMap locations) throws HandlerException {
        Iterator it = fixups.keySet().iterator();
        while (it.hasNext()) {
            ISO9660Directory dir2 = (ISO9660Directory)it.next();
            Fixup locationFixup = (Fixup)fixups.get(dir2);
            int location = (Integer)locations.get(dir2);
            locationFixup.data(new BothWordDataReference(location));
            locationFixup.close();
        }
    }

    private void doCA() throws HandlerException {
        long position = this.streamHandler.mark();
        this.streamHandler.startElement(new LogicalSectorElement("CA"));
        int location = this.helper.getCurrentLocation();
        Fixup rripERLocationFixup = (Fixup)this.volumeFixups.get("rripERLocationFixup");
        rripERLocationFixup.data(new BothWordDataReference(location));
        rripERLocationFixup.close();
        this.rripFactory.doEREntry();
        int erLength = this.doST(this.helper.getDifferenceTo(position));
        Fixup rripERLengthFixup = (Fixup)this.volumeFixups.get("rripERLengthFixup");
        rripERLengthFixup.data(new BothWordDataReference(erLength));
        rripERLengthFixup.close();
        int offset = erLength;
        Iterator it = this.unfinishedNMEntries.iterator();
        while (it.hasNext()) {
            UnfinishedNMEntry unfinishedNMEntry = (UnfinishedNMEntry)it.next();
            String name = unfinishedNMEntry.filenameRest;
            this.rripFactory.doNMEntry(0, this.helper.getFilenameDataReference(name));
            unfinishedNMEntry.location.data(new BothWordDataReference(location));
            unfinishedNMEntry.location.close();
            unfinishedNMEntry.offset.data(new BothWordDataReference(offset));
            unfinishedNMEntry.offset.close();
            int ceLength = this.doST(name.length() + 5);
            unfinishedNMEntry.length.data(new BothWordDataReference(ceLength));
            unfinishedNMEntry.length.close();
            offset += ceLength;
        }
        this.streamHandler.endElement();
    }

    class UnfinishedNMEntry {
        Fixup location;
        Fixup offset;
        Fixup length;
        String filenameRest;

        UnfinishedNMEntry() {
        }
    }
}

