/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660Constants;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.LSBFShortDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.LSBFWordDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.DataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.Fixup;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.StreamHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ByteDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ShortDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.WordDataReference;

public class ISO9660PathTableRecord {
    private StreamHandler streamHandler;
    private Object type;
    private DataReference filename;
    private int parent;
    private int extAttrRecordLength;

    public ISO9660PathTableRecord(StreamHandler streamHandler, Object type, Object object, int parent) throws HandlerException {
        this.streamHandler = streamHandler;
        this.extAttrRecordLength = 0;
        if (object == ISO9660Constants.FI_ROOT || object == ISO9660Constants.FI_DOT) {
            this.filename = new ByteDataReference(0L);
        } else if (object == ISO9660Constants.FI_DOTDOT) {
            this.filename = new ByteDataReference(1L);
        } else {
            throw new HandlerException("Unknown special directory type, must be one of ROOT, DOT, DOTDOT: " + type);
        }
        this.setType(type);
        this.setParent(parent);
    }

    public ISO9660PathTableRecord(StreamHandler streamHandler, Object type, DataReference ref, int parent) throws HandlerException {
        this.streamHandler = streamHandler;
        this.extAttrRecordLength = 0;
        this.filename = ref;
        this.setType(type);
        this.setParent(parent);
    }

    private void setType(Object type) throws HandlerException {
        if (!type.equals(ISO9660Constants.TYPE_L_PT) && !type.equals(ISO9660Constants.TYPE_M_PT)) {
            throw new HandlerException("Unknown Path Table type: " + type);
        }
        this.type = type;
    }

    private void setParent(int parent) throws HandlerException {
        if (parent < 0) {
            throw new HandlerException("Invalid parent directory number.");
        }
        this.parent = parent;
    }

    public int hasExtAddrRecordLength() {
        return this.extAttrRecordLength;
    }

    public void setExtAttrRecordLength(int extAttrRecordLength) {
        this.extAttrRecordLength = extAttrRecordLength;
    }

    public Fixup doPTR() throws HandlerException {
        this.streamHandler.data(new ByteDataReference(this.filename.getLength()));
        this.streamHandler.data(new ByteDataReference(this.extAttrRecordLength));
        DataReference location_dr = null;
        if (this.type.equals(ISO9660Constants.TYPE_L_PT)) {
            location_dr = new LSBFWordDataReference(0L);
        } else if (this.type.equals(ISO9660Constants.TYPE_M_PT)) {
            location_dr = new WordDataReference(0L);
        }
        Fixup locationFixup = this.streamHandler.fixup(location_dr);
        DataReference parent_dn = null;
        if (this.type.equals(ISO9660Constants.TYPE_L_PT)) {
            parent_dn = new LSBFShortDataReference(this.parent);
        } else if (this.type.equals(ISO9660Constants.TYPE_M_PT)) {
            parent_dn = new ShortDataReference(this.parent);
        }
        this.streamHandler.data(parent_dn);
        this.streamHandler.data(this.filename);
        if (this.filename.getLength() % 2L == 1L) {
            this.streamHandler.data(new ByteDataReference(0L));
        }
        return locationFixup;
    }
}

