/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660Directory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660File;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.NamingConventions;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import java.util.Vector;

public class ISO9660NamingConventions
extends NamingConventions {
    public static int INTERCHANGE_LEVEL = 1;
    public static boolean FORCE_ISO9660_CHARSET = true;
    public static boolean FORCE_DOT_DELIMITER = true;
    private boolean enforce8plus3;
    private int MAX_DIRECTORY_LENGTH;
    private int MAX_FILENAME_LENGTH;
    private int MAX_EXTENSION_LENGTH;

    public ISO9660NamingConventions() {
        super("ISO 9660");
    }

    public void apply(ISO9660Directory dir2) throws HandlerException {
        this.init();
        String filename = this.normalize(dir2.getName());
        if (filename.length() > this.MAX_DIRECTORY_LENGTH) {
            filename = filename.substring(0, this.MAX_DIRECTORY_LENGTH);
        }
        if (filename.length() == 0) {
            throw new HandlerException(String.valueOf(this.getID()) + ": Empty directory name encountered.");
        }
        this.setFilename(dir2, filename);
    }

    public void apply(ISO9660File file) throws HandlerException {
        this.enforce8plus3(file.enforces8plus3());
        this.init();
        String filename = this.normalize(file.getFilename());
        String extension = this.normalize(file.getExtension());
        file.enforceDotDelimiter(FORCE_DOT_DELIMITER);
        if (filename.length() == 0 && extension.length() == 0) {
            throw new HandlerException(String.valueOf(this.getID()) + ": Empty file name encountered.");
        }
        if (this.enforces8plus3()) {
            if (filename.length() > this.MAX_FILENAME_LENGTH) {
                filename = filename.substring(0, this.MAX_FILENAME_LENGTH);
            }
            if (extension.length() > this.MAX_EXTENSION_LENGTH) {
                String mapping = ISO9660NamingConventions.getExtensionMapping(extension);
                extension = mapping != null && mapping.length() <= this.MAX_EXTENSION_LENGTH ? this.normalize(mapping) : extension.substring(0, this.MAX_EXTENSION_LENGTH);
            }
        } else if (filename.length() + extension.length() > 30) {
            if (filename.length() >= extension.length()) {
                filename = filename.substring(0, 30 - extension.length());
            } else {
                String mapping = ISO9660NamingConventions.getExtensionMapping(extension);
                extension = mapping != null && mapping.length() <= this.MAX_EXTENSION_LENGTH ? this.normalize(mapping) : extension.substring(0, 30 - filename.length());
            }
        }
        this.setFilename(file, filename, extension);
    }

    public void init() {
        if (INTERCHANGE_LEVEL == 1) {
            this.enforce8plus3(true);
        }
        if (this.enforces8plus3()) {
            this.MAX_DIRECTORY_LENGTH = 8;
            this.MAX_FILENAME_LENGTH = 8;
            this.MAX_EXTENSION_LENGTH = 3;
        } else {
            this.MAX_DIRECTORY_LENGTH = 31;
            this.MAX_FILENAME_LENGTH = 0;
            this.MAX_EXTENSION_LENGTH = 0;
        }
    }

    void enforce8plus3(boolean flag) {
        this.enforce8plus3 = flag;
    }

    boolean enforces8plus3() {
        return this.enforce8plus3;
    }

    private String normalize(String name) {
        if (FORCE_ISO9660_CHARSET) {
            name = name.toUpperCase();
            return name.replaceAll("[^A-Z0-9_]", "_");
        }
        return name.replaceAll("[*/:;?\\\\]", "_");
    }

    public void addDuplicate(Vector duplicates, String name, int version) {
        String[] data = new String[]{name.toUpperCase(), String.valueOf(version)};
        duplicates.add(data);
    }

    public boolean checkFilenameEquality(String name1, String name2) {
        return name1.equalsIgnoreCase(name2);
    }

    public void checkPathLength(String isoPath) {
        if (isoPath.length() > 255) {
            System.out.println(String.valueOf(this.getID()) + ": Path length exceeds limit: " + isoPath);
        }
    }
}

