/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.FilenameDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660Directory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660File;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660RootDirectory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.LayoutHelper;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.NamingConventions;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.StandardConfig;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660Constants;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660DirectoryRecord;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660PathTableRecord;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.LogicalSectorElement;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.BothWordDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.EmptyByteArrayDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.LSBFWordDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.Fixup;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.StreamHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ByteDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.WordDataReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class ISO9660Factory {
    StreamHandler streamHandler;
    StandardConfig config;
    LayoutHelper helper;
    ISO9660RootDirectory root;
    HashMap volumeFixups;
    HashMap typeLPTFixups;
    HashMap typeMPTFixups;
    HashMap dirFixups;
    HashMap fileFixups;
    HashMap locationFixups;
    Vector emptyFileFixups;

    public ISO9660Factory(StreamHandler streamHandler, StandardConfig config, LayoutHelper helper, ISO9660RootDirectory root, HashMap volumeFixups) {
        this.streamHandler = streamHandler;
        this.config = config;
        this.helper = helper;
        this.root = root;
        this.volumeFixups = volumeFixups;
        int dirCount = root.deepDirCount() + 1;
        this.typeLPTFixups = new HashMap(dirCount);
        this.typeMPTFixups = new HashMap(dirCount);
        this.dirFixups = new HashMap(dirCount);
        int fileCount = root.deepFileCount() + 1;
        this.fileFixups = new HashMap(fileCount);
        this.locationFixups = new HashMap(fileCount);
        this.emptyFileFixups = new Vector();
    }

    public void applyNamingConventions() throws HandlerException {
        NamingConventions namingConventions = this.helper.getNamingConventions();
        namingConventions.processDirectory(this.root);
        Iterator dit = this.root.unsortedIterator();
        while (dit.hasNext()) {
            ISO9660Directory dir2 = (ISO9660Directory)dit.next();
            namingConventions.processDirectory(dir2);
        }
    }

    public void relocateDirectories() {
        if (this.root.deepLevelCount() >= 8) {
            this.root.setMovedDirectoryStore();
            this.relocateDirectories(this.root);
        }
    }

    private void relocateDirectories(ISO9660Directory dir2) {
        Iterator it = dir2.sortedIterator();
        while (it.hasNext()) {
            ISO9660Directory subdir = (ISO9660Directory)it.next();
            if (subdir.getLevel() != 9) continue;
            this.relocate(subdir);
        }
    }

    ISO9660Directory relocate(ISO9660Directory dir2) {
        return dir2.relocate();
    }

    public void doPT(Object type) throws HandlerException {
        Fixup ptLocationFixup;
        HashMap ptFixups;
        this.streamHandler.startElement(new LogicalSectorElement("PT"));
        long position = this.streamHandler.mark();
        int location = this.helper.getCurrentLocation();
        if (type == ISO9660Constants.TYPE_L_PT) {
            ptFixups = this.typeLPTFixups;
            ptLocationFixup = (Fixup)this.volumeFixups.get("typeLPTLocationFixup");
            ptLocationFixup.data(new LSBFWordDataReference(location));
            ptLocationFixup.close();
            this.volumeFixups.remove("typeLPTLocationFixup");
        } else if (type == ISO9660Constants.TYPE_M_PT) {
            ptFixups = this.typeMPTFixups;
            ptLocationFixup = (Fixup)this.volumeFixups.get("typeMPTLocationFixup");
            ptLocationFixup.data(new WordDataReference(location));
            ptLocationFixup.close();
            this.volumeFixups.remove("typeMPTLocationFixup");
        } else {
            throw new HandlerException("Unknown Path Table Type: " + type);
        }
        HashMap<ISO9660Directory, Integer> parentMapper = new HashMap<ISO9660Directory, Integer>();
        ISO9660Directory dir2 = this.root;
        int dirNumber = 1;
        ISO9660PathTableRecord rptr = new ISO9660PathTableRecord(this.streamHandler, type, ISO9660Constants.FI_ROOT, 1);
        ptFixups.put(this.root, rptr.doPTR());
        parentMapper.put(dir2, new Integer(dirNumber));
        Iterator it = this.root.sortedIterator();
        while (it.hasNext()) {
            ++dirNumber;
            dir2 = (ISO9660Directory)it.next();
            int parent = (Integer)parentMapper.get(dir2.getParentDirectory());
            FilenameDataReference ref = this.helper.getFilenameDataReference(dir2);
            ISO9660PathTableRecord ptr = new ISO9660PathTableRecord(this.streamHandler, type, ref, parent);
            ptFixups.put(dir2, ptr.doPTR());
            parentMapper.put(dir2, new Integer(dirNumber));
        }
        if (this.volumeFixups.containsKey("ptSizeFixup")) {
            int ptSize = this.helper.getDifferenceTo(position);
            Fixup ptSizeFixup = (Fixup)this.volumeFixups.get("ptSizeFixup");
            ptSizeFixup.data(new BothWordDataReference(ptSize));
            ptSizeFixup.close();
            this.volumeFixups.remove("ptSizeFixup");
        }
        this.streamHandler.endElement();
    }

    public void doDRA() throws HandlerException {
        HashMap parentMapper = new HashMap();
        this.doDir(this.root, parentMapper);
        this.doRootDirFixups(parentMapper);
        ISO9660Directory dir2 = this.root;
        Iterator it = this.root.sortedIterator();
        while (it.hasNext()) {
            dir2 = (ISO9660Directory)it.next();
            this.doDir(dir2, parentMapper);
        }
    }

    private void doRootDirFixups(HashMap parentMapper) throws HandlerException {
        ParentInfo parentInfo = (ParentInfo)parentMapper.get(this.root);
        Fixup rootDirLocationFixup = (Fixup)this.volumeFixups.get("rootDirLocationFixup");
        rootDirLocationFixup.data(new BothWordDataReference(parentInfo.location));
        rootDirLocationFixup.close();
        this.volumeFixups.remove("rootDirLocationFixup");
        Fixup rootDirLengthFixup = (Fixup)this.volumeFixups.get("rootDirLengthFixup");
        rootDirLengthFixup.data(new BothWordDataReference(parentInfo.length));
        rootDirLengthFixup.close();
        this.volumeFixups.remove("rootDirLengthFixup");
    }

    void doDir(ISO9660Directory dir2, HashMap parentMapper) throws HandlerException {
        this.streamHandler.startElement(new LogicalSectorElement("DIR"));
        long position = this.streamHandler.mark();
        int location = this.helper.getCurrentLocation();
        HashMap dotMemory = this.doDRLengthFixup(this.doDotDR(dir2));
        Fixup dotLocationFixup = (Fixup)dotMemory.get("drLocationFixup");
        Fixup dotLengthFixup = (Fixup)dotMemory.get("drDataLengthFixup");
        HashMap dotdotMemory = this.doDRLengthFixup(this.doDotDotDR(dir2));
        Fixup dotdotLocationFixup = (Fixup)dotdotMemory.get("drLocationFixup");
        Fixup dotdotLengthFixup = (Fixup)dotdotMemory.get("drDataLengthFixup");
        Vector contents = new Vector();
        contents.addAll(dir2.getDirectories());
        contents.addAll(dir2.getFiles());
        Collections.sort(contents);
        Iterator it = contents.iterator();
        while (it.hasNext()) {
            this.doBlockCheck(position);
            Object object = it.next();
            if (object instanceof ISO9660Directory) {
                ISO9660Directory subdir = (ISO9660Directory)object;
                if (subdir.isMoved() && dir2 != this.root.getMovedDirectoriesStore()) {
                    this.doDRLengthFixup(this.doFakeDR(subdir));
                    continue;
                }
                this.doDRLengthFixup(this.doDR(subdir));
                continue;
            }
            if (object instanceof ISO9660File) {
                ISO9660File file = (ISO9660File)object;
                this.doDRLengthFixup(this.doDR(file));
                continue;
            }
            throw new HandlerException("Neither file nor directory: " + object);
        }
        this.streamHandler.endElement();
        int length = this.helper.getCurrentLocation() - location;
        ParentInfo dotInfo = new ParentInfo();
        dotInfo.location = location;
        dotInfo.length = length *= 2048;
        parentMapper.put(dir2, dotInfo);
        dotLocationFixup.data(new BothWordDataReference(location));
        dotLocationFixup.close();
        dotLengthFixup.data(new BothWordDataReference(length));
        dotLengthFixup.close();
        ParentInfo dotdotInfo = (ParentInfo)parentMapper.get(dir2.getParentDirectory());
        dotdotLocationFixup.data(new BothWordDataReference(dotdotInfo.location));
        dotdotLocationFixup.close();
        dotdotLengthFixup.data(new BothWordDataReference(dotdotInfo.length));
        dotdotLengthFixup.close();
        DirFixupPair fixups = (DirFixupPair)this.dirFixups.get(dir2);
        if (fixups != null) {
            fixups.location.data(new BothWordDataReference(location));
            fixups.location.close();
            fixups.length.data(new BothWordDataReference(length));
            fixups.length.close();
        }
        Fixup typeLPTDirLocation = (Fixup)this.typeLPTFixups.get(dir2);
        typeLPTDirLocation.data(new LSBFWordDataReference(location));
        typeLPTDirLocation.close();
        Fixup typeMPTDirLocation = (Fixup)this.typeMPTFixups.get(dir2);
        typeMPTDirLocation.data(new WordDataReference(location));
        typeMPTDirLocation.close();
    }

    private HashMap doDRLengthFixup(HashMap memory) throws HandlerException {
        int drLength = (Integer)memory.get("drLength");
        memory.remove("drLength");
        if (drLength % 2 == 1) {
            this.streamHandler.data(new ByteDataReference(0L));
            ++drLength;
        }
        if (drLength > 255) {
            throw new HandlerException("Invalid Directory Record Length: " + drLength);
        }
        Fixup drLengthFixup = (Fixup)memory.get("drLengthFixup");
        drLengthFixup.data(new ByteDataReference(drLength));
        drLengthFixup.close();
        memory.remove("drLengthFixup");
        return memory;
    }

    HashMap doFakeDR(ISO9660Directory dir2) throws HandlerException {
        ISO9660File file = new ISO9660File(dir2.getName());
        file.setIsMovedDirectory();
        ISO9660DirectoryRecord dr = new ISO9660DirectoryRecord(this.streamHandler, file, this.helper);
        HashMap memory = dr.doDR();
        Fixup locationFixup = (Fixup)memory.get("drLocationFixup");
        this.emptyFileFixups.add(locationFixup);
        Fixup dataLengthFixup = (Fixup)memory.get("drDataLengthFixup");
        dataLengthFixup.data(new BothWordDataReference(0L));
        dataLengthFixup.close();
        return memory;
    }

    HashMap doDR(ISO9660File file) throws HandlerException {
        ISO9660DirectoryRecord dr = new ISO9660DirectoryRecord(this.streamHandler, file, this.helper);
        HashMap memory = dr.doDR();
        Fixup locationFixup = (Fixup)memory.get("drLocationFixup");
        if (this.fileFixups.containsKey(file.getID())) {
            throw new RuntimeException("Duplicate file encountered: " + file.getISOPath());
        }
        this.fileFixups.put(file.getID(), locationFixup);
        Fixup dataLengthFixup = (Fixup)memory.get("drDataLengthFixup");
        dataLengthFixup.data(new BothWordDataReference(file.length()));
        dataLengthFixup.close();
        return memory;
    }

    HashMap doDR(ISO9660Directory dir2) throws HandlerException {
        ISO9660DirectoryRecord dr = new ISO9660DirectoryRecord(this.streamHandler, dir2, this.helper);
        HashMap memory = dr.doDR();
        DirFixupPair dirFixupPair = new DirFixupPair();
        dirFixupPair.location = (Fixup)memory.get("drLocationFixup");
        dirFixupPair.length = (Fixup)memory.get("drDataLengthFixup");
        this.dirFixups.put(dir2, dirFixupPair);
        return memory;
    }

    HashMap doDotDR(ISO9660Directory dir2) throws HandlerException {
        Object dot = dir2 == this.root ? ISO9660Constants.FI_ROOT : ISO9660Constants.FI_DOT;
        ISO9660DirectoryRecord dr = new ISO9660DirectoryRecord(this.streamHandler, dot, dir2, this.helper);
        return dr.doDR();
    }

    HashMap doDotDotDR(ISO9660Directory dir2) throws HandlerException {
        ISO9660Directory parentDir = dir2.getParentDirectory();
        Object dotdot = ISO9660Constants.FI_DOTDOT;
        ISO9660DirectoryRecord dr = new ISO9660DirectoryRecord(this.streamHandler, dotdot, parentDir, this.helper);
        return dr.doDR();
    }

    private void doBlockCheck(long position) throws HandlerException {
        int length = (int)((this.streamHandler.mark() - position) % 2048L);
        int rest = 2048 - length;
        if (rest < 255) {
            this.streamHandler.data(new EmptyByteArrayDataReference(rest));
        }
    }

    public void doFileFixup(ISO9660File file) throws HandlerException {
        if (!this.fileFixups.containsKey(file.getID())) {
            throw new RuntimeException("File " + file.getID() + " missing: " + file.getISOPath());
        }
        Fixup locationFixup = (Fixup)this.fileFixups.get(file.getID());
        int location = this.helper.getCurrentLocation();
        if (this.locationFixups.containsKey(file.getContentID())) {
            location = (Integer)this.locationFixups.get(file.getContentID());
        } else {
            this.locationFixups.put(file.getContentID(), new Integer(location));
        }
        locationFixup.data(new BothWordDataReference(location));
        locationFixup.close();
    }

    public void doEmptyFileFixups() throws HandlerException {
        Iterator it = this.emptyFileFixups.iterator();
        while (it.hasNext()) {
            this.streamHandler.startElement(new LogicalSectorElement("DUMMY"));
            int location = this.helper.getCurrentLocation();
            Fixup locationFixup = (Fixup)it.next();
            locationFixup.data(new BothWordDataReference(location));
            locationFixup.close();
            this.streamHandler.endElement();
        }
    }

    class DirFixupPair {
        Fixup location;
        Fixup length;

        DirFixupPair() {
        }
    }

    class ParentInfo {
        int location;
        int length;

        ParentInfo() {
        }
    }
}

