/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660Directory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660File;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.LayoutHelper;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660Constants;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660ShortDateDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.BothShortDataReference;
import de.tu_darmstadt.informatik.rbg.hatlak.sabre.impl.BothWordDataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.DataReference;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.Fixup;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.StreamHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ByteDataReference;
import java.util.Date;
import java.util.HashMap;

public class ISO9660DirectoryRecord {
    private StreamHandler streamHandler;
    private int volSeqNo;
    private DataReference filenameDataReference;
    public boolean hide;
    public boolean isDirectory;

    public ISO9660DirectoryRecord(StreamHandler streamHandler, ISO9660File file, LayoutHelper helper) throws HandlerException {
        this.init(streamHandler, helper);
        this.filenameDataReference = helper.getFilenameDataReference(file);
        this.isDirectory = false;
    }

    public ISO9660DirectoryRecord(StreamHandler streamHandler, ISO9660Directory dir2, LayoutHelper helper) throws HandlerException {
        this.init(streamHandler, helper);
        this.filenameDataReference = helper.getFilenameDataReference(dir2);
    }

    public ISO9660DirectoryRecord(StreamHandler streamHandler, Object object, ISO9660Directory dir2, LayoutHelper helper) throws HandlerException {
        this.init(streamHandler, helper);
        if (object == ISO9660Constants.FI_ROOT) {
            this.filenameDataReference = new ByteDataReference(0L);
        } else if (object == ISO9660Constants.FI_DOT) {
            this.filenameDataReference = new ByteDataReference(0L);
        } else if (object == ISO9660Constants.FI_DOTDOT) {
            this.filenameDataReference = new ByteDataReference(1L);
        } else {
            throw new HandlerException("Unknown special directory type, neither ROOT nor DOT nor DOTDOT: " + object);
        }
    }

    private void init(StreamHandler streamHandler, LayoutHelper helper) {
        this.streamHandler = streamHandler;
        this.volSeqNo = 1;
        this.hide = false;
        this.isDirectory = true;
    }

    public void setVolSeqNo(int value) {
        this.volSeqNo = value;
    }

    public void hide() {
        this.hide = true;
    }

    public HashMap doDR() throws HandlerException {
        HashMap<String, Object> memory = new HashMap<String, Object>();
        int length = 0;
        Fixup drLength = this.streamHandler.fixup(new ByteDataReference(0L));
        memory.put("drLengthFixup", drLength);
        ++length;
        Fixup extAttrRecordLengthFixup = this.streamHandler.fixup(new ByteDataReference(0L));
        memory.put("drExtAttrRecordLengthFixup", extAttrRecordLengthFixup);
        ++length;
        Fixup locationFixup = this.streamHandler.fixup(new BothWordDataReference(0L));
        memory.put("drLocationFixup", locationFixup);
        length += 8;
        Fixup dataLengthFixup = this.streamHandler.fixup(new BothWordDataReference(0L));
        memory.put("drDataLengthFixup", dataLengthFixup);
        length += 8;
        Date now = new Date();
        ISO9660ShortDateDataReference date = new ISO9660ShortDateDataReference(now);
        this.streamHandler.data(date);
        length = (int)((long)length + date.getLength());
        byte fileFlags = this.getFileFlags();
        this.streamHandler.data(new ByteDataReference(fileFlags));
        ++length;
        this.streamHandler.data(new ByteDataReference(0L));
        ++length;
        this.streamHandler.data(new ByteDataReference(0L));
        ++length;
        this.streamHandler.data(new BothShortDataReference(this.volSeqNo));
        length += 4;
        this.streamHandler.data(new ByteDataReference(this.filenameDataReference.getLength()));
        ++length;
        this.streamHandler.data(this.filenameDataReference);
        length = (int)((long)length + this.filenameDataReference.getLength());
        if (this.filenameDataReference.getLength() % 2L == 0L) {
            this.streamHandler.data(new ByteDataReference(0L));
            ++length;
        }
        memory.put("drLength", new Integer(length));
        return memory;
    }

    private byte getFileFlags() {
        byte flags = 0;
        if (this.hide) {
            flags = (byte)(flags | 1);
        }
        if (this.isDirectory) {
            flags = (byte)(flags | 2);
        }
        return flags;
    }
}

