/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl;

import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660Directory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660File;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.ISO9660RootDirectory;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.FileElement;
import de.tu_darmstadt.informatik.rbg.hatlak.iso9660.impl.ISO9660Element;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.Element;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.HandlerException;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.StreamHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.ChainingStreamHandler;
import de.tu_darmstadt.informatik.rbg.mhartle.sabre.impl.FileDataReference;
import java.util.Iterator;
import java.util.Vector;

public class FileHandler
extends ChainingStreamHandler {
    private ISO9660RootDirectory root;

    public FileHandler(StreamHandler streamHandler, ISO9660RootDirectory root) {
        super(streamHandler, streamHandler);
        this.root = root;
    }

    public void startElement(Element element) throws HandlerException {
        if (element instanceof ISO9660Element) {
            String id = (String)element.getId();
            this.process(id);
        }
        super.startElement(element);
    }

    private void process(String id) throws HandlerException {
        if (id.equals("FCA")) {
            this.doFCA();
        }
    }

    private void doFCA() throws HandlerException {
        this.doFCADirs(this.root);
        Iterator it = this.root.sortedIterator();
        while (it.hasNext()) {
            ISO9660Directory dir2 = (ISO9660Directory)it.next();
            this.doFCADirs(dir2);
        }
    }

    private void doFCADirs(ISO9660Directory dir2) throws HandlerException {
        Vector files2 = dir2.getFiles();
        Iterator fit = files2.iterator();
        while (fit.hasNext()) {
            ISO9660File file = (ISO9660File)fit.next();
            this.doFile(file);
        }
    }

    private void doFile(ISO9660File file) throws HandlerException {
        super.startElement(new FileElement(file));
        FileDataReference fdr = new FileDataReference(file);
        this.data(fdr);
        super.endElement();
    }
}

